/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.embed.postgresql;

import de.flapdoodle.embed.process.builder.AbstractBuilder;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.config.IRuntimeConfig;
import de.flapdoodle.embed.process.distribution.IVersion;
import de.flapdoodle.embed.process.io.directories.FixedPath;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.store.PostgresArtifactStoreBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import ru.yandex.qatools.embed.postgresql.Command;
import ru.yandex.qatools.embed.postgresql.PackagePaths;
import ru.yandex.qatools.embed.postgresql.PostgresExecutable;
import ru.yandex.qatools.embed.postgresql.PostgresProcess;
import ru.yandex.qatools.embed.postgresql.PostgresStarter;
import ru.yandex.qatools.embed.postgresql.config.AbstractPostgresConfig;
import ru.yandex.qatools.embed.postgresql.config.PostgresConfig;
import ru.yandex.qatools.embed.postgresql.config.PostgresDownloadConfigBuilder;
import ru.yandex.qatools.embed.postgresql.config.RuntimeConfigBuilder;
import ru.yandex.qatools.embed.postgresql.distribution.Version;
import ru.yandex.qatools.embed.postgresql.util.SocketUtil;

public class EmbeddedPostgres {
    public static final String DEFAULT_USER = "postgres";
    public static final String DEFAULT_PASSWORD = "postgres";
    public static final String DEFAULT_DB_NAME = "postgres";
    public static final String DEFAULT_HOST = "localhost";
    private static final List<String> DEFAULT_ADD_PARAMS = Arrays.asList("-E", "SQL_ASCII", "--locale=C", "--lc-collate=C", "--lc-ctype=C");
    private final IVersion version;
    private PostgresProcess process;
    private PostgresConfig config;

    public EmbeddedPostgres() {
        this(Version.Main.PRODUCTION);
    }

    public EmbeddedPostgres(IVersion version) {
        this.version = version;
    }

    public static IRuntimeConfig defaultRuntimeConfig() {
        return new RuntimeConfigBuilder().defaults(Command.Postgres).artifactStore((AbstractBuilder)new PostgresArtifactStoreBuilder().defaults(Command.Postgres).download(new PostgresDownloadConfigBuilder().defaultsForCommand(Command.Postgres).build())).build();
    }

    public static IRuntimeConfig cachedRuntimeConfig(Path cachedPath) {
        Command cmd = Command.Postgres;
        FixedPath cachedDir = new FixedPath(cachedPath.toString());
        return new RuntimeConfigBuilder().defaults(cmd).artifactStore((AbstractBuilder)new PostgresArtifactStoreBuilder().defaults(cmd).tempDir((IDirectory)cachedDir).download(new PostgresDownloadConfigBuilder().defaultsForCommand(cmd).packageResolver(new PackagePaths(cmd, (IDirectory)cachedDir)).build())).build();
    }

    public String start() throws IOException {
        return this.start(DEFAULT_HOST, SocketUtil.findFreePort(), "postgres");
    }

    public String start(String host, int port, String dbName) throws IOException {
        return this.start(host, port, dbName, "postgres", "postgres", DEFAULT_ADD_PARAMS);
    }

    public String start(String host, int port, String dbName, String user, String password) throws IOException {
        return this.start(EmbeddedPostgres.defaultRuntimeConfig(), host, port, dbName, user, password, DEFAULT_ADD_PARAMS);
    }

    public String start(String host, int port, String dbName, String user, String password, List<String> additionalParams) throws IOException {
        return this.start(EmbeddedPostgres.defaultRuntimeConfig(), host, port, dbName, user, password, additionalParams);
    }

    public String start(IRuntimeConfig runtimeConfig) throws IOException {
        return this.start(runtimeConfig, DEFAULT_HOST, SocketUtil.findFreePort(), "postgres", "postgres", "postgres", DEFAULT_ADD_PARAMS);
    }

    public String start(IRuntimeConfig runtimeConfig, String host, int port, String dbName, String user, String password, List<String> additionalParams) throws IOException {
        PostgresStarter<PostgresExecutable, PostgresProcess> runtime = PostgresStarter.getInstance(runtimeConfig);
        this.config = new PostgresConfig(this.version, new AbstractPostgresConfig.Net(host, port), new AbstractPostgresConfig.Storage(dbName), new AbstractPostgresConfig.Timeout(), new AbstractPostgresConfig.Credentials(user, password));
        this.config.getAdditionalInitDbParams().addAll(additionalParams);
        PostgresExecutable exec = (PostgresExecutable)runtime.prepare((IExecutableProcessConfig)this.config);
        this.process = (PostgresProcess)exec.start();
        return this.formatConnUrl(this.config);
    }

    public Optional<PostgresConfig> getConfig() {
        return Optional.ofNullable(this.config);
    }

    public Optional<PostgresProcess> getProcess() {
        return Optional.ofNullable(this.process);
    }

    public Optional<String> getConnectionUrl() {
        return this.getConfig().map(this::formatConnUrl);
    }

    private String formatConnUrl(PostgresConfig config) {
        return String.format("jdbc:postgresql://%s:%s/%s?user=%s&password=%s", config.net().host(), config.net().port(), config.storage().dbName(), config.credentials().username(), config.credentials().password());
    }

    public void stop() {
        this.getProcess().orElseThrow(() -> new IllegalStateException("Cannot stop not started instance!")).stop();
    }
}

