/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.embed.postgresql.ext;

import de.flapdoodle.embed.process.config.store.FileSet;
import de.flapdoodle.embed.process.config.store.FileType;
import de.flapdoodle.embed.process.config.store.IDownloadConfig;
import de.flapdoodle.embed.process.distribution.Distribution;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import de.flapdoodle.embed.process.extract.ITempNaming;
import de.flapdoodle.embed.process.extract.ImmutableExtractedFileSet;
import de.flapdoodle.embed.process.io.directories.IDirectory;
import de.flapdoodle.embed.process.store.IDownloader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.qatools.embed.postgresql.ext.EmptyFileSet;
import ru.yandex.qatools.embed.postgresql.ext.PostgresArtifactStore;

public class CachedPostgresArtifactStore
extends PostgresArtifactStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedPostgresArtifactStore.class);
    private IDownloadConfig downloadConfig;
    private IDirectory eDir;

    public CachedPostgresArtifactStore(IDownloadConfig downloadConfig, IDirectory eDir, ITempNaming executableNaming, IDownloader downloader) {
        super(downloadConfig, eDir, executableNaming, downloader);
        this.downloadConfig = downloadConfig;
        this.eDir = eDir;
    }

    @Override
    public void removeFileSet(Distribution distribution, IExtractedFileSet all) {
    }

    @Override
    public IExtractedFileSet extractFileSet(Distribution distribution) throws IOException {
        try {
            File dir = this.eDir.asFile();
            FileSet filesSet = this.downloadConfig.getPackageResolver().getFileSet(distribution);
            if (dir.exists() && dir.isDirectory() && filesSet.entries().stream().allMatch(entry -> Files.exists(Paths.get(dir.getPath(), "pgsql", "bin"), new LinkOption[0]))) {
                ImmutableExtractedFileSet.Builder extracted = ImmutableExtractedFileSet.builder((File)dir).baseDirIsGenerated(false);
                FileUtils.iterateFiles((File)dir, (IOFileFilter)TrueFileFilter.TRUE, (IOFileFilter)TrueFileFilter.TRUE).forEachRemaining(file -> {
                    FileType type = FileType.Library;
                    for (FileSet.Entry entry : filesSet.entries()) {
                        if (!entry.matchingPattern().matcher(file.getPath()).matches()) continue;
                        type = FileType.Executable;
                    }
                    extracted.file(type, file);
                });
                return extracted.build();
            }
            return super.extractFileSet(distribution);
        }
        catch (Exception e) {
            LOGGER.error("Failed to extract file set", (Throwable)e);
            return new EmptyFileSet();
        }
    }
}

