/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.extensions.processor.js.AbstractLinterProcessor;
import ro.isdc.wro.extensions.processor.js.JsHintProcessor;
import ro.isdc.wro.extensions.processor.support.linter.LinterError;
import ro.isdc.wro.extensions.processor.support.linter.LinterException;
import ro.isdc.wro.extensions.support.lint.LintReport;
import ro.isdc.wro.extensions.support.lint.ReportXmlFormatter;
import ro.isdc.wro.extensions.support.lint.ResourceLintReport;
import ro.isdc.wro.maven.plugin.AbstractLinterMojo;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsHintMojo
extends AbstractLinterMojo<LinterError> {
    private File reportFile;
    private String reportFormat = ReportXmlFormatter.FormatterType.JSLINT.getFormat();
    private int failThreshold = 0;
    private int totalResources = 0;
    private int totalResourcesWithErrors = 0;
    private int totalFoundErrors = 0;

    @Override
    protected ResourcePreProcessor createResourceProcessor() {
        AbstractLinterProcessor processor = new JsHintProcessor(){

            public void process(Resource resource, Reader reader, Writer writer) throws IOException {
                JsHintMojo.this.totalResources++;
                JsHintMojo.this.getLog().info((CharSequence)("processing resource: " + resource));
                super.process(resource, reader, (Writer)new StringWriter());
            }

            protected void onException(WroRuntimeException e) {
                JsHintMojo.this.onException((Exception)e);
            }

            protected void onLinterException(LinterException e, Resource resource) {
                String errorMessage = String.format("%s errors found while processing resource: %s. Errors are: %s", e.getErrors().size(), resource, e.getErrors());
                JsHintMojo.this.totalResourcesWithErrors++;
                JsHintMojo.this.totalFoundErrors += e.getErrors().size();
                JsHintMojo.this.getLog().error((CharSequence)errorMessage);
                JsHintMojo.this.addReport(ResourceLintReport.create((String)resource.getUri(), (Collection)e.getErrors()));
                if (!JsHintMojo.this.isFailNever() && JsHintMojo.this.totalFoundErrors >= JsHintMojo.this.failThreshold) {
                    throw new WroRuntimeException("Errors found when validating resource: " + resource);
                }
            }
        }.setOptionsAsString(this.getOptions());
        return processor;
    }

    @Override
    protected void onBeforeExecute() {
        this.totalFoundErrors = 0;
        this.totalResources = 0;
        this.totalResourcesWithErrors = 0;
        super.onBeforeExecute();
    }

    @Override
    protected void onAfterExecute() {
        this.logSummary();
        super.onAfterExecute();
    }

    private void logSummary() {
        String message = this.totalFoundErrors == 0 ? "JSHINT found no errors." : String.format("JSHINT found %s errors in %s files.", this.totalFoundErrors, this.totalResourcesWithErrors);
        this.getLog().info((CharSequence)"----------------------------------------");
        this.getLog().info((CharSequence)String.format("Total number of processed resources: %s", this.totalResources));
        this.getLog().info((CharSequence)message);
        this.getLog().info((CharSequence)"----------------------------------------\n");
    }

    @Override
    protected ReportXmlFormatter createXmlFormatter(LintReport<LinterError> lintReport, ReportXmlFormatter.FormatterType type) {
        return ReportXmlFormatter.createForLinterError(lintReport, (ReportXmlFormatter.FormatterType)type);
    }

    @Override
    protected File getReportFile() {
        return this.reportFile;
    }

    @Override
    protected String getReportFormat() {
        return this.reportFormat;
    }

    void setReportFile(File reportFile) {
        this.reportFile = reportFile;
    }

    void setReportFormat(String reportFormat) {
        this.reportFormat = reportFormat;
    }

    void setFailThreshold(int failThreshold) {
        this.failThreshold = failThreshold;
    }

    @Override
    void onException(Exception e) {
    }
}

