/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.support.sass;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;

public class RubySassEngine {
    private static final Logger LOG = LoggerFactory.getLogger(RubySassEngine.class);
    private static final String RUBY_GEM_REQUIRE = "rubygems";
    private static final String SASS_PLUGIN_REQUIRE = "sass/plugin";
    private static final String SASS_ENGINE_REQUIRE = "sass/engine";
    private final Set<String> requires = new LinkedHashSet<String>();

    public RubySassEngine() {
        this.requires.add(RUBY_GEM_REQUIRE);
        this.requires.add(SASS_PLUGIN_REQUIRE);
        this.requires.add(SASS_ENGINE_REQUIRE);
    }

    public void addRequire(String require) {
        if (require != null && require.trim().length() > 0) {
            this.requires.add(require.trim());
        }
    }

    public synchronized String process(String content) {
        if (StringUtils.isEmpty((CharSequence)content)) {
            return "";
        }
        try {
            ScriptEngine rubyEngine = new ScriptEngineManager().getEngineByName("jruby");
            return rubyEngine.eval(this.buildUpdateScript(content)).toString();
        }
        catch (ScriptException e) {
            throw new WroRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private String buildUpdateScript(String content) {
        Validate.notNull((Object)content);
        StringWriter raw = new StringWriter();
        PrintWriter script = new PrintWriter(raw);
        StringBuilder sb = new StringBuilder();
        sb.append(":syntax => :scss");
        for (String require : this.requires) {
            script.println("  require '" + require + "'                                   ");
        }
        String scriptAsString = String.format("result = Sass::Engine.new('%s', {%s}).render", content.replace("'", "\""), sb.toString());
        LOG.debug("scriptAsString: {}", (Object)scriptAsString);
        script.println(scriptAsString);
        script.flush();
        return raw.toString();
    }
}

