/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.support;

import com.google.javascript.jscomp.CompilationLevel;
import java.util.HashMap;
import java.util.Map;
import ro.isdc.wro.extensions.processor.css.BourbonCssProcessor;
import ro.isdc.wro.extensions.processor.css.CssLintProcessor;
import ro.isdc.wro.extensions.processor.css.Less4jProcessor;
import ro.isdc.wro.extensions.processor.css.LessCssProcessor;
import ro.isdc.wro.extensions.processor.css.NodeLessCssProcessor;
import ro.isdc.wro.extensions.processor.css.RhinoLessCssProcessor;
import ro.isdc.wro.extensions.processor.css.RubySassCssProcessor;
import ro.isdc.wro.extensions.processor.css.SassCssProcessor;
import ro.isdc.wro.extensions.processor.css.YUICssCompressorProcessor;
import ro.isdc.wro.extensions.processor.js.BeautifyJsProcessor;
import ro.isdc.wro.extensions.processor.js.CJsonProcessor;
import ro.isdc.wro.extensions.processor.js.CoffeeScriptProcessor;
import ro.isdc.wro.extensions.processor.js.DojoShrinksafeCompressorProcessor;
import ro.isdc.wro.extensions.processor.js.DustJsProcessor;
import ro.isdc.wro.extensions.processor.js.EmberJsProcessor;
import ro.isdc.wro.extensions.processor.js.GoogleClosureCompressorProcessor;
import ro.isdc.wro.extensions.processor.js.HandlebarsJsProcessor;
import ro.isdc.wro.extensions.processor.js.HoganJsProcessor;
import ro.isdc.wro.extensions.processor.js.JsHintProcessor;
import ro.isdc.wro.extensions.processor.js.JsLintProcessor;
import ro.isdc.wro.extensions.processor.js.JsonHPackProcessor;
import ro.isdc.wro.extensions.processor.js.NodeCoffeeScriptProcessor;
import ro.isdc.wro.extensions.processor.js.PackerJsProcessor;
import ro.isdc.wro.extensions.processor.js.RhinoCoffeeScriptProcessor;
import ro.isdc.wro.extensions.processor.js.TypeScriptProcessor;
import ro.isdc.wro.extensions.processor.js.UglifyJsProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.decorator.LazyProcessorDecorator;
import ro.isdc.wro.model.resource.processor.decorator.ProcessorDecorator;
import ro.isdc.wro.model.resource.processor.support.ProcessorProvider;
import ro.isdc.wro.util.LazyInitializer;

public class DefaultProcessorProvider
implements ProcessorProvider {
    public Map<String, ResourcePreProcessor> providePreProcessors() {
        return this.createMap();
    }

    public Map<String, ResourcePostProcessor> providePostProcessors() {
        HashMap<String, ResourcePostProcessor> resultMap = new HashMap<String, ResourcePostProcessor>();
        Map<String, ResourcePreProcessor> preProcessorsMap = this.createMap();
        for (Map.Entry<String, ResourcePreProcessor> entry : preProcessorsMap.entrySet()) {
            resultMap.put(entry.getKey(), (ResourcePostProcessor)new ProcessorDecorator((Object)entry.getValue()));
        }
        return resultMap;
    }

    private Map<String, ResourcePreProcessor> createMap() {
        HashMap<String, ResourcePreProcessor> map = new HashMap<String, ResourcePreProcessor>();
        map.put("yuiCssMin", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return new YUICssCompressorProcessor();
            }
        }));
        map.put("dojoShrinksafe", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return new DojoShrinksafeCompressorProcessor();
            }
        }));
        map.put("uglifyJs", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return new UglifyJsProcessor();
            }
        }));
        map.put("beautifyJs", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return new BeautifyJsProcessor();
            }
        }));
        map.put("packerJs", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return new PackerJsProcessor();
            }
        }));
        map.put("rhinoLessCss", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return new RhinoLessCssProcessor();
            }
        }));
        map.put("nodeLessCss", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return new NodeLessCssProcessor();
            }
        }));
        map.put("less4j", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return new Less4jProcessor();
            }
        }));
        map.put("lessCss", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return new LessCssProcessor();
            }
        }));
        map.put("sassCss", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return new SassCssProcessor();
            }
        }));
        map.put("rubySassCss", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return new RubySassCssProcessor();
            }
        }));
        map.put("bourbonCss", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return new BourbonCssProcessor();
            }
        }));
        map.put("googleClosureSimple", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return new GoogleClosureCompressorProcessor(CompilationLevel.SIMPLE_OPTIMIZATIONS);
            }
        }));
        map.put("googleClosureAdvanced", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return new GoogleClosureCompressorProcessor(CompilationLevel.ADVANCED_OPTIMIZATIONS);
            }
        }));
        map.put("googleClosureWhitespace", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return new GoogleClosureCompressorProcessor(CompilationLevel.WHITESPACE_ONLY);
            }
        }));
        map.put("rhinoCoffeeScript", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return new RhinoCoffeeScriptProcessor();
            }
        }));
        map.put("nodeCoffeeScript", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return new NodeCoffeeScriptProcessor();
            }
        }));
        map.put("coffeeScript", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return new CoffeeScriptProcessor();
            }
        }));
        map.put("cjson-pack", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return CJsonProcessor.packProcessor();
            }
        }));
        map.put("cjson-unpack", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return CJsonProcessor.unpackProcessor();
            }
        }));
        map.put("jsonh-pack", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return JsonHPackProcessor.packProcessor();
            }
        }));
        map.put("jsonh-unpack", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return JsonHPackProcessor.unpackProcessor();
            }
        }));
        map.put("jsHint", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return new JsHintProcessor();
            }
        }));
        map.put("jsLint", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return new JsLintProcessor();
            }
        }));
        map.put("cssLint", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return new CssLintProcessor();
            }
        }));
        map.put("dustJs", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return new DustJsProcessor();
            }
        }));
        map.put("hoganJs", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return new HoganJsProcessor();
            }
        }));
        map.put("handlebarsJs", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return new HandlebarsJsProcessor();
            }
        }));
        map.put("typeScript", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return new TypeScriptProcessor();
            }
        }));
        map.put("emberJs", (ResourcePreProcessor)new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return new EmberJsProcessor();
            }
        }));
        return map;
    }
}

