/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.js;

import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.group.processor.Minimize;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.util.StopWatch;

@Minimize
@SupportedResourceType(value=ResourceType.JS)
public final class YUIJsCompressorProcessor
implements ResourcePostProcessor,
ResourcePreProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(YUIJsCompressorProcessor.class);
    public static final String ALIAS_NO_MUNGE = "yuiJsMin";
    public static final String ALIAS_MUNGE = "yuiJsMinAdvanced";
    private final int linebreakpos = -1;
    private boolean munge = false;
    private final boolean verbose = false;
    private final boolean preserveAllSemiColons = true;
    private final boolean disableOptimizations = false;

    private YUIJsCompressorProcessor(boolean munge) {
        this.munge = munge;
    }

    public static YUIJsCompressorProcessor doMungeCompressor() {
        return new YUIJsCompressorProcessor(true);
    }

    public static YUIJsCompressorProcessor noMungeCompressor() {
        return new YUIJsCompressorProcessor(false);
    }

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        StopWatch watch = new StopWatch();
        watch.start("pack");
        String content = IOUtils.toString((Reader)reader);
        try {
            JavaScriptCompressor compressor = new JavaScriptCompressor(new StringReader(content), new YUIErrorReporter());
            compressor.compress(writer, -1, this.munge, false, true, false);
        }
        catch (Exception e) {
            String resourceUri = resource == null ? "" : "[" + resource.getUri() + "]";
            LOG.error("Exception while applying " + this.getClass().getSimpleName() + " processor on the " + resourceUri + " resource, no processing applied...", (Throwable)e);
            this.onException(new WroRuntimeException("Exception during processing", (Throwable)e));
        }
        finally {
            reader.close();
            writer.close();
            watch.stop();
            LOG.debug(watch.prettyPrint());
        }
    }

    protected void onException(WroRuntimeException e) {
        throw e;
    }

    private static final class YUIErrorReporter
    implements ErrorReporter {
        private YUIErrorReporter() {
        }

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                LOG.warn("\n[WARNING] " + message);
            } else {
                LOG.warn("\n[WARNING] " + line + ':' + lineOffset + ':' + message);
            }
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            if (line < 0) {
                LOG.error("\n[ERROR] " + message);
            } else {
                LOG.error("\n[ERROR] " + line + ':' + lineOffset + ':' + message);
            }
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            this.error(message, sourceName, line, lineSource, lineOffset);
            return new EvaluatorException(message);
        }
    }
}

