/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.extensions.processor.css;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.extensions.processor.css.NodeLessCssProcessor;
import ro.isdc.wro.extensions.processor.css.RhinoLessCssProcessor;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.ResourceType;
import ro.isdc.wro.model.resource.SupportedResourceType;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.model.resource.processor.decorator.LazyProcessorDecorator;
import ro.isdc.wro.model.resource.processor.decorator.ProcessorDecorator;
import ro.isdc.wro.util.LazyInitializer;

@SupportedResourceType(value=ResourceType.CSS)
public class LessCssProcessor
implements ResourcePreProcessor,
ResourcePostProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(LessCssProcessor.class);
    public static final String ALIAS = "lessCss";
    private final ResourcePreProcessor lessProcessor = this.initializeProcessor();

    private ResourcePreProcessor initializeProcessor() {
        ProcessorDecorator processor = new ProcessorDecorator((Object)this.createNodeProcessor());
        return processor.isSupported() ? processor : this.createRhinoProcessor();
    }

    protected NodeLessCssProcessor createNodeProcessor() {
        LOG.debug("creating NodeLess processor");
        return new NodeLessCssProcessor();
    }

    public void process(Resource resource, Reader reader, Writer writer) throws IOException {
        this.lessProcessor.process(resource, reader, writer);
    }

    public void process(Reader reader, Writer writer) throws IOException {
        this.process(null, reader, writer);
    }

    protected ResourcePreProcessor createRhinoProcessor() {
        LOG.debug("NodeLess is not supported. Using fallback RhinoLess processor");
        return new LazyProcessorDecorator((LazyInitializer)new LazyInitializer<ResourcePreProcessor>(){

            protected ResourcePreProcessor initialize() {
                return new RhinoLessCssProcessor();
            }
        });
    }
}

