/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.processor.ResourcePostProcessor;
import ro.isdc.wro.model.resource.processor.ResourcePreProcessor;
import ro.isdc.wro.util.ResourceProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WroUtil {
    private static final Logger LOG = LoggerFactory.getLogger(WroUtil.class);
    public static Pattern EMTPY_LINE_PATTERN = Pattern.compile("^[\\t ]*$\\r?\\n", 8);
    private static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"E, dd MMM yyyy HH:mm:ss z", (TimeZone)TimeZone.getTimeZone("GMT"));
    private static final Pattern PATTERN_ACCEPT_ENCODING = Pattern.compile("^(Accept-Encoding|Accept-EncodXng|X-cept-Encoding|X{15}|~{15}|-{15})$", 2);
    private static final Pattern PATTERN_GZIP = Pattern.compile("^((gzip|deflate)\\s?,?\\s?(gzip|deflate)?|X{4,13}|~{4,13}|-{4,13})$", 2);

    public static String toDateAsString(long milliseconds) {
        return DATE_FORMAT.format(milliseconds);
    }

    public static String getPathInfoFromLocation(String location) {
        if (StringUtils.isEmpty((String)location)) {
            throw new IllegalArgumentException("Location cannot be empty string!");
        }
        String noSlash = location.substring(1);
        int nextSlash = noSlash.indexOf(47);
        if (nextSlash == -1) {
            return "";
        }
        String pathInfo = noSlash.substring(nextSlash);
        return pathInfo;
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return WroUtil.startsWith(str, prefix, true);
    }

    public static String toPackageAsFolder(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class cannot be null!");
        }
        return clazz.getPackage().getName().replace('.', '/');
    }

    private static boolean startsWith(String str, String prefix, boolean ignoreCase) {
        if (str == null || prefix == null) {
            return str == null && prefix == null;
        }
        if (prefix.length() > str.length()) {
            return false;
        }
        return str.regionMatches(ignoreCase, 0, prefix, 0, prefix.length());
    }

    public static String getServletPathFromLocation(String location) {
        return location.replace(WroUtil.getPathInfoFromLocation(location), "");
    }

    public static boolean isGzipSupported(HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames != null) {
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                Matcher m = PATTERN_ACCEPT_ENCODING.matcher(headerName);
                if (!m.find()) continue;
                String headerValue = request.getHeader(headerName);
                Matcher mValue = PATTERN_GZIP.matcher(headerValue);
                return mValue.find();
            }
        }
        return false;
    }

    public static String toJSMultiLineString(String data) {
        String[] lines = data.split("\\n");
        StringBuffer result = new StringBuffer("[\"\"");
        for (String line : lines) {
            result.append(", \"" + line.replace("\\", "\\\\").replace("\"", "\\\"").replaceAll("\\r|\\n", "") + "\"");
        }
        result.append("].join(\"\\n\")");
        return result.toString();
    }

    private static boolean headerContains(HttpServletRequest request, String header, String value) {
        Enumeration headerValues = request.getHeaders(header);
        if (headerValues != null) {
            while (headerValues.hasMoreElements()) {
                String headerValue = (String)headerValues.nextElement();
                if (headerValue.indexOf(value) == -1) continue;
                return true;
            }
        }
        return false;
    }

    public static ThreadFactory createDaemonThreadFactory() {
        final ThreadFactory backingThreadFactory = Executors.defaultThreadFactory();
        return new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread thread = backingThreadFactory.newThread(runnable);
                thread.setDaemon(true);
                return thread;
            }
        };
    }

    public static String getFilterPath(String filterName, InputStream is) throws ServletException {
        if (filterName == null) {
            throw new IllegalArgumentException("filterName cannot be null!");
        }
        if (is == null) {
            throw new IllegalArgumentException("InputStream cannot be null!");
        }
        String prefix = "filter";
        String mapping = "filter-mapping";
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            Document document = factory.newDocumentBuilder().parse(is);
            document.getDocumentElement().normalize();
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xpath = xPathFactory.newXPath();
            XPathExpression filterNameExpression = xpath.compile("//filter-mapping/filter-name/text()");
            XPathExpression urlPatternExpression = xpath.compile("url-pattern/text()");
            Object result = filterNameExpression.evaluate(document, XPathConstants.NODESET);
            String urlPattern = null;
            NodeList nodes = (NodeList)result;
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                LOG.debug("node: " + node);
                if (!filterName.equals(node.getTextContent())) continue;
                Node filterMappingNode = node.getParentNode().getParentNode();
                LOG.debug("filterMappingNode: " + filterMappingNode);
                urlPattern = urlPatternExpression.evaluate(filterMappingNode);
                LOG.debug("urlPattern: " + urlPattern);
            }
            String prefixUppered = Character.toUpperCase("filter".charAt(0)) + "filter".substring(1);
            if (!urlPattern.startsWith("/") || !urlPattern.endsWith("*")) {
                throw new IllegalArgumentException("<filter-mapping> for WroFilter" + prefixUppered + " \"" + filterName + "\" must start with '/' and end with '*'.");
            }
            return WroUtil.stripWildcard(urlPattern);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new ServletException("Error finding <filter> " + filterName + " in web.xml", (Throwable)e);
        }
    }

    private static String stripWildcard(String result) {
        return result.substring(1, result.length() - 1);
    }

    public static ResourceProcessor newResourceProcessor(ResourcePreProcessor preProcessor) {
        return WroUtil.newResourceProcessor(null, preProcessor);
    }

    public static ResourceProcessor newResourceProcessor(final Resource resource, final ResourcePreProcessor preProcessor) {
        return new ResourceProcessor(){

            public void process(Reader reader, Writer writer) throws IOException {
                preProcessor.process(resource, reader, writer);
            }
        };
    }

    public static ResourceProcessor newResourceProcessor(final ResourcePostProcessor postProcessor) {
        return new ResourceProcessor(){

            public void process(Reader reader, Writer writer) throws IOException {
                postProcessor.process(reader, writer);
            }
        };
    }
}

