/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.algorithm;

import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.model.resource.processor.algorithm.CSSMin;
import ro.isdc.wro.model.resource.processor.algorithm.Value;

class Property
implements Comparable {
    private static final Logger LOG = LoggerFactory.getLogger(CSSMin.class);
    protected String property;
    protected Value[] values;

    public Property(String property) throws Exception {
        try {
            String[] parts = property.split(":");
            if (parts.length < 2) {
                throw new Exception("Warning: Incomplete property: " + property);
            }
            this.property = parts[0].trim().toLowerCase();
            this.values = this.parseValues(parts[1].trim().replaceAll(", ", ","));
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.property).append(":");
        for (Value v : this.values) {
            sb.append(v.toString()).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(";");
        return sb.toString();
    }

    public int compareTo(Object other) {
        return this.property.compareTo(((Property)other).property);
    }

    private Value[] parseValues(String contents) {
        String[] parts = contents.split(",");
        Value[] results = new Value[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            try {
                results[i] = new Value(parts[i]);
                continue;
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
                results[i] = null;
            }
        }
        return results;
    }
}

