/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.processor.algorithm;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.util.Base64;

public class DataUriGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(DataUriGenerator.class);
    private static final String DATA_URI_PREFIX = "data:";
    private final Map<String, String> binaryTypes = new HashMap<String, String>();
    private final Map<String, String> textTypes = new HashMap<String, String>();

    public DataUriGenerator() {
        this.initTypes();
    }

    public String generateDataURI(InputStream inputStream, String fileName) throws IOException {
        StringWriter writer = new StringWriter();
        this.generateDataURI(inputStream, (Writer)writer, fileName);
        return writer.toString();
    }

    public static boolean isDataUri(String url) {
        return url.startsWith(DATA_URI_PREFIX);
    }

    private void initTypes() {
        this.binaryTypes.put("gif", "image/gif");
        this.binaryTypes.put("jpg", "image/jpeg");
        this.binaryTypes.put("png", "image/png");
        this.binaryTypes.put("jpeg", "image/jpeg");
        this.textTypes.put("htm", "text/html");
        this.textTypes.put("html", "text/html");
        this.textTypes.put("xml", "application/xml");
        this.textTypes.put("xhtml", "application/xhtml+xml");
        this.textTypes.put("js", "application/x-javascript");
        this.textTypes.put("css", "text/css");
        this.textTypes.put("txt", "text/plain");
    }

    private void generateDataURI(InputStream inputStream, Writer out, String fileName, String mimeType) throws IOException {
        byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
        inputStream.close();
        mimeType = this.getMimeType(fileName, mimeType);
        this.generateDataURI(bytes, out, mimeType);
    }

    private void generateDataURI(InputStream inputStream, Writer out, String fileName) throws IOException {
        this.generateDataURI(inputStream, out, fileName, null);
    }

    private void generateDataURI(byte[] bytes, Writer out, String mimeType) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(DATA_URI_PREFIX);
        buffer.append(mimeType);
        buffer.append(";base64,");
        buffer.append(new String(Base64.encodeBytes(bytes)));
        out.write(buffer.toString());
    }

    private String getMimeType(String filename, String mimeType) throws IOException {
        if (mimeType == null) {
            String type = FilenameUtils.getExtension((String)filename);
            if (this.binaryTypes.containsKey(type)) {
                mimeType = this.binaryTypes.get(type);
            } else if (this.textTypes.containsKey(type)) {
                mimeType = this.textTypes.get(type) + ";charset=UTF-8";
            } else {
                throw new IOException("No MIME type provided and MIME type couldn't be automatically determined.");
            }
            LOG.debug("No MIME type provided, defaulting to '" + mimeType + "'.");
        }
        return mimeType;
    }
}

