/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.factory;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.group.Inject;
import ro.isdc.wro.model.resource.DuplicateResourceDetector;
import ro.isdc.wro.model.resource.locator.UriLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UriLocatorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(UriLocatorFactory.class);
    private final List<UriLocator> uriLocators = new ArrayList<UriLocator>();
    private final DuplicateResourceDetector duplicateResourceDetector;

    public UriLocatorFactory(DuplicateResourceDetector duplicateResourceDetector) {
        this.duplicateResourceDetector = duplicateResourceDetector;
    }

    public InputStream locate(String uri) throws IOException {
        UriLocator uriLocator = this.getInstance(uri);
        if (uriLocator == null) {
            throw new IOException("No locator is capable of handling uri: " + uri);
        }
        LOG.debug("locating uri: " + uri + ", using locator: " + uriLocator);
        return uriLocator.locate(uri);
    }

    private UriLocator getInstance(String uri) {
        for (UriLocator uriLocator : this.uriLocators) {
            if (!uriLocator.accept(uri)) continue;
            return uriLocator;
        }
        return null;
    }

    private final void addUriLocator(UriLocator uriLocator) {
        if (uriLocator == null) {
            throw new IllegalArgumentException("ResourceLocator cannot be null!");
        }
        this.processInjectAnnotation(uriLocator);
        this.uriLocators.add(uriLocator);
    }

    public final void addUriLocator(UriLocator ... locators) {
        for (UriLocator locator : locators) {
            this.addUriLocator(locator);
        }
    }

    private void processInjectAnnotation(Object locator) {
        try {
            Collection<Field> fields = this.getAllFields(locator);
            for (Field field : fields) {
                if (!field.isAnnotationPresent(Inject.class)) continue;
                if (field.getType() != DuplicateResourceDetector.class) {
                    throw new IllegalStateException("@Inject can be applied only on fields of " + DuplicateResourceDetector.class.getName() + " type");
                }
                if (this.duplicateResourceDetector == null) {
                    throw new IllegalStateException(DuplicateResourceDetector.class.getSimpleName() + " cannot be null!");
                }
                LOG.debug("Injecting " + DuplicateResourceDetector.class.getSimpleName() + " in the locator: " + locator.getClass().getSimpleName());
                field.setAccessible(true);
                field.set(locator, this.duplicateResourceDetector);
            }
        }
        catch (Exception e) {
            throw new WroRuntimeException("Exception while trying to process Inject annotation", e);
        }
    }

    private Collection<Field> getAllFields(Object object) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(object.getClass().getDeclaredFields()));
        Class<?> superClass = object.getClass().getSuperclass();
        do {
            fields.addAll(Arrays.asList(superClass.getDeclaredFields()));
        } while ((superClass = superClass.getSuperclass()) != null);
        return fields;
    }
}

