/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource;

import org.apache.commons.lang.builder.ToStringBuilder;
import ro.isdc.wro.model.resource.ResourceType;

public class Resource {
    private final ResourceType type;
    private final String uri;
    private boolean minimize = true;

    private Resource(String uri, ResourceType type) {
        if (uri == null) {
            throw new IllegalArgumentException("URI cannot be null!");
        }
        if (type == null) {
            throw new IllegalArgumentException("ResourceType cannot be null!");
        }
        this.uri = Resource.cleanUri(uri);
        this.type = type;
    }

    public static Resource create(String uri, ResourceType type) {
        return new Resource(uri, type);
    }

    private static String cleanUri(String uri) {
        String result = uri.trim();
        int endIndex = result.length() - 1;
        if (result.lastIndexOf(47) == endIndex) {
            result = result.substring(0, endIndex);
        }
        return result;
    }

    public ResourceType getType() {
        return this.type;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean isMinimize() {
        return this.minimize;
    }

    public void setMinimize(boolean minimize) {
        this.minimize = minimize;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Resource) {
            Resource resource = (Resource)obj;
            return this.getUri().equals(resource.getUri()) && this.getType().equals((Object)resource.getType());
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + this.getType().hashCode();
        hash = 31 * hash + this.getUri().hashCode();
        return hash;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("uri", (Object)this.uri).append("minimize", this.minimize).toString();
    }
}

