/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.ast.ASTLiteral;

public class SuspiciousOctalEscape
extends AbstractRule {
    public Object visit(ASTLiteral node, Object data) {
        String image = node.getImage();
        if (image != null && image.startsWith("\"")) {
            String s = image.substring(1, image.length() - 1);
            int offset = 0;
            int slash = s.indexOf(92, offset);
            while (slash != -1 && slash < s.length() - 1) {
                String escapeSequence = s.substring(slash + 1);
                char first = escapeSequence.charAt(0);
                if (this.isOctal(first)) {
                    if (escapeSequence.length() > 1) {
                        char second = escapeSequence.charAt(1);
                        if (this.isOctal(second)) {
                            if (escapeSequence.length() > 2) {
                                char third = escapeSequence.charAt(2);
                                if (this.isOctal(third)) {
                                    char fourth;
                                    if (first != '0' && first != '1' && first != '2' && first != '3') {
                                        this.addViolation(data, node);
                                    } else if (escapeSequence.length() > 3 && this.isDecimal(fourth = escapeSequence.charAt(3))) {
                                        this.addViolation(data, node);
                                    }
                                } else if (this.isDecimal(third)) {
                                    this.addViolation(data, node);
                                }
                            }
                        } else if (this.isDecimal(second)) {
                            this.addViolation(data, node);
                        }
                    }
                } else if (first == '\\') {
                    ++slash;
                }
                offset = slash + 1;
                slash = s.indexOf(92, offset);
            }
        }
        return super.visit(node, data);
    }

    private boolean isOctal(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                return true;
            }
        }
        return false;
    }

    private boolean isDecimal(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }
}

