/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.cpd.CPDListener;
import net.sourceforge.pmd.cpd.CPDNullListener;
import net.sourceforge.pmd.cpd.CSVRenderer;
import net.sourceforge.pmd.cpd.Language;
import net.sourceforge.pmd.cpd.LanguageFactory;
import net.sourceforge.pmd.cpd.Match;
import net.sourceforge.pmd.cpd.MatchAlgorithm;
import net.sourceforge.pmd.cpd.Renderer;
import net.sourceforge.pmd.cpd.SimpleRenderer;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.cpd.VSRenderer;
import net.sourceforge.pmd.cpd.XMLRenderer;
import net.sourceforge.pmd.util.FileFinder;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPD {
    private Map<String, SourceCode> source = new HashMap<String, SourceCode>();
    private CPDListener listener = new CPDNullListener();
    private Tokens tokens = new Tokens();
    private int minimumTileSize;
    private MatchAlgorithm matchAlgorithm;
    private Language language;
    private boolean skipDuplicates;
    public static boolean debugEnable = false;
    private String encoding = System.getProperty("file.encoding");
    private Set<String> current = new HashSet<String>();

    public CPD(int minimumTileSize, Language language) {
        this.minimumTileSize = minimumTileSize;
        this.language = language;
    }

    public void skipDuplicates() {
        this.skipDuplicates = true;
    }

    public void setCpdListener(CPDListener cpdListener) {
        this.listener = cpdListener;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void go() {
        TokenEntry.clearImages();
        this.matchAlgorithm = new MatchAlgorithm(this.source, this.tokens, this.minimumTileSize, this.listener);
        this.matchAlgorithm.findMatches();
    }

    public Iterator<Match> getMatches() {
        return this.matchAlgorithm.matches();
    }

    public void add(File file) throws IOException {
        this.add(1, file);
    }

    public void addAllInDirectory(String dir) throws IOException {
        this.addDirectory(dir, false);
    }

    public void addRecursively(String dir) throws IOException {
        this.addDirectory(dir, true);
    }

    public void add(List<File> files) throws IOException {
        for (File f : files) {
            this.add(files.size(), f);
        }
    }

    private void addDirectory(String dir, boolean recurse) throws IOException {
        if (!new File(dir).exists()) {
            throw new FileNotFoundException(new StringBuffer().append("Couldn't find directory ").append(dir).toString());
        }
        FileFinder finder = new FileFinder();
        this.add(finder.findFilesFrom(dir, this.language.getFileFilter(), recurse));
    }

    private void add(int fileCount, File file) throws IOException {
        if (this.skipDuplicates) {
            String signature = new StringBuffer().append(file.getName()).append('_').append(file.length()).toString();
            if (this.current.contains(signature)) {
                System.err.println(new StringBuffer().append("Skipping ").append(file.getAbsolutePath()).append(" since it appears to be a duplicate file and --skip-duplicate-files is set").toString());
                return;
            }
            this.current.add(signature);
        }
        if (!file.getCanonicalPath().equals(new File(file.getAbsolutePath()).getCanonicalPath())) {
            System.err.println(new StringBuffer().append("Skipping ").append(file).append(" since it appears to be a symlink").toString());
            return;
        }
        this.listener.addedFile(fileCount, file);
        SourceCode sourceCode = new SourceCode(new SourceCode.FileCodeLoader(file, this.encoding));
        this.language.getTokenizer().tokenize(sourceCode, this.tokens);
        this.source.put(sourceCode.getFileName(), sourceCode);
    }

    public static Renderer getRendererFromString(String name, String encoding) {
        if (name.equalsIgnoreCase("text") || name.equals("")) {
            return new SimpleRenderer();
        }
        if ("xml".equals(name)) {
            return new XMLRenderer(encoding);
        }
        if ("csv".equals(name)) {
            return new CSVRenderer();
        }
        if ("vs".equals(name)) {
            return new VSRenderer();
        }
        try {
            return (Renderer)Class.forName(name).newInstance();
        }
        catch (Exception e) {
            System.out.println(new StringBuffer().append("Can't find class '").append(name).append("', defaulting to SimpleRenderer.").toString());
            return new SimpleRenderer();
        }
    }

    private static boolean findBooleanSwitch(String[] args, String name) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    private static String findRequiredStringValue(String[] args, String name) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(name)) continue;
            return args[i + 1];
        }
        System.out.println(new StringBuffer().append("No ").append(name).append(" value passed in").toString());
        CPD.usage();
        throw new RuntimeException();
    }

    private static String findOptionalStringValue(String[] args, String name, String defaultValue) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(name)) continue;
            return args[i + 1];
        }
        return defaultValue;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            CPD.usage();
        }
        try {
            boolean skipDuplicateFiles = CPD.findBooleanSwitch(args, "--skip-duplicate-files");
            String languageString = CPD.findOptionalStringValue(args, "--language", "java");
            String formatString = CPD.findOptionalStringValue(args, "--format", "text");
            String encodingString = CPD.findOptionalStringValue(args, "--encoding", System.getProperty("file.encoding"));
            int minimumTokens = Integer.parseInt(CPD.findRequiredStringValue(args, "--minimum-tokens"));
            LanguageFactory f = new LanguageFactory();
            Language language = f.createLanguage(languageString);
            Renderer renderer = CPD.getRendererFromString(formatString, encodingString);
            CPD cpd = new CPD(minimumTokens, language);
            cpd.setEncoding(encodingString);
            if (skipDuplicateFiles) {
                cpd.skipDuplicates();
            }
            boolean missingFiles = true;
            for (int position = 0; position < args.length; ++position) {
                if (!args[position].equals("--files")) continue;
                cpd.addRecursively(args[position + 1]);
                if (!missingFiles) continue;
                missingFiles = false;
            }
            if (missingFiles) {
                System.out.println("No --files value passed in");
                CPD.usage();
                throw new RuntimeException();
            }
            cpd.go();
            System.out.println(renderer.render(cpd.getMatches()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.println(" java net.sourceforge.pmd.cpd.CPD --minimum-tokens xxx --files xxx [--language xxx] [--encoding xxx] [--format (xml|text|csv|vs)] [--skip-duplicate-files] ");
        System.out.println("i.e: ");
        System.out.println(" java net.sourceforge.pmd.cpd.CPD --minimum-tokens 100 --files c:\\jdk14\\src\\java ");
        System.out.println("or: ");
        System.out.println(" java net.sourceforge.pmd.cpd.CPD --minimum-tokens 100 --files /path/to/c/code --language c ");
        System.out.println("or: ");
        System.out.println(" java net.sourceforge.pmd.cpd.CPD --minimum-tokens 100 --encoding UTF-16LE --files /path/to/java/code --format xml");
    }
}

