/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import java.util.Properties;
import junit.framework.Assert;
import org.codehaus.plexus.PlexusTestCase;
import org.codehaus.plexus.compiler.Compiler;
import org.codehaus.plexus.compiler.CompilerError;

public abstract class AbstractCompilerTest
extends PlexusTestCase {
    private Compiler compiler = null;
    private String[] classpathElements;
    private String[] sourceDirectories;
    private String destinationDirectory;
    private String mavenRepoLocal;
    protected String roleHint;

    public AbstractCompilerTest(String string) {
        super(string);
    }

    protected abstract String getRoleHint();

    public void setUp() throws Exception {
        super.setUp();
        this.compiler = (Compiler)this.lookup(Compiler.ROLE, this.getRoleHint());
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(new File(System.getProperty("user.home"), "build.properties")));
            this.mavenRepoLocal = properties.getProperty("maven.repo.local");
        }
        catch (Exception exception) {}
        if (this.mavenRepoLocal == null) {
            this.mavenRepoLocal = new File(System.getProperty("user.home"), ".maven/repository").getPath();
        }
        this.classpathElements = new String[]{String.valueOf(this.mavenRepoLocal) + "/commons-lang/jars/commons-lang-2.0.jar"};
        this.sourceDirectories = new String[]{String.valueOf(this.basedir) + "/src/test/input/src/main"};
        this.destinationDirectory = String.valueOf(this.basedir) + "/target/" + this.getRoleHint() + "/classes";
    }

    public void testCompilingSources() throws Exception {
        List list = this.compiler.compile(this.classpathElements, this.sourceDirectories, this.destinationDirectory);
        Assert.assertEquals((String)"Expected number of compilation errors is 1", (int)1, (int)list.size());
        CompilerError compilerError = (CompilerError)list.get(0);
        System.out.println("error = " + compilerError);
    }
}

