/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.core;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import nu.studer.java.util.OrderedProperties;
import org.sonatype.plexus.build.incremental.BuildContext;
import pl.project13.core.GitCommitIdExecutionException;
import pl.project13.core.log.LoggerBridge;

public class PropertiesFileGenerator {
    private static final ObjectMapper MAPPER = new ObjectMapper().enable(new MapperFeature[]{MapperFeature.BLOCK_UNSAFE_POLYMORPHIC_BASE_TYPES});
    private LoggerBridge log;
    private BuildContext buildContext;
    private String format;
    private String prefixDot;
    private String projectName;

    public PropertiesFileGenerator(LoggerBridge log, BuildContext buildContext, String format, String prefixDot, String projectName) {
        this.log = log;
        this.buildContext = buildContext;
        this.format = format;
        this.prefixDot = prefixDot;
        this.projectName = projectName;
    }

    public void maybeGeneratePropertiesFile(@Nonnull Properties localProperties, File base, String propertiesFilename, Charset sourceCharset) throws GitCommitIdExecutionException {
        block37: {
            try {
                File gitPropsFile = PropertiesFileGenerator.craftPropertiesOutputFile(base, propertiesFilename);
                boolean isJsonFormat = "json".equalsIgnoreCase(this.format);
                boolean shouldGenerate = true;
                if (gitPropsFile.exists()) {
                    try {
                        Properties persistedProperties;
                        if (isJsonFormat) {
                            this.log.info("Reading existing json file [{}] (for module {})...", (Object)gitPropsFile.getAbsolutePath(), (Object)this.projectName);
                            persistedProperties = this.readJsonProperties(gitPropsFile, sourceCharset);
                        } else {
                            this.log.info("Reading existing properties file [{}] (for module {})...", (Object)gitPropsFile.getAbsolutePath(), (Object)this.projectName);
                            persistedProperties = this.readProperties(gitPropsFile, sourceCharset);
                        }
                        Properties propertiesCopy = (Properties)localProperties.clone();
                        String buildTimeProperty = this.prefixDot + "build.time";
                        propertiesCopy.setProperty(buildTimeProperty, "");
                        persistedProperties.setProperty(buildTimeProperty, "");
                        shouldGenerate = !propertiesCopy.equals(persistedProperties);
                    }
                    catch (CannotReadFileException ex) {
                        this.log.info("Cannot read properties file [{}] (for module {})...", (Object)gitPropsFile.getAbsolutePath(), (Object)this.projectName);
                        shouldGenerate = true;
                    }
                }
                if (shouldGenerate) {
                    block36: {
                        Files.createDirectories(gitPropsFile.getParentFile().toPath(), new FileAttribute[0]);
                        try (FileOutputStream outputStream = new FileOutputStream(gitPropsFile);){
                            OrderedProperties sortedLocalProperties = new OrderedProperties.OrderedPropertiesBuilder().withSuppressDateInComment(true).withOrdering(Comparator.nullsLast(Comparator.naturalOrder())).build();
                            localProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> sortedLocalProperties.setProperty((String)key, (String)value)));
                            if (isJsonFormat) {
                                try (OutputStreamWriter outputWriter = new OutputStreamWriter((OutputStream)outputStream, sourceCharset);){
                                    this.log.info("Writing json file to [{}] (for module {})...", (Object)gitPropsFile.getAbsolutePath(), (Object)this.projectName);
                                    MAPPER.writerWithDefaultPrettyPrinter().writeValue((Writer)outputWriter, (Object)sortedLocalProperties);
                                    break block36;
                                }
                            }
                            this.log.info("Writing properties file to [{}] (for module {})...", (Object)gitPropsFile.getAbsolutePath(), (Object)this.projectName);
                            sortedLocalProperties.store((OutputStream)outputStream, "Generated by Git-Commit-Id-Plugin");
                        }
                        catch (IOException ex) {
                            throw new RuntimeException("Cannot create custom git properties file: " + gitPropsFile, ex);
                        }
                    }
                    if (this.buildContext != null) {
                        this.buildContext.refresh(gitPropsFile);
                    }
                    break block37;
                }
                this.log.info("Properties file [{}] is up-to-date (for module {})...", (Object)gitPropsFile.getAbsolutePath(), (Object)this.projectName);
            }
            catch (IOException e) {
                throw new GitCommitIdExecutionException(e);
            }
        }
    }

    public static File craftPropertiesOutputFile(File base, String propertiesFilename) {
        File returnPath = new File(base, propertiesFilename);
        File currentPropertiesFilepath = new File(propertiesFilename);
        if (currentPropertiesFilepath.isAbsolute()) {
            returnPath = currentPropertiesFilepath;
        }
        return returnPath;
    }

    private Properties readJsonProperties(@Nonnull File jsonFile, Charset sourceCharset) throws CannotReadFileException {
        HashMap propertiesMap;
        try {
            FileInputStream fis = new FileInputStream(jsonFile);
            Object object = null;
            try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fis, sourceCharset);){
                TypeReference<HashMap<String, Object>> mapTypeRef = new TypeReference<HashMap<String, Object>>(){};
                propertiesMap = (HashMap)MAPPER.readValue((Reader)inputStreamReader, (TypeReference)mapTypeRef);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (fis != null) {
                    if (object != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        fis.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new CannotReadFileException(ex);
        }
        Properties retVal = new Properties();
        for (Map.Entry entry : propertiesMap.entrySet()) {
            retVal.setProperty((String)entry.getKey(), String.valueOf(entry.getValue()));
        }
        return retVal;
    }

    /*
     * Exception decompiling
     */
    private Properties readProperties(@Nonnull File propertiesFile, Charset sourceCharset) throws CannotReadFileException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static class CannotReadFileException
    extends Exception {
        private static final long serialVersionUID = -6290782570018307756L;

        CannotReadFileException(Throwable cause) {
            super(cause);
        }
    }
}

