/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.jsf.zul.impl;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.zkoss.jsf.zul.impl.AbstractComponent;
import org.zkoss.jsf.zul.impl.BranchComponent;
import org.zkoss.jsf.zul.impl.ComponentInfo;
import org.zkoss.jsf.zul.impl.RootComponent;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.metainfo.ZScript;

public class BaseZScript
extends AbstractComponent {
    private static final Log log = Log.lookup((Class)BaseZScript.class);
    private boolean _deferred;
    private String _lang = null;
    private RootComponent _rootcomp;
    private BranchComponent _parentcomp;

    public void doZKLoading() throws IOException {
        if (!this.isRendered() || !this.isEffective()) {
            return;
        }
        String content = this.getBodyContent();
        this.setBodyContent(null);
        if (content == null) {
            return;
        }
        ZScript zscript = ZScript.parseContent((String)content);
        if (zscript.getLanguage() == null) {
            zscript.setLanguage(this._lang != null ? this._lang : this._rootcomp.getZScriptLanguage());
        }
        Component _parentzulcomp = null;
        if (this._parentcomp != null) {
            _parentzulcomp = this._parentcomp.getZULComponent();
        }
        this._rootcomp.processZScript(_parentzulcomp, zscript);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        super.encodeBegin(context);
        AbstractComponent ac = (AbstractComponent)this.findAncestorWithClass((UIComponent)this, AbstractComponent.class);
        if (ac instanceof RootComponent) {
            this._rootcomp = (RootComponent)ac;
        } else if (ac instanceof BranchComponent) {
            this._parentcomp = (BranchComponent)ac;
            this._rootcomp = this._parentcomp.getRootComponent();
        } else {
            throw new IllegalStateException("Must be nested inside the page component: " + (Object)((Object)this));
        }
        ComponentInfo cinfo = this.getComponentInfo();
        if (cinfo != null) {
            if (this._parentcomp != null) {
                cinfo.addChildInfo(this._parentcomp, this);
            } else if (this._rootcomp != null) {
                cinfo.addChildInfo(this._rootcomp, this);
            }
        }
    }

    protected ComponentInfo getComponentInfo() {
        if (this._rootcomp != null) {
            return this._rootcomp.getComponentInfo();
        }
        return null;
    }

    public boolean isDeferred() {
        return this._deferred;
    }

    public void setDeferred(boolean deferred) {
        this._deferred = deferred;
    }

    public String getLanguage() {
        return this._lang;
    }

    public void setLanguage(String lang) {
        this._lang = lang;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._lang, this._deferred ? Boolean.TRUE : Boolean.FALSE};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._lang = (String)values[1];
        this._deferred = (Boolean)values[2];
    }
}

