/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.jsf.zul.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.zkoss.jsf.zul.impl.BranchInput;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zul.Tree;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.Treechildren;
import org.zkoss.zul.Treeitem;

public abstract class BaseTree
extends BranchInput {
    public String getMappedAttributeName() {
        return null;
    }

    protected void afterZULComponentComposed(Component zulcomp) {
        super.afterZULComponentComposed(zulcomp);
        if (this.isLocalValueSet() || this.getValueBinding("value") != null) {
            zulcomp.addEventListener("onProcessZULJSFSelection", (EventListener)new ProcessSelection());
            Events.postEvent((String)"onProcessZULJSFSelection", (Component)zulcomp, (Object)this.getValue());
        }
    }

    private void processSelection(Tree tree, Object value) {
        boolean isMulti;
        HashMap<Object, String> selections = new HashMap<Object, String>();
        tree.clearSelection();
        Object multi = this.getAttributeValue("multiple");
        boolean bl = multi == null ? false : (isMulti = "true".equalsIgnoreCase(multi.toString()));
        if (value == null) {
            return;
        }
        if (isMulti) {
            if (value instanceof Collection) {
                Iterator iter = ((Collection)value).iterator();
                while (iter.hasNext()) {
                    selections.put(iter.next(), "");
                }
            } else if (value instanceof Object[]) {
                Object[] s = (Object[])value;
                for (int i = 0; i < s.length; ++i) {
                    selections.put(s[i], "");
                }
            } else {
                selections.put(value, "");
            }
        } else {
            selections.put(value, "");
        }
        TreeModel model = tree.getModel();
        if (model == null) {
            Treechildren tc = tree.getTreechildren();
            if (tc != null && !selections.isEmpty()) {
                this.dfSearchAndSelect(tree, tc.getChildren(), selections, isMulti);
            }
        } else {
            Object root = model.getRoot();
            this.dfSearchAndSelect(tree, root, root, model, selections, isMulti);
        }
    }

    private boolean dfSearchAndSelect(Tree tree, Object root, Object parent, TreeModel model, HashMap selections, boolean isMulti) {
        if (parent == null) {
            return false;
        }
        Object child = null;
        int size = model.getChildCount(parent);
        for (int i = 0; i < size; ++i) {
            boolean skip;
            child = model.getChild(parent, i);
            if (child != null && selections.get(child) != null) {
                int[] path = model.getPath(root, child);
                Treeitem ti = tree.renderItemByPath(path);
                if (ti != null) {
                    tree.addItemToSelection(ti);
                }
                selections.remove(child);
                if (!isMulti || selections.isEmpty()) {
                    return true;
                }
            }
            if (!(skip = this.dfSearchAndSelect(tree, root, child, model, selections, isMulti))) continue;
            return true;
        }
        return false;
    }

    private boolean dfSearchAndSelect(Tree tree, List children, HashMap selections, boolean isMulti) {
        if (children == null) {
            return false;
        }
        Object data = null;
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            boolean skip;
            Treechildren tc;
            Treeitem ti = (Treeitem)iter.next();
            data = ti.getValue();
            if (data != null && selections.get(data) != null) {
                tree.addItemToSelection(ti);
                selections.remove(data);
                if (!isMulti || selections.isEmpty()) {
                    return true;
                }
            }
            if ((tc = ti.getTreechildren()) == null || selections.isEmpty() || !(skip = this.dfSearchAndSelect(tree, tc.getChildren(), selections, isMulti))) continue;
            return true;
        }
        return false;
    }

    protected void clientInputDecode(FacesContext context) {
        String clientId = this.getClientId(context);
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        if (requestMap.containsKey(clientId)) {
            boolean isMulti;
            String[] newValue = (String[])context.getExternalContext().getRequestParameterValuesMap().get(clientId);
            Object multi = this.getAttributeValue("multiple");
            boolean bl = multi == null ? false : (isMulti = "true".equalsIgnoreCase(multi.toString()));
            if (newValue != null && newValue.length > 0) {
                Object value = isMulti ? newValue : newValue[0];
                this.setSubmittedValue(value);
            }
        }
    }

    private class ProcessSelection
    implements EventListener {
        private ProcessSelection() {
        }

        public void onEvent(Event event) throws Exception {
            Tree tree = (Tree)event.getTarget();
            Object value = event.getData();
            BaseTree.this.processSelection(tree, value);
        }
    }
}

