/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.jsf.zul.impl;

import java.text.DecimalFormat;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import org.zkoss.jsf.zul.impl.BranchInput;
import org.zkoss.jsf.zul.impl.FormateHolder;
import org.zkoss.zk.ui.Component;

public abstract class BaseSlider
extends BranchInput {
    protected void afterZULComponentComposed(Component zulcomp) {
        Converter converter = this.getConverter();
        if (converter == null) {
            converter = new IntgerFormatConverter();
            this.setConverter(converter);
        }
        super.afterZULComponentComposed(zulcomp);
    }

    public String getMappedAttributeName() {
        return "curpos";
    }

    public static class IntgerFormatConverter
    extends FormateHolder
    implements Converter {
        private DecimalFormat _formater;
        private static Pattern pattern = Pattern.compile("\\-*[0-9]*");

        public IntgerFormatConverter() {
            this.formatChanged();
        }

        public IntgerFormatConverter(String format) {
            super(format);
            this.formatChanged();
        }

        protected void formatChanged() {
            if (this._formater == null) {
                this._formater = new DecimalFormat();
            }
            if (this._format == null) {
                this._formater.applyLocalizedPattern("#0");
            } else {
                this._formater.applyLocalizedPattern(this._format);
            }
        }

        public Object getAsObject(FacesContext context, UIComponent component, String value) {
            try {
                if (value == null || "".equals(value.trim())) {
                    return null;
                }
                if (!pattern.matcher(value).matches()) {
                    throw new ConverterException("Format Error");
                }
                return new Integer(this._formater.parse(value).intValue());
            }
            catch (Exception e) {
                throw new ConverterException(e.getMessage(), (Throwable)e);
            }
        }

        public String getAsString(FacesContext context, UIComponent component, Object value) {
            if (value == null) {
                return null;
            }
            try {
                return this._formater.format(value);
            }
            catch (Exception e) {
                throw new ConverterException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

