
zul.wgt.Checkbox = zk.$extends(zul.LabelImageWidget, {
	_tabindex: -1,
	_checked: false,

	$define: {
		disabled: function (v) {
			var n = this.$n('real');
			if (n) n.disabled = v;
		},
		checked: function (v) {
			var n = this.$n('real');
			if (n) n.checked = v;
		},
		name: function (v) {
			var n = this.$n('real');
			if (n) n.name = v || '';
		},
		tabindex: function (v) {
			var n = this.$n('real');
			if (n) n.tabIndex = v >= 0 ? v: '';
		}
	},

	//super//
	getZclass: function () {
		var zcls = this._zclass;
		return zcls != null ? zcls: "z-checkbox";
	},
	contentAttrs_: function () {
		var html = '', v = this.getName(); // cannot use this._name for radio
		if (v)
			html += ' name="' + v + '"';
		if (this._disabled)
			html += ' disabled="disabled"';
		if (this._checked)
			html += ' checked="checked"';
		v = this._tabindex;
		if (v >= 0)
			html += ' tabindex="' + v + '"';
		return html;
	},
	bind_: function (desktop) {
		this.$supers('bind_', arguments);

		var n = this.$n('real');

		if (zk.gecko2_)
			jq(n).click(zul.wgt.Checkbox._domClick);
		this.domListen_(n, "onFocus", "doFocus_")
			.domListen_(n, "onBlur", "doBlur_");
	},
	unbind_: function () {
		var n = this.$n('real');
		
		if (zk.gecko2_)
			jq(n).unbind("click", zul.wgt.Checkbox._domClick);
		this.domUnlisten_(n, "onFocus", "doFocus_")
			.domUnlisten_(n, "onBlur", "doBlur_");

		this.$supers('unbind_', arguments);
	},
	doClick_: function (evt) {
		var real = this.$n('real'),
			checked = real.checked;
		if (checked != this._checked) //changed
			this.setChecked(checked) //so Radio has a chance to override it
				.fire('onCheck', checked);
		return this.$supers('doClick_', arguments);
	},
	getTextNode: function () {
		return jq(this.$n()).find('label:first')[0];
	}
}, zk.gecko2_ ? {
	_domClick: function (evt) {
		var e = evt.originalEvent;
		if (e) e.z$target = e.currentTarget;
			//bug 2233787: bug of firefox 2, use currentTarget not target
			//if pressing arrow keys
			//It is used by zk.Widget.$
			//Store it in originalEvent (since jq will construct another)
	}
}:null);

