
zul.db.Calendar = zk.$extends(zul.Widget, {
	_view : "day", //"day", "month", "year", "decade"
	$define: {
		value: _zkf = function() {
			this.rerender();
		},
		constraint: function() {
			var constraint = this._constraint || '';
			if (constraint.startsWith("between")) {
				var j = constraint.indexOf("and", 7);
				if (j < 0 && zk.debugJS) 
					zk.error('Unknown constraint: ' + constraint);
				this._beg = zDateFormat.parseDate(constraint.substring(7, j), 'yyyyMMdd');
				this._end = zDateFormat.parseDate(constraint.substring(j + 3), 'yyyyMMdd');
				if (this._beg.getTime() > this._end.getTime()) {
					var d = this._beg;
					this._beg = this._end;
					this._end = d;
				}
				
				this._beg.setHours(0);
				this._beg.setMinutes(0);
				this._beg.setSeconds(0);
				this._beg.setMilliseconds(0);
				
				this._end.setHours(0);
				this._end.setMinutes(0);
				this._end.setSeconds(0);
				this._end.setMilliseconds(0);
			} else if (constraint.startsWith("before")) {
				this._end = zDateFormat.parseDate(constraint.substring(6), 'yyyyMMdd');
				this._end.setHours(0);
				this._end.setMinutes(0);
				this._end.setSeconds(0);
				this._end.setMilliseconds(0);
			} else if (constraint.startsWith("after")) {
				this._beg = zDateFormat.parseDate(constraint.substring(5), 'yyyyMMdd');
				this._beg.setHours(0);
				this._beg.setMinutes(0);
				this._beg.setSeconds(0);
				this._beg.setMilliseconds(0);
			}
		}
	},
	getFormat: function () {
		return this._fmt || "yyyy/MM/dd";
	},
	getZclass: function () {
		var zcs = this._zclass;
		return zcs != null ? zcs: "z-calendar";
	},
	today: function () {
		return zUtl.today();
	},
	bind_: function (){
		this.$supers('bind_', arguments);
		this._value ? zDateFormat.parseDate(this._value, this.getFormat()) : new Date();
		var title = this.$n("title"),
			mid = this.$n("mid"),
			ly = this.$n("ly"),
			ry = this.$n("ry"),
			zcls = this.getZclass();
		jq(title).hover(
			function () {
				$(this).toggleClass(zcls + "-title-over");
			},
			function () {
			    $(this).toggleClass(zcls + "-title-over");
			}
		);
		this._markCal();
		this.domListen_(title, "onClick", '_changeView')
			.domListen_(mid, "onClick", '_choiceData')
			.domListen_(ly, "onClick", '_doclickArrow')
			.domListen_(ry, "onClick", '_doclickArrow')
			.domListen_(mid, "onMouseOver", '_doMouseEffect')
			.domListen_(mid, "onMouseOut", '_doMouseEffect');
	},
	unbind_: function () {
		var title = this.$n("title"),
			mid = this.$n("mid"),
			ly = this.$n("ly"),
			ry = this.$n("ry");
		this.domUnlisten_(title, "onClick", '_changeView')
			.domUnlisten_(mid, "onClick", '_choiceData')
			.domUnlisten_(ly, "onClick", '_doclickArrow')
			.domUnlisten_(ry, "onClick", '_doclickArrow')
			.domUnlisten_(mid, "onMouseOver", '_doMouseEffect')
			.domUnlisten_(mid, "onMouseOut", '_doMouseEffect')
			.$supers('unbind_', arguments);
	},
	_doclickArrow: function (evt) {
		var node = evt.domTarget,
			ofs = node.id.indexOf("-ly") > 0 ? -1 : 1;
		if (jq(node).hasClass(this.getZclass() + (ofs == -1 ? '-left-icon-disd' : '-right-icon-disd')))
			return;
		switch(this._view) {
			case "day" :
				this._shiftDate("m", ofs);
				break;
			case "month" :
				this._shiftDate("y", ofs);
				break;
			case "year" :
				this._shiftDate("y", ofs*10);
				break;
			case "decade" :
				this._shiftDate("y", ofs*100);
				break;
		}
		this.rerender();
	},
	_doMouseEffect: function (evt) {
		var node = evt.domTarget.tagName == "TD" ? evt.domTarget : evt.domTarget.parentNode,
			zcls = this.getZclass();
			
		if (jq(node).hasClass(zcls + '-disd'))
			return;
			
		if (jq(node).is("."+zcls+"-seld")) {
			jq(node).removeClass(zcls + "-over");
			jq(node).toggleClass(zcls + "-over-seld");
		}else {
			jq(node).toggleClass(zcls + "-over");
		}
	},
	getTime : function () {
		return this._value ? zDateFormat.parseDate(this._value, this.getFormat()) : new Date();
	},
	_setTime : function (y, m, d, hr, mi) {
		var dateobj = this.getTime(),
			year = y != null ? y  : dateobj.getFullYear(),
			month = m != null ? m : dateobj.getMonth(),
			day = d != null ? d : dateobj.getDate();
		this._value = zDateFormat.formatDate(new Date(year, month, day), this.getFormat());
		this.fire('onChange', {value: this._value});
	},
	_choiceData: function (evt) {
		var target = evt.domTarget;
		target = target.tagName == "TD" ? target : target.parentNode;
		
		var val = jq(target).attr('_dt');
		if (target && !jq(target).hasClass(this.getZclass() + '-disd') && !isNaN(val)) {
			var cell = target,
				dateobj = this.getTime();
			switch(this._view) {
				case "day" :
					var oldTime = this.getTime();
					this._setTime(null, cell._monofs != null && cell._monofs != 0 ?
							dateobj.getMonth() + cell._monofs : null, val);
					var newTime = this.getTime();
					if (oldTime.getYear() == newTime.getYear() &&
						oldTime.getMonth() == newTime.getMonth()) {
							this._markCal();
					} else
						this.rerender();
					break;
				case "month" :
					this._setTime(null, val);
					this._setView("day");
					break;
				case "year" :
					this._setTime(val);
					this._setView("month");
					break;
				case "decade" :
					//Decade mode Set Year Also
					this._setTime(val);
					this._setView("year");
					break;
			}
		}
	},
	_shiftDate: function (opt, ofs) {
		var dateobj = this.getTime(),
			year = dateobj.getFullYear(),
			month = dateobj.getMonth(),
			day = dateobj.getDate();
		switch(opt) {
			case "d" :
				day = day + ofs;
				break;
			case "m" :
				month = month + ofs;
				break;
			case "y" :
				year = year + ofs;
				break;
			case "d" :
				year = year + ofs;
				break;
		}
		this._value = zDateFormat.formatDate(new Date(year, month, day), this.getFormat());
		this.fire('onChange', {value: this._value, shallClose: false});
	},
	_changeView : function (evt) {
		var tm = this.$n("tm"),
			ty = this.$n("ty"),
			tyd = this.$n("tyd");
		if (evt.domTarget == tm)
			this._setView("month");
		else if (evt.domTarget == ty)
			this._setView("year");
		else if (evt.domTarget == tyd )
			this._setView("decade");
	},
	_setView : function (view) {
		if (view != this._view) {
			this._view = view;
			this.rerender();
		}
	},
	_invalid: function (y, m, v, today) {
		var d = new Date(y, m, v, 0, 0, 0, 0);
		switch (this._constraint) {
		case 'no today':
			return today - d == 0;
			break;
		case 'no past':
			return (d - today) / 86400000 < 0;
			break;
		case 'no future':
			return (today - d)/ 86400000 < 0;
			break;
		default:
			var result = false;
			if (this._beg && (result = (d - this._beg) / 86400000 < 0))
				return result;
			if (this._end && (result = (this._end - d) / 86400000 < 0))
				return result;
			return result;
		}
	},
	_markCal : function () {
		var	zcls = this.getZclass(),
		 	val = this.getTime(),
		 	m = val.getMonth(),
			d = val.getDate(),
			y = val.getFullYear(),
			last = new Date(y, m + 1, 0).getDate(), //last date of this month
			prev = new Date(y, m, 0).getDate(), //last date of previous month
			v = new Date(y, m, 1).getDay()- zk.DOW_1ST,
			today = this.today();
		//hightlight month & year
		for (var j = 0; j < 12; ++j) {
			var mon = this.$n("m" + j),
				year = this.$n("y" + j),
				yy = y % 10 + 1;
			if (mon) {
				if (m == j) {
					jq(mon).addClass(zcls+"-seld");
					jq(mon).removeClass(zcls+"-over");
				} else
					jq(mon).removeClass(zcls+"-seld");
			}
			if (year) {
				if (yy == j) {
					jq(year).addClass(zcls+"-seld");
				    jq(year).removeClass(zcls+"-over");
				} else
					jq(year).removeClass(zcls+"-seld");
			}
		}

		if (v < 0) v += 7;
		for (var j = 0, cur = -v + 1; j < 6; ++j) {
			var week = this.$n("w" + j);
			if ( week != null) {
				for (var k = 0; k < 7; ++k, ++cur) {
					v = cur <= 0 ? prev + cur: cur <= last ? cur: cur - last;
					if (k == 0 && cur > last)
						week.style.display = "none";
					else {
						if (k == 0) week.style.display = "";
						var cell = week.cells[k],
							monofs = cur <= 0 ? -1: cur <= last ? 0: 1,
							sel = cur == d;
						cell.style.textDecoration = "";
						cell._monofs = monofs;
						//hightlight day
						jq(cell).removeClass(zcls+"-over");
						jq(cell).removeClass(zcls+"-over-seld");
						if (sel)
							jq(cell).addClass(zcls+"-seld");
						else
							jq(cell).removeClass(zcls+"-seld");
							
						if (this._invalid(y, m + monofs, v, today)) {
							jq(cell).addClass(zcls+"-disd");
						} else
							jq(cell).removeClass(zcls+"-disd");
							 
						jq(cell).html('<a href="javascript:;">' + v + '</a>').attr('_dt', v);
					}
				}
			}
		}
	}

});
