/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.sys.ComponentCtrl;
import org.zkoss.zk.ui.sys.HtmlPageRenders;
import org.zkoss.zk.ui.sys.PageCtrl;

public class PageRenderer
implements org.zkoss.zk.ui.sys.PageRenderer {
    public void render(Page page, Writer out) throws IOException {
        Execution exec = Executions.getCurrent();
        String ctl = (String)exec.getAttribute("org.zkoss.zk.ui.page.redrawCtrl");
        boolean au = exec.isAsyncUpdate(null);
        if (!au && (page.isComplete() || "complete".equals(ctl))) {
            this.renderComplete(exec, page, out);
            return;
        }
        boolean pageOnly = au;
        if (!pageOnly) {
            boolean bl = pageOnly = (exec.isIncluded() || "page".equals(ctl)) && !"desktop".equals(ctl);
        }
        if (pageOnly) {
            this.renderPage(exec, page, out, au);
        } else {
            this.renderDesktop(exec, page, out);
        }
    }

    protected void renderDesktop(Execution exec, Page page, Writer out) throws IOException {
        HtmlPageRenders.setContentType((Execution)exec, (Page)page);
        PageCtrl pageCtrl = (PageCtrl)page;
        PageRenderer.write(out, HtmlPageRenders.outFirstLine((Page)page));
        PageRenderer.write(out, HtmlPageRenders.outDocType((Page)page));
        out.write("<html xmlns=\"http://www.w3.org/1999/xhtml\"");
        PageRenderer.write(out, pageCtrl.getRootAttributes());
        out.write(">\n<head>\n<meta http-equiv=\"Pragma\" content=\"no-cache\" />\n<meta http-equiv=\"Expires\" content=\"-1\" />\n<title>");
        PageRenderer.write(out, page.getTitle());
        out.write("</title>\n");
        out.write(pageCtrl.getHeaders(true));
        out.write(HtmlPageRenders.outLangStyleSheets((Execution)exec, null, null));
        out.write(HtmlPageRenders.outLangJavaScripts((Execution)exec, null, null));
        out.write(pageCtrl.getHeaders(false));
        out.write("</head>\n");
        out.write("<body>\n");
        HtmlPageRenders.outPageContent((Execution)exec, (Page)page, (Writer)out, (boolean)false);
        PageRenderer.writeln(out, HtmlPageRenders.outUnavailable((Execution)exec));
        out.write(HtmlPageRenders.outResponseJavaScripts((Execution)exec));
        out.write("\n</body>\n</html>\n");
    }

    private static void write(Writer out, String s) throws IOException {
        if (s != null) {
            out.write(s);
        }
    }

    private static void writeln(Writer out, String s) throws IOException {
        if (s != null) {
            out.write(s);
            out.write(10);
        }
    }

    protected void renderPage(Execution exec, Page page, Writer out, boolean au) throws IOException {
        if (!au) {
            out.write(HtmlPageRenders.outLangStyleSheets((Execution)exec, null, null));
            out.write(HtmlPageRenders.outLangJavaScripts((Execution)exec, null, null));
        }
        HtmlPageRenders.outPageContent((Execution)exec, (Page)page, (Writer)out, (boolean)au);
        if (!au && ((PageCtrl)page).getOwner() == null) {
            PageRenderer.writeln(out, HtmlPageRenders.outUnavailable((Execution)exec));
        }
        out.write(HtmlPageRenders.outResponseJavaScripts((Execution)exec));
    }

    protected void renderComplete(Execution exec, Page page, Writer out) throws IOException {
        HtmlPageRenders.setContentType((Execution)exec, (Page)page);
        Iterator it = page.getRoots().iterator();
        while (it.hasNext()) {
            ((ComponentCtrl)it.next()).redraw(out);
        }
        PageRenderer.write(out, HtmlPageRenders.outZkTags((Execution)exec, (Desktop)page.getDesktop()));
        PageRenderer.writeln(out, HtmlPageRenders.outUnavailable((Execution)exec));
    }
}

