/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import org.zkoss.lang.Objects;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.SuspendNotAllowedException;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.MaximizeEvent;
import org.zkoss.zk.ui.event.MinimizeEvent;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.api.Caption;
import org.zkoss.zul.impl.XulElement;

public class Window
extends XulElement
implements org.zkoss.zul.api.Window {
    private static final Log log = Log.lookup((Class)Window.class);
    private static String _onshow = null;
    private transient org.zkoss.zul.Caption _caption;
    private String _border = "none";
    private String _title = "";
    private int _mode = 0;
    private transient Object _mutex;
    private String _cntStyle;
    private String _cntSclass;
    private String _pos;
    private boolean _closable;
    private boolean _sizable;
    private boolean _shadow = true;
    private boolean _maximizable;
    private boolean _minimizable;
    private boolean _maximized;
    private boolean _minimized;
    private int _minheight = 100;
    private int _minwidth = 200;
    private static final int EMBEDDED = 0;
    private static final int MODAL = 1;
    private static final int OVERLAPPED = 2;
    private static final int POPUP = 3;
    private static final int HIGHLIGHTED = 4;

    public Window() {
        this.init();
    }

    public Window(String title, String border, boolean closable) {
        this();
        this.setTitle(title);
        this.setBorder(border);
        this.setClosable(closable);
    }

    private void init() {
        this._mutex = new Object();
    }

    public boolean isMaximized() {
        return this._maximized;
    }

    public void setMaximized(boolean maximized) {
        if (this._maximized != maximized) {
            if (!this._maximizable) {
                throw new UiException("Not maximizable, " + this);
            }
            this._maximized = maximized;
            if (this._maximized) {
                this._minimized = false;
                this.setVisible0(true);
            }
            this.smartUpdate("maximized", this._maximized);
        }
    }

    public boolean isMaximizable() {
        return this._maximizable;
    }

    public void setMaximizable(boolean maximizable) {
        if (this._maximizable != maximizable) {
            this._maximizable = maximizable;
            this.smartUpdate("maximizable", this._maximizable);
        }
    }

    public boolean isMinimized() {
        return this._minimized;
    }

    public void setMinimized(boolean minimized) {
        if (this._minimized != minimized) {
            if (!this._minimizable) {
                throw new UiException("not minimizable, " + this);
            }
            this._minimized = minimized;
            if (this._minimized) {
                this._maximized = false;
                this.setVisible0(false);
            } else {
                this.setVisible0(true);
            }
            this.smartUpdate("minimized", this._minimized);
        }
    }

    public boolean isMinimizable() {
        return this._minimizable;
    }

    public void setMinimizable(boolean minimizable) {
        if (this._minimizable != minimizable) {
            this._minimizable = minimizable;
            this.smartUpdate("minimizable", this._minimizable);
        }
    }

    public void setMinheight(int minheight) {
        if (minheight < 0) {
            minheight = 100;
        }
        if (this._minheight != minheight) {
            this._minheight = minheight;
            this.smartUpdate("minheight", this._minheight);
        }
    }

    public int getMinheight() {
        return this._minheight;
    }

    public void setMinwidth(int minwidth) {
        if (minwidth < 0) {
            minwidth = 200;
        }
        if (this._minwidth != minwidth) {
            this._minwidth = minwidth;
            this.smartUpdate("minwidth", this._minwidth);
        }
    }

    public int getMinwidth() {
        return this._minwidth;
    }

    public static void setDefaultActionOnShow(String onshow) {
        if (!Objects.equals((Object)_onshow, (Object)onshow)) {
            _onshow = onshow;
        }
    }

    public static String getDefaultActionOnShow() {
        return _onshow;
    }

    public org.zkoss.zul.Caption getCaption() {
        return this._caption;
    }

    public Caption getCaptionApi() {
        return this.getCaption();
    }

    public String getBorder() {
        return this._border;
    }

    public void setBorder(String border) {
        if (border == null || "0".equals(border)) {
            border = "none";
        }
        if (!Objects.equals((Object)this._border, (Object)border)) {
            this._border = border;
            this.smartUpdate("border", border);
        }
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        if (!Objects.equals((Object)this._title, (Object)title)) {
            this._title = title;
            this.smartUpdate("title", title);
        }
    }

    public String getMode() {
        return Window.modeToString(this._mode);
    }

    private static String modeToString(int mode) {
        switch (mode) {
            case 1: {
                return "modal";
            }
            case 3: {
                return "popup";
            }
            case 2: {
                return "overlapped";
            }
            case 4: {
                return "highlighted";
            }
        }
        return "embedded";
    }

    public void setMode(String name) throws InterruptedException {
        if ("popup".equals(name)) {
            this.doPopup();
        } else if ("overlapped".equals(name)) {
            this.doOverlapped();
        } else if ("embedded".equals(name)) {
            this.doEmbedded();
        } else if ("modal".equals(name)) {
            Events.postEvent((String)"onModal", (Component)this, null);
        } else if ("highlighted".equals(name)) {
            this.doHighlighted();
        } else {
            throw new WrongValueException("Uknown mode: " + name);
        }
    }

    public void setMode(int mode) throws InterruptedException {
        switch (mode) {
            case 3: {
                this.doPopup();
                break;
            }
            case 2: {
                this.doOverlapped();
                break;
            }
            case 0: {
                this.doEmbedded();
                break;
            }
            case 1: {
                Events.postEvent((String)"onModal", (Component)this, null);
                break;
            }
            case 4: {
                this.doHighlighted();
                break;
            }
            default: {
                throw new WrongValueException("Unknown mode: " + mode);
            }
        }
    }

    public boolean inModal() {
        return this._mode == 1;
    }

    public boolean inEmbedded() {
        return this._mode == 0;
    }

    public boolean inOverlapped() {
        return this._mode == 2;
    }

    public boolean inPopup() {
        return this._mode == 3;
    }

    public boolean inHighlighted() {
        return this._mode == 4;
    }

    public void doModal() throws InterruptedException, SuspendNotAllowedException {
        Desktop desktop = this.getDesktop();
        if (desktop == null) {
            throw new SuspendNotAllowedException("Not attached, " + this);
        }
        if (!desktop.getWebApp().getConfiguration().isEventThreadEnabled()) {
            this.doHighlighted();
            return;
        }
        this.checkOverlappable(1);
        if (this._mode != 1) {
            if (!Events.inEventListener()) {
                throw new SuspendNotAllowedException("doModal must be called in an event listener");
            }
            int oldmode = this._mode;
            boolean oldvisi = this.isVisible();
            this.setVisible(true);
            try {
                this.enterModal();
            }
            catch (SuspendNotAllowedException ex) {
                this.handleFailedModal(oldmode, oldvisi);
                throw ex;
            }
        }
    }

    private void handleFailedModal(int oldmode, boolean oldvisi) {
        try {
            if (Executions.getCurrent().getAttribute("javax.servlet.error.exception") != null) {
                this.setMode(4);
            } else {
                this.setMode(oldmode);
                this.setVisible(oldvisi);
            }
        }
        catch (Throwable ex) {
            log.realCauseBriefly("Causing another error", ex);
        }
    }

    public void doOverlapped() {
        this.checkOverlappable(2);
        this.setNonModalMode(2);
    }

    public void doPopup() {
        this.checkOverlappable(3);
        this.setNonModalMode(3);
    }

    public void doHighlighted() {
        this.checkOverlappable(4);
        this.setNonModalMode(4);
    }

    public void doEmbedded() {
        this.setNonModalMode(0);
    }

    private void setNonModalMode(int mode) {
        if (this._mode != mode) {
            if (this._mode == 1) {
                this.leaveModal(mode);
            } else {
                this._mode = mode;
                this.smartUpdate("mode", Window.modeToString(this._mode));
            }
        }
        this.setVisible(true);
    }

    private void enterModal() throws InterruptedException {
        this._mode = 1;
        this.smartUpdate("mode", Window.modeToString(this._mode));
        Executions.wait((Object)this._mutex);
    }

    private void leaveModal(int mode) {
        this._mode = mode;
        this.smartUpdate("mode", Window.modeToString(this._mode));
        Executions.notifyAll((Object)this._mutex);
    }

    private void checkOverlappable(int mode) {
        if (!"false".equals(this.getDraggable())) {
            throw new UiException("Draggable window cannot be modal, overlapped, popup, or highlighted: " + this);
        }
        if (mode == 1 || mode == 4) {
            Window comp = this;
            while ((comp = comp.getParent()) != null) {
                if (comp.isVisible()) continue;
                throw new UiException("One of its ancestors, " + comp + ", is not visible, so unable to be modal or highlighted");
            }
        }
    }

    public boolean isClosable() {
        return this._closable;
    }

    public void setClosable(boolean closable) {
        if (this._closable != closable) {
            this._closable = closable;
            this.smartUpdate("closable", closable);
        }
    }

    public boolean isSizable() {
        return this._sizable;
    }

    public void setSizable(boolean sizable) {
        if (this._sizable != sizable) {
            this._sizable = sizable;
            this.smartUpdate("sizable", sizable);
        }
    }

    public boolean isShadow() {
        return this._shadow;
    }

    public void setShadow(boolean shadow) {
        if (this._shadow != shadow) {
            this._shadow = shadow;
            this.smartUpdate("shadow", shadow);
        }
    }

    public String getPosition() {
        return this._pos;
    }

    public void setPosition(String pos) {
        this._pos = pos;
        this.smartUpdate("position", pos);
    }

    public void onClose() {
        this.detach();
    }

    public void onModal() throws InterruptedException {
        this.doModal();
    }

    public String getContentStyle() {
        return this._cntStyle;
    }

    public void setContentStyle(String style) {
        if (!Objects.equals((Object)this._cntStyle, (Object)style)) {
            this._cntStyle = style;
            this.smartUpdate("contentStyle", this._cntStyle);
        }
    }

    public String getContentSclass() {
        return this._cntSclass;
    }

    public void setContentSclass(String scls) {
        if (!Objects.equals((Object)this._cntSclass, (Object)scls)) {
            this._cntSclass = scls;
            this.smartUpdate("contentSclass", scls);
        }
    }

    public void setTopmost() {
        this.smartUpdate("topmost", true);
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "title", this._title);
        this.render(renderer, "maximized", this._maximized);
        this.render(renderer, "maximizable", this._maximizable);
        this.render(renderer, "minimized", this._minimized);
        this.render(renderer, "minimizable", this._minimizable);
        this.render(renderer, "closable", this._closable);
        this.render(renderer, "sizable", this._sizable);
        this.render(renderer, "position", this._pos);
        this.render(renderer, "contentStyle", this._cntStyle);
        this.render(renderer, "contentSclass", this._cntSclass);
        if (this._minheight != 100) {
            renderer.render("minheight", this._minheight);
        }
        if (this._minwidth != 200) {
            renderer.render("minwidth", this._minwidth);
        }
        if (!"none".equals(this._border)) {
            renderer.render("border", this._border);
        }
        if (!this.isShadow()) {
            renderer.render("shadow", false);
        }
        if (this._mode != 0) {
            renderer.render("mode", Window.modeToString(this._mode));
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-window-" + this.getMode() : this._zclass;
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (child instanceof org.zkoss.zul.Caption) {
            if (this._caption != null && this._caption != child) {
                throw new UiException("Only one caption is allowed: " + this);
            }
        } else if (refChild instanceof org.zkoss.zul.Caption) {
            throw new UiException("caption must be the first child");
        }
        super.beforeChildAdded(child, refChild);
    }

    public boolean insertBefore(Component child, Component refChild) {
        if (child instanceof org.zkoss.zul.Caption) {
            refChild = this.getFirstChild();
            if (super.insertBefore(child, refChild)) {
                this._caption = (org.zkoss.zul.Caption)child;
                return true;
            }
            return false;
        }
        return super.insertBefore(child, refChild);
    }

    public void onChildRemoved(Component child) {
        if (child instanceof org.zkoss.zul.Caption) {
            this._caption = null;
        }
        super.onChildRemoved(child);
    }

    public void onPageDetached(Page page) {
        if (this._mode == 1 && this.getPage() == null) {
            this.leaveModal(2);
        }
    }

    public boolean setVisible(boolean visible) {
        if (visible == this._visible) {
            return visible;
        }
        this._minimized = false;
        this._maximized = false;
        return this.setVisible0(visible);
    }

    private boolean setVisible0(boolean visible) {
        if (!(visible || this._mode != 1 && this._mode != 4)) {
            if (this._mode == 1) {
                super.setVisible(false);
                this.leaveModal(2);
                return true;
            }
            this._mode = 2;
            this.smartUpdate("mode", Window.modeToString(this._mode));
        }
        return super.setVisible(visible);
    }

    public void setDraggable(String draggable) {
        if (this._mode != 0 && draggable != null && draggable.length() > 0 && !"false".equals(draggable)) {
            throw new UiException("Only embedded window could be draggable: " + this);
        }
        super.setDraggable(draggable);
    }

    public Object clone() {
        Window clone = (Window)super.clone();
        clone.init();
        if (clone._caption != null) {
            clone.afterUnmarshal();
        }
        return clone;
    }

    private void afterUnmarshal() {
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (!(child instanceof org.zkoss.zul.Caption)) continue;
            this._caption = (org.zkoss.zul.Caption)child;
            break;
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
        this.afterUnmarshal();
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onOpen")) {
            OpenEvent evt = OpenEvent.getOpenEvent((AuRequest)request);
            this.setVisible(evt.isOpen());
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onMaximize")) {
            MaximizeEvent evt = MaximizeEvent.getMaximizeEvent((AuRequest)request);
            this._left = evt.getLeft();
            this._top = evt.getTop();
            this._width = evt.getWidth();
            this._height = evt.getHeight();
            this._maximized = evt.isMaximized();
            if (this._maximized) {
                this._visible = true;
            }
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onMinimize")) {
            MinimizeEvent evt = MinimizeEvent.getMinimizeEvent((AuRequest)request);
            this._left = evt.getLeft();
            this._top = evt.getTop();
            this._width = evt.getWidth();
            this._height = evt.getHeight();
            this._minimized = evt.isMinimized();
            if (this._minimized) {
                this._visible = false;
                if (this._mode == 1) {
                    this.leaveModal(2);
                } else if (this._mode == 4) {
                    this._mode = 2;
                    this.smartUpdate("mode", Window.modeToString(this._mode));
                }
            }
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    public boolean isCollapsible() {
        return false;
    }

    static {
        Window.addClientEvent((Class)Window.class, (String)"onClose", (int)0);
        Window.addClientEvent((Class)Window.class, (String)"onMove", (int)8193);
        Window.addClientEvent((Class)Window.class, (String)"onOpen", (int)1);
        Window.addClientEvent((Class)Window.class, (String)"onZIndex", (int)8193);
        Window.addClientEvent((Class)Window.class, (String)"onMaximize", (int)8193);
        Window.addClientEvent((Class)Window.class, (String)"onMinimize", (int)8193);
    }
}

