/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Tree;
import org.zkoss.zul.Treecols;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.Treerow;
import org.zkoss.zul.api.Treecol;
import org.zkoss.zul.impl.LabelImageElement;

public class Treecell
extends LabelImageElement
implements org.zkoss.zul.api.Treecell {
    private static final String ROOT_OPEN = "root-open";
    private static final String ROOT_CLOSE = "root-close";
    private static final String LAST_OPEN = "last-open";
    private static final String LAST_CLOSE = "last-close";
    private static final String TEE_OPEN = "tee-open";
    private static final String TEE_CLOSE = "tee-close";
    private static final String TEE = "tee";
    private static final String LAST = "last";
    private static final String VBAR = "vbar";
    private static final String SPACER = "spacer";
    private static final String FIRSTSPACER = "firstspacer";
    private int _span = 1;

    public Treecell() {
    }

    public Treecell(String label) {
        super(label);
    }

    public Treecell(String label, String src) {
        super(label, src);
    }

    public Tree getTree() {
        Treecell n = this;
        while ((n = n.getParent()) != null) {
            if (!(n instanceof Tree)) continue;
            return (Tree)((Object)n);
        }
        return null;
    }

    public org.zkoss.zul.api.Tree getTreeApi() {
        return this.getTree();
    }

    public org.zkoss.zul.Treecol getTreecol() {
        List lcschs;
        int j;
        Treecols lcs;
        Tree tree = this.getTree();
        if (tree != null && (lcs = tree.getTreecols()) != null && (j = this.getColumnIndex()) < (lcschs = lcs.getChildren()).size()) {
            return (org.zkoss.zul.Treecol)lcschs.get(j);
        }
        return null;
    }

    public Treecol getTreecolApi() {
        return this.getTreecol();
    }

    public int getColumnIndex() {
        int j = 0;
        Iterator it = this.getParent().getChildren().iterator();
        while (it.hasNext() && it.next() != this) {
            ++j;
        }
        return j;
    }

    public int getMaxlength() {
        Tree tree = this.getTree();
        if (tree == null) {
            return 0;
        }
        org.zkoss.zul.Treecol lc = this.getTreecol();
        return lc != null ? lc.getMaxlength() : 0;
    }

    public int getLevel() {
        Component parent = this.getParent();
        return parent != null ? ((Treerow)parent).getLevel() : 0;
    }

    public int getSpan() {
        return this._span;
    }

    public void setSpan(int span) {
        if (this._span != span) {
            this._span = span;
            this.smartUpdate("colspan", this._span);
        }
    }

    public static boolean isLastChild(Treeitem item) {
        Component parent = item.getParent();
        if (parent == null) {
            return true;
        }
        for (Component n = parent.getLastChild(); n != null; n = n.getPreviousSibling()) {
            if (!n.isVisible()) continue;
            return n == item;
        }
        return false;
    }

    private Treeitem[] getTreeitems(Component item) {
        Component tch;
        LinkedList<Component> pitems = new LinkedList<Component>();
        while ((tch = item.getParent()) != null && (item = tch.getParent()) != null && !(item instanceof Tree)) {
            pitems.add(0, item);
        }
        return pitems.toArray(new Treeitem[pitems.size()]);
    }

    private Treeitem getTreeitem() {
        Component parent = this.getParent();
        return parent != null ? (Treeitem)parent.getParent() : null;
    }

    public String getZclass() {
        return this._zclass == null ? "z-treecell" : this._zclass;
    }

    public String getWidth() {
        org.zkoss.zul.Treecol col = this.getTreecol();
        return col != null ? col.getWidth() : null;
    }

    public void setWidth(String width) {
        throw new UnsupportedOperationException("Set treecol's width instead");
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._span > 1) {
            renderer.render("colspan", this._span);
        }
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Treerow)) {
            throw new UiException("Wrong parent: " + parent);
        }
        super.beforeParentChanged(parent);
    }
}

