/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.Writer;
import org.zkoss.lang.Objects;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.sys.HtmlPageRenders;
import org.zkoss.zk.ui.util.DeferredValue;
import org.zkoss.zul.impl.Utils;

public class Style
extends AbstractComponent
implements org.zkoss.zul.api.Style {
    private String _src;
    private String _content;
    private byte _cntver;

    public Style() {
        super.setVisible(false);
    }

    public Style(String src) {
        this();
        this.setSrc(src);
    }

    public void setDynamic(boolean dynamic) {
    }

    public boolean isDynamic() {
        return true;
    }

    public String getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (this._content != null || !Objects.equals((Object)this._src, (Object)src)) {
            this._src = src;
            this._content = null;
            this.smartUpdate("src", new EncodedURL());
        }
    }

    public String getContent() {
        return this._content;
    }

    public void setContent(String content) {
        if (content != null && content.length() == 0) {
            content = null;
        }
        if (this._src != null || !Objects.equals((Object)this._content, (Object)content)) {
            this._content = content;
            this._src = null;
            this._cntver = (byte)(this._cntver + 1);
            this.smartUpdate("src", new EncodedURL());
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        HtmlPageRenders.RenderContext rc;
        super.renderProperties(renderer);
        boolean gened = false;
        if (this._content != null && (rc = HtmlPageRenders.getRenderContext(null)) != null) {
            Writer out = rc.perm;
            out.write("\n<style id=\"");
            out.write(this.getUuid());
            out.write("$css\" type=\"text/css\">\n");
            out.write(this._content);
            out.write("\n</style>\n");
            gened = true;
        }
        if (!gened) {
            this.render(renderer, "src", this.getEncodedURL());
        }
    }

    public boolean setVisible(boolean visible) {
        throw new UnsupportedOperationException("style is always invisible");
    }

    protected boolean isChildable() {
        return false;
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    private String getEncodedURL() {
        Desktop dt;
        if (this._content != null) {
            return Utils.getDynamicMediaURI(this, this._cntver, "css", "css");
        }
        if (this._src != null && (dt = this.getDesktop()) != null) {
            return dt.getExecution().encodeURL(this._src);
        }
        return "";
    }

    private class EncodedURL
    implements DeferredValue {
        private EncodedURL() {
        }

        public Object getValue() {
            return Style.this.getEncodedURL();
        }
    }

    protected class ExtraCtrl
    implements DynamicMedia {
        protected ExtraCtrl() {
        }

        public Media getMedia(String pathInfo) {
            return new AMedia("css", "css", "text/css;charset=UTF-8", Style.this._content);
        }
    }
}

