/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.MaximizeEvent;
import org.zkoss.zk.ui.event.MinimizeEvent;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.api.Caption;
import org.zkoss.zul.api.Panelchildren;
import org.zkoss.zul.api.Toolbar;
import org.zkoss.zul.ext.Framable;
import org.zkoss.zul.impl.XulElement;

public class Panel
extends XulElement
implements Framable,
org.zkoss.zul.api.Panel {
    private transient org.zkoss.zul.Toolbar _tbar;
    private transient org.zkoss.zul.Toolbar _bbar;
    private transient org.zkoss.zul.Toolbar _fbar;
    private transient org.zkoss.zul.Panelchildren _panelchildren;
    private transient org.zkoss.zul.Caption _caption;
    private String _border = "none";
    private String _title = "";
    private boolean _closable;
    private boolean _collapsible;
    private boolean _floatable;
    private boolean _framable;
    private boolean _movable;
    private boolean _maximizable;
    private boolean _minimizable;
    private boolean _maximized;
    private boolean _minimized;
    private boolean _open = true;

    public boolean isOpen() {
        return this._open;
    }

    public void setOpen(boolean open) {
        if (this._open != open) {
            this._open = open;
            this.smartUpdate("open", this._open);
        }
    }

    public boolean isFramable() {
        return this._framable;
    }

    public void setFramable(boolean framable) {
        if (this._framable != framable) {
            this._framable = framable;
            this.smartUpdate("framable", this._framable);
        }
    }

    public void setMovable(boolean movable) {
        if (this._movable != movable) {
            this._movable = movable;
            this.smartUpdate("movable", this._movable);
        }
    }

    public boolean isMovable() {
        return this._movable;
    }

    public boolean isFloatable() {
        return this._floatable;
    }

    public boolean setVisible(boolean visible) {
        if (visible == this._visible) {
            return visible;
        }
        this._minimized = false;
        this._maximized = false;
        return this.setVisible0(visible);
    }

    private boolean setVisible0(boolean visible) {
        return super.setVisible(visible);
    }

    public void setFloatable(boolean floatable) {
        if (this._floatable != floatable) {
            this._floatable = floatable;
            this.smartUpdate("floatable", this._floatable);
        }
    }

    public boolean isMaximized() {
        return this._maximized;
    }

    public void setMaximized(boolean maximized) {
        if (this._maximized != maximized) {
            if (!this._maximizable) {
                throw new UiException("Not maximizable, " + this);
            }
            this._maximized = maximized;
            if (this._maximized) {
                this._minimized = false;
                this.setVisible0(true);
            }
            this.smartUpdate("maximized", this._maximized);
        }
    }

    public boolean isMaximizable() {
        return this._maximizable;
    }

    public void setMaximizable(boolean maximizable) {
        if (this._maximizable != maximizable) {
            this._maximizable = maximizable;
            this.smartUpdate("maximizable", this._maximizable);
        }
    }

    public boolean isMinimized() {
        return this._minimized;
    }

    public void setMinimized(boolean minimized) {
        if (this._minimized != minimized) {
            if (!this._minimizable) {
                throw new UiException("not minimizable, " + this);
            }
            this._minimized = minimized;
            if (this._minimized) {
                this._maximized = false;
                this.setVisible0(false);
            } else {
                this.setVisible0(true);
            }
            this.smartUpdate("minimized", this._minimized);
        }
    }

    public boolean isMinimizable() {
        return this._minimizable;
    }

    public void setMinimizable(boolean minimizable) {
        if (this._minimizable != minimizable) {
            this._minimizable = minimizable;
            this.smartUpdate("minimizable", this._minimizable);
        }
    }

    public boolean isCollapsible() {
        return this._collapsible;
    }

    public void setCollapsible(boolean collapsible) {
        if (this._collapsible != collapsible) {
            this._collapsible = collapsible;
            this.smartUpdate("collapsible", this._collapsible);
        }
    }

    public boolean isClosable() {
        return this._closable;
    }

    public void setClosable(boolean closable) {
        if (this._closable != closable) {
            this._closable = closable;
            this.smartUpdate("closable", this._closable);
        }
    }

    public org.zkoss.zul.Caption getCaption() {
        return this._caption;
    }

    public Caption getCaptionApi() {
        return this.getCaption();
    }

    public String getBorder() {
        return this._border;
    }

    public void setBorder(String border) {
        if (border == null || "0".equals(border)) {
            border = "none";
        }
        if (!Objects.equals((Object)this._border, (Object)border)) {
            this._border = border;
            this.smartUpdate("border", this._border);
        }
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        if (!Objects.equals((Object)this._title, (Object)title)) {
            this._title = title;
            this.smartUpdate("title", this._title);
        }
    }

    public boolean addToolbar(String name, org.zkoss.zul.Toolbar toolbar) {
        Object refChild = null;
        if ("tbar".equals(name)) {
            if (this._tbar != null) {
                throw new UiException("Only one top toolbar child is allowed: " + this);
            }
            refChild = this.getFirstChild();
        } else if ("bbar".equals(name)) {
            if (this._bbar != null) {
                throw new UiException("Only one bottom toolbar child is allowed: " + this);
            }
            refChild = this._fbar;
        } else if ("fbar".equals(name)) {
            if (this._fbar != null) {
                throw new UiException("Only one foot toolbar child is allowed: " + this);
            }
        } else {
            throw new UiException("Uknown toolbar: " + name);
        }
        if (super.insertBefore((Component)toolbar, refChild)) {
            if ("tbar".equals(name)) {
                this._tbar = toolbar;
            } else if ("bbar".equals(name)) {
                this._bbar = toolbar;
            } else if ("fbar".equals(name)) {
                this._fbar = toolbar;
            }
            return true;
        }
        return false;
    }

    public boolean addToolbarApi(String name, Toolbar toolbarApi) {
        org.zkoss.zul.Toolbar toolbar = (org.zkoss.zul.Toolbar)toolbarApi;
        return this.addToolbar(name, toolbar);
    }

    public void onClose() {
        this.detach();
    }

    public org.zkoss.zul.Toolbar getTopToolbar() {
        return this._tbar;
    }

    public Toolbar getTopToolbarApi() {
        return this.getTopToolbar();
    }

    public org.zkoss.zul.Toolbar getBottomToolbar() {
        return this._bbar;
    }

    public Toolbar getBottomToolbarApi() {
        return this.getBottomToolbar();
    }

    public org.zkoss.zul.Toolbar getFootToolbar() {
        return this._fbar;
    }

    public Toolbar getFootToolbarApi() {
        return this.getFootToolbar();
    }

    public org.zkoss.zul.Panelchildren getPanelchildren() {
        return this._panelchildren;
    }

    public Panelchildren getPanelchildrenApi() {
        return this.getPanelchildren();
    }

    public String getZclass() {
        return this._zclass == null ? "z-panel" : this._zclass;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void beforeChildAdded(Component newChild, Component refChild) {
        if (newChild instanceof org.zkoss.zul.Caption) {
            if (this._caption != null && this._caption != newChild) {
                throw new UiException("Only one caption is allowed: " + this);
            }
        } else {
            if (refChild instanceof org.zkoss.zul.Caption) {
                throw new UiException("caption must be the first child");
            }
            if (newChild instanceof org.zkoss.zul.Panelchildren) {
                if (this._panelchildren != null && this._panelchildren != newChild) {
                    throw new UiException("Only one panelchildren child is allowed: " + this);
                }
            } else {
                if (!(newChild instanceof org.zkoss.zul.Toolbar)) throw new UiException("Unsupported child for Panel: " + newChild);
                if (refChild instanceof org.zkoss.zul.Panelchildren || refChild == null && this.getChildren().isEmpty()) {
                    if (this._tbar != null && this._tbar != newChild) {
                        throw new UiException("Only one top toolbar child is allowed: " + this);
                    }
                } else {
                    if (refChild != null && refChild != this._fbar) throw new UiException("Only three toolbars child is allowed: " + this);
                    if (this._bbar != null && this._bbar != newChild) {
                        if (refChild != null && refChild == this._fbar) {
                            throw new UiException("Only one bottom toolbar child is allowed: " + this);
                        }
                        if (this._fbar != null && this._fbar != newChild) {
                            throw new UiException("Only one foot toolbar child is allowed: " + this);
                        }
                    }
                }
            }
        }
        super.beforeChildAdded(newChild, refChild);
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        if (newChild instanceof org.zkoss.zul.Caption) {
            refChild = this.getFirstChild();
            if (super.insertBefore(newChild, refChild)) {
                this._caption = (org.zkoss.zul.Caption)newChild;
                return true;
            }
        } else if (newChild instanceof org.zkoss.zul.Panelchildren) {
            if (super.insertBefore(newChild, refChild)) {
                this._panelchildren = (org.zkoss.zul.Panelchildren)newChild;
                return true;
            }
        } else if (newChild instanceof org.zkoss.zul.Toolbar) {
            if (super.insertBefore(newChild, refChild)) {
                if (refChild instanceof org.zkoss.zul.Panelchildren || refChild == null && this.getChildren().size() == (this._caption != null ? 2 : 1)) {
                    this._tbar = (org.zkoss.zul.Toolbar)newChild;
                } else if (refChild == null || refChild == this._fbar) {
                    if (this._bbar != null && this._bbar != newChild) {
                        this._fbar = (org.zkoss.zul.Toolbar)newChild;
                    } else {
                        this._bbar = (org.zkoss.zul.Toolbar)newChild;
                    }
                }
                return true;
            }
        } else {
            return super.insertBefore(newChild, refChild);
        }
        return false;
    }

    public void onChildRemoved(Component child) {
        super.onChildRemoved(child);
        if (this._caption == child) {
            this._caption = null;
        } else if (this._tbar == child) {
            this._tbar = null;
        } else if (this._bbar == child) {
            this._bbar = null;
        } else if (this._panelchildren == child) {
            this._panelchildren = null;
        } else if (this._fbar == child) {
            this._fbar = null;
        }
    }

    public Object clone() {
        Panel clone = (Panel)super.clone();
        clone.afterUnmarshal();
        return clone;
    }

    private void afterUnmarshal() {
        if (this._caption != null) {
            this._caption = (org.zkoss.zul.Caption)this.getChildren().get(this._caption.getParent().getChildren().indexOf(this._caption));
        }
        if (this._tbar != null) {
            this._tbar = (org.zkoss.zul.Toolbar)this.getChildren().get(this._tbar.getParent().getChildren().indexOf(this._tbar));
        }
        if (this._panelchildren != null) {
            this._panelchildren = (org.zkoss.zul.Panelchildren)this.getChildren().get(this._panelchildren.getParent().getChildren().indexOf(this._panelchildren));
        }
        if (this._bbar != null) {
            this._bbar = (org.zkoss.zul.Toolbar)this.getChildren().get(this._bbar.getParent().getChildren().indexOf(this._bbar));
        }
        if (this._fbar != null) {
            this._fbar = (org.zkoss.zul.Toolbar)this.getChildren().get(this._fbar.getParent().getChildren().indexOf(this._fbar));
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.afterUnmarshal();
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._title.length() > 0) {
            this.render(renderer, "title", this._title);
        }
        if (this._closable) {
            this.render(renderer, "closable", this._closable);
        }
        if (this._floatable) {
            this.render(renderer, "floatable", this._floatable);
        }
        if (this._collapsible) {
            this.render(renderer, "collapsible", this._collapsible);
        }
        if (this._framable) {
            this.render(renderer, "framable", this._framable);
        }
        if (this._movable) {
            this.render(renderer, "movable", this._movable);
        }
        if (this._maximizable) {
            this.render(renderer, "maximizable", this._maximizable);
        }
        if (this._minimizable) {
            this.render(renderer, "minimizable", this._minimizable);
        }
        if (this._maximized) {
            this.render(renderer, "maximized", this._maximized);
        }
        if (this._minimized) {
            this.render(renderer, "minimized", this._minimized);
        }
        if (!this._open) {
            this.render(renderer, "open", this._open);
        }
        if (!"none".equals(this._border)) {
            renderer.render("border", this._border);
        }
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onOpen")) {
            OpenEvent evt = OpenEvent.getOpenEvent((AuRequest)request);
            this._open = evt.isOpen();
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onMaximize")) {
            MaximizeEvent evt = MaximizeEvent.getMaximizeEvent((AuRequest)request);
            this._left = evt.getLeft();
            this._top = evt.getTop();
            this._width = evt.getWidth();
            this._height = evt.getHeight();
            this._maximized = evt.isMaximized();
            if (this._maximized) {
                this._visible = true;
            }
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onMinimize")) {
            MinimizeEvent evt = MinimizeEvent.getMinimizeEvent((AuRequest)request);
            this._left = evt.getLeft();
            this._top = evt.getTop();
            this._width = evt.getWidth();
            this._height = evt.getHeight();
            this._minimized = evt.isMinimized();
            if (this._minimized) {
                this._visible = false;
            }
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    static {
        Panel.addClientEvent((Class)Panel.class, (String)"onClose", (int)0);
        Panel.addClientEvent((Class)Panel.class, (String)"onMove", (int)8193);
        Panel.addClientEvent((Class)Panel.class, (String)"onOpen", (int)1);
        Panel.addClientEvent((Class)Panel.class, (String)"onZIndex", (int)8193);
        Panel.addClientEvent((Class)Panel.class, (String)"onMaximize", (int)8193);
        Panel.addClientEvent((Class)Panel.class, (String)"onMinimize", (int)8193);
    }
}

