/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listgroup;
import org.zkoss.zul.impl.XulElement;

public class Listitem
extends XulElement
implements org.zkoss.zul.api.Listitem {
    private static final Log log = Log.lookup((Class)Listitem.class);
    private Object _value;
    private int _index = -1;
    private boolean _selected;
    private boolean _disabled;
    private boolean _checkable = true;
    private boolean _loaded;

    public Listitem() {
    }

    public Listitem(String label) {
        this.setLabel(label);
    }

    public Listitem(String label, Object value) {
        this.setLabel(label);
        this.setValue(value);
    }

    public Listbox getListbox() {
        return (Listbox)this.getParent();
    }

    public org.zkoss.zul.api.Listbox getListboxApi() {
        return this.getListbox();
    }

    private final boolean inSelectMold() {
        Listbox listbox = this.getListbox();
        return listbox != null && listbox.inSelectMold();
    }

    public Listgroup getListgroup() {
        if (this instanceof Listgroup) {
            return (Listgroup)this;
        }
        Listbox lb = this.getListbox();
        if (lb != null) {
            return lb.getListgroupAt(this.getIndex());
        }
        return null;
    }

    public org.zkoss.zul.api.Listgroup getListgroupApi() {
        return this.getListgroup();
    }

    public String getZclass() {
        return this._zclass == null ? "z-listitem" : this._zclass;
    }

    public boolean isCheckable() {
        return this._checkable;
    }

    public void setCheckable(boolean checkable) {
        if (this._checkable != checkable) {
            this._checkable = checkable;
            this.smartUpdate("checkable", checkable);
        }
    }

    public int getMaxlength() {
        Listbox listbox = this.getListbox();
        return listbox != null ? listbox.getMaxlength() : 0;
    }

    public Object getValue() {
        return this._value;
    }

    public void setValue(Object value) {
        if (!Objects.equals((Object)this._value, (Object)value)) {
            this._value = value;
            Listbox listbox = this.getListbox();
            if (listbox != null) {
                if (listbox.inSelectMold()) {
                    this.smartUpdate("value", this._value);
                } else if (listbox.getName() != null) {
                    this.smartUpdate("value", this._value);
                }
            }
        }
    }

    public final boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("disabled", this._disabled);
        }
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean selected) {
        if (this._selected != selected) {
            Listbox listbox = (Listbox)this.getParent();
            if (listbox != null) {
                listbox.toggleItemSelection(this);
            } else {
                this._selected = selected;
            }
        }
    }

    public String getLabel() {
        Listcell cell = (Listcell)this.getFirstChild();
        return cell != null ? cell.getLabel() : null;
    }

    public void setLabel(String label) {
        this.autoFirstCell().setLabel(label);
    }

    private Listcell autoFirstCell() {
        Listcell cell = (Listcell)this.getFirstChild();
        if (cell == null) {
            cell = new Listcell();
            cell.applyProperties();
            cell.setParent((Component)this);
        }
        return cell;
    }

    public String getSrc() {
        return this.getImage();
    }

    public void setSrc(String src) {
        this.setImage(src);
    }

    public String getImage() {
        Listcell cell = (Listcell)this.getFirstChild();
        return cell != null ? cell.getImage() : null;
    }

    public void setImage(String image) {
        this.autoFirstCell().setImage(image);
    }

    public final int getIndex() {
        return this._index;
    }

    final void setLoaded(boolean loaded) {
        if (loaded != this._loaded) {
            this._loaded = loaded;
            Listbox listbox = this.getListbox();
            if (listbox != null && listbox.getModel() != null) {
                this.smartUpdate("_loaded", this._loaded);
            }
        }
    }

    public boolean isLoaded() {
        return this._loaded;
    }

    final void setIndexDirectly(int index) {
        this.setIndex(index);
    }

    protected void setIndex(int index) {
        this._index = index;
    }

    final void setSelectedDirectly(boolean selected) {
        this._selected = selected;
    }

    public boolean setVisible(boolean visible) {
        if (this.isVisible() != visible) {
            Listgroup g;
            this.smartUpdate("visible", visible);
            Listbox listbox = (Listbox)this.getParent();
            if (listbox != null && ((g = listbox.getListgroupAt(this.getIndex())) == null || g.isOpen())) {
                listbox.addVisibleItemCount(visible ? 1 : -1);
            }
        }
        return super.setVisible(visible);
    }

    protected void smartUpdate(String name, Object value) {
        super.smartUpdate(name, value);
    }

    protected void smartUpdate(String name, boolean value) {
        super.smartUpdate(name, value);
    }

    public String getMold() {
        return this.getParent() != null ? ("select".equals(this.getParent().getMold()) ? "select" : super.getMold()) : super.getMold();
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "selected", this.isSelected());
        this.render(renderer, "disabled", this.isDisabled());
        this.render(renderer, "_loaded", this._loaded);
        if (!this.isCheckable()) {
            renderer.render("checkable", false);
        }
    }

    public void beforeParentChanged(Component parent) {
        if (parent != null && !(parent instanceof Listbox)) {
            throw new UiException("Listitem's parent must be Listbox, not " + parent);
        }
        super.beforeParentChanged(parent);
    }

    public void beforeChildAdded(Component child, Component refChild) {
        if (!(child instanceof Listcell)) {
            throw new UiException("Unsupported child for listitem: " + child);
        }
        super.beforeChildAdded(child, refChild);
    }

    public Object clone() {
        Listitem clone = (Listitem)super.clone();
        clone._index = -1;
        return clone;
    }
}

