/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Objects;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zk.ui.ext.render.Cropper;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.Auxhead;
import org.zkoss.zul.Frozen;
import org.zkoss.zul.GroupDataInfo;
import org.zkoss.zul.GroupsListModel;
import org.zkoss.zul.GroupsModel;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listgroup;
import org.zkoss.zul.ListgroupRendererExt;
import org.zkoss.zul.Listgroupfoot;
import org.zkoss.zul.Listhead;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.ListitemRendererExt;
import org.zkoss.zul.RendererCtrl;
import org.zkoss.zul.api.Listfoot;
import org.zkoss.zul.api.Listitem;
import org.zkoss.zul.api.Paging;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;
import org.zkoss.zul.event.PagingEvent;
import org.zkoss.zul.ext.Paginal;
import org.zkoss.zul.ext.Paginated;
import org.zkoss.zul.impl.XulElement;

public class Listbox
extends XulElement
implements Paginated,
org.zkoss.zul.api.Listbox {
    private static final Log log;
    private static final String ATTR_ON_INIT_RENDER_POSTED = "org.zkoss.zul.Listbox.onInitLaterPosted";
    private transient List _items;
    private transient List _groupsInfo;
    private transient List _groups;
    private transient Set _selItems;
    private transient Set _roSelItems;
    private int _maxlength;
    private int _rows;
    private int _jsel = -1;
    private transient Listhead _listhead;
    private transient org.zkoss.zul.Listfoot _listfoot;
    private transient Frozen _frozen;
    private ListModel _model;
    private ListitemRenderer _renderer;
    private transient ListDataListener _dataListener;
    private transient Collection _heads;
    private int _hdcnt;
    private String _innerWidth = "100%";
    private String _pagingPosition = "bottom";
    private String _name;
    private transient Paginal _pgi;
    private transient org.zkoss.zul.Paging _paging;
    private transient EventListener _pgListener;
    private transient EventListener _pgImpListener;
    private String _scOddRow = null;
    private int _tabindex = -1;
    private int _preloadsz = 7;
    private boolean _multiple;
    private boolean _disabled;
    private boolean _checkmark;
    private boolean _vflex;
    private boolean _noSmartUpdate;
    private boolean _sizedByContent;
    private int _visibleItemCount;
    private static final ListitemRenderer _defRend;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Listbox() {
        this.init();
    }

    private void init() {
        this._items = new AbstractSequentialList(){

            public ListIterator listIterator(int index) {
                return new ItemIter(index);
            }

            public Object get(int j) {
                Object o = Listbox.this.getChildren().get(j + Listbox.this._hdcnt);
                if (!(o instanceof org.zkoss.zul.Listitem)) {
                    throw new IndexOutOfBoundsException("Wrong index: " + j);
                }
                return o;
            }

            public int size() {
                int sz = Listbox.this.getChildren().size() - Listbox.this._hdcnt;
                if (Listbox.this._listfoot != null) {
                    --sz;
                }
                if (Listbox.this._paging != null) {
                    --sz;
                }
                if (Listbox.this._frozen != null) {
                    --sz;
                }
                return sz;
            }

            protected void removeRange(int fromIndex, int toIndex) {
                ListIterator it = this.listIterator(toIndex);
                int n = toIndex - fromIndex;
                while (--n >= 0) {
                    it.previous();
                    it.remove();
                }
            }
        };
        this._selItems = new LinkedHashSet(5);
        this._roSelItems = Collections.unmodifiableSet(this._selItems);
        this._heads = new AbstractCollection(){

            public int size() {
                return Listbox.this._hdcnt;
            }

            public Iterator iterator() {
                return new Iter();
            }
        };
        this._groupsInfo = new LinkedList();
        this._groups = new AbstractList(){

            public int size() {
                return Listbox.this.getGroupCount();
            }

            public Iterator iterator() {
                return new IterGroups();
            }

            public Object get(int index) {
                return Listbox.this.getItemAtIndex(((int[])Listbox.this._groupsInfo.get(index))[0]);
            }
        };
    }

    protected List newChildren() {
        return new Children();
    }

    private void initDataListener() {
        if (this._dataListener == null) {
            this._dataListener = new ListDataListener(){

                public void onChange(ListDataEvent event) {
                    Listbox.this.onListDataChange(event);
                }
            };
        }
        this._model.addListDataListener(this._dataListener);
    }

    public void setFixedLayout(boolean fixedLayout) {
        this.setSizedByContent(!fixedLayout);
    }

    public boolean isFixedLayout() {
        return !this.isSizedByContent();
    }

    public void setSizedByContent(boolean byContent) {
        if (this._sizedByContent != byContent) {
            this._sizedByContent = byContent;
            this.smartUpdate("sizedByContent", byContent);
        }
    }

    public boolean isSizedByContent() {
        String s = (String)this.getAttribute("sized-by-content");
        if (s == null) {
            s = (String)this.getAttribute("fixed-layout");
            return s != null ? !"true".equalsIgnoreCase(s) : this._sizedByContent;
        }
        return "true".equalsIgnoreCase(s);
    }

    public Listhead getListhead() {
        return this._listhead;
    }

    public org.zkoss.zul.api.Listhead getListheadApi() {
        return this.getListhead();
    }

    public org.zkoss.zul.Listfoot getListfoot() {
        return this._listfoot;
    }

    public Frozen getFrozen() {
        return this._frozen;
    }

    public Listfoot getListfootApi() {
        return this.getListfoot();
    }

    public Collection getHeads() {
        return this._heads;
    }

    final boolean inSelectMold() {
        return "select".equals(this.getMold());
    }

    public final boolean isCheckmark() {
        return this._checkmark;
    }

    public void setCheckmark(boolean checkmark) {
        if (this._checkmark != checkmark) {
            this._checkmark = checkmark;
            this.smartUpdate("checkmark", checkmark);
        }
    }

    public void setInnerWidth(String innerWidth) {
        if (innerWidth == null) {
            innerWidth = "100%";
        }
        if (!this._innerWidth.equals(innerWidth)) {
            this._innerWidth = innerWidth;
            this.smartUpdate("innerWidth", innerWidth);
        }
    }

    public String getInnerWidth() {
        return this._innerWidth;
    }

    public final boolean isVflex() {
        return this._vflex;
    }

    public void setVflex(boolean vflex) {
        if (this._vflex != vflex) {
            this._vflex = vflex;
            this.smartUpdate("flex", this._vflex);
        }
    }

    public final boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            this._disabled = disabled;
            this.smartUpdate("disabled", this._disabled);
        }
    }

    public int getTabindex() {
        return this._tabindex;
    }

    public void setTabindex(int tabindex) throws WrongValueException {
        if (this._tabindex != tabindex) {
            this._tabindex = tabindex;
            this.smartUpdate("tabindex", this._tabindex);
        }
    }

    public int getRows() {
        return this._rows;
    }

    public void setRows(int rows) throws WrongValueException {
        if (rows < 0) {
            throw new WrongValueException("Illegal rows: " + rows);
        }
        if (this._rows != rows) {
            this._rows = rows;
            this.smartUpdate("rows", this._rows);
        }
    }

    public String getSeltype() {
        return this._multiple ? "multiple" : "single";
    }

    public void setSeltype(String seltype) throws WrongValueException {
        if ("single".equals(seltype)) {
            this.setMultiple(false);
        } else if ("multiple".equals(seltype)) {
            this.setMultiple(true);
        } else {
            throw new WrongValueException("Unknown seltype: " + seltype);
        }
    }

    public boolean isMultiple() {
        return this._multiple;
    }

    public void setMultiple(boolean multiple) {
        if (this._multiple != multiple) {
            this._multiple = multiple;
            if (!this._multiple && this._selItems.size() > 1) {
                org.zkoss.zul.Listitem item = this.getSelectedItem();
                Iterator it = this._selItems.iterator();
                while (it.hasNext()) {
                    org.zkoss.zul.Listitem li = (org.zkoss.zul.Listitem)it.next();
                    if (li == item) continue;
                    li.setSelectedDirectly(false);
                    it.remove();
                }
            }
            this.smartUpdate("multiple", this._multiple);
        }
    }

    private String getSelUuid() {
        org.zkoss.zul.Listitem sel = this.getSelectedItem();
        return sel != null ? sel.getUuid() : null;
    }

    public int getMaxlength() {
        return this._maxlength;
    }

    public void setMaxlength(int maxlength) {
        if (maxlength < 0) {
            maxlength = 0;
        }
        if (this._maxlength != maxlength) {
            this._maxlength = maxlength;
            this.smartUpdate("maxlength", maxlength);
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            this._name = name;
            this.smartUpdate("name", name);
        }
    }

    public List getItems() {
        return this._items;
    }

    public int getItemCount() {
        return this._items.size();
    }

    public org.zkoss.zul.Listitem getItemAtIndex(int index) {
        return (org.zkoss.zul.Listitem)this._items.get(index);
    }

    public Listitem getItemAtIndexApi(int index) {
        return this.getItemAtIndex(index);
    }

    public int getIndexOfItem(org.zkoss.zul.Listitem item) {
        return item == null ? -1 : item.getIndex();
    }

    public int getIndexOfItemApi(Listitem itemApi) {
        org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)itemApi;
        return this.getIndexOfItem(item);
    }

    public int getSelectedIndex() {
        return this._jsel;
    }

    public void setSelectedIndex(int jsel) {
        org.zkoss.zul.Listitem item;
        if (jsel >= this._items.size()) {
            throw new UiException("Out of bound: " + jsel + " while size=" + this._items.size());
        }
        if (jsel < -1) {
            jsel = -1;
        }
        if (jsel < 0) {
            this.clearSelection();
        } else if (jsel != this._jsel || this._multiple && this._selItems.size() > 1) {
            Iterator it = this._selItems.iterator();
            while (it.hasNext()) {
                org.zkoss.zul.Listitem item2 = (org.zkoss.zul.Listitem)it.next();
                item2.setSelectedDirectly(false);
            }
            this._selItems.clear();
            this._jsel = jsel;
            item = this.getItemAtIndex(this._jsel);
            item.setSelectedDirectly(true);
            this._selItems.add(item);
            if (this.inSelectMold()) {
                this.smartUpdate("selectedIndex", this._jsel);
            } else {
                this.smartUpdate("selectedItem", item.getUuid());
            }
        }
        if (this._jsel >= 0 && this.inPagingMold()) {
            item = this.getItemAtIndex(this._jsel);
            int size = 0;
            VisibleChildrenIterator it = new VisibleChildrenIterator(true);
            while (it.hasNext() && !item.equals(it.next())) {
                ++size;
            }
            int pg = size / this.getPageSize();
            if (pg != this.getActivePage()) {
                this.setActivePage(pg);
            }
        }
    }

    public void selectItem(org.zkoss.zul.Listitem item) {
        if (item == null) {
            this.setSelectedIndex(-1);
        } else {
            if (item.getParent() != this) {
                throw new UiException("Not a child: " + item);
            }
            if (this._multiple || !item.isSelected()) {
                this.setSelectedIndex(item.getIndex());
            }
        }
    }

    public void selectItemApi(Listitem itemApi) {
        org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)itemApi;
        this.selectItem(item);
    }

    public void addItemToSelection(org.zkoss.zul.Listitem item) {
        if (item.getParent() != this) {
            throw new UiException("Not a child: " + item);
        }
        if (!item.isSelected()) {
            if (!this._multiple) {
                this.selectItem(item);
            } else {
                if (item.getIndex() < this._jsel || this._jsel < 0) {
                    this._jsel = item.getIndex();
                    if (!this.inSelectMold()) {
                        this.smartUpdate("selectedItem", this.getSelUuid());
                    }
                }
                item.setSelectedDirectly(true);
                this._selItems.add(item);
                if (this.inSelectMold()) {
                    item.smartUpdate("selected", true);
                } else {
                    this.smartUpdateSelection();
                }
            }
        }
    }

    public void addItemToSelectionApi(Listitem itemApi) {
        org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)itemApi;
        this.addItemToSelection(item);
    }

    public void removeItemFromSelection(org.zkoss.zul.Listitem item) {
        if (item.getParent() != this) {
            throw new UiException("Not a child: " + item);
        }
        if (item.isSelected()) {
            if (!this._multiple) {
                this.clearSelection();
            } else {
                int oldSel = this._jsel;
                item.setSelectedDirectly(false);
                this._selItems.remove(item);
                this.fixSelectedIndex(0);
                if (this.inSelectMold()) {
                    item.smartUpdate("selected", false);
                } else {
                    this.smartUpdateSelection();
                    if (oldSel != this._jsel) {
                        this.smartUpdate("selectedItem", this.getSelUuid());
                    }
                }
            }
        }
    }

    public void removeItemFromSelectionApi(Listitem itemApi) {
        org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)itemApi;
        this.removeItemFromSelection(item);
    }

    private void smartUpdateSelection() {
        StringBuffer sb = new StringBuffer(80);
        Iterator it = this._selItems.iterator();
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(((org.zkoss.zul.Listitem)it.next()).getUuid());
        }
        this.smartUpdate("chgSel", sb.toString());
    }

    public void toggleItemSelection(org.zkoss.zul.Listitem item) {
        if (item.isSelected()) {
            this.removeItemFromSelection(item);
        } else {
            this.addItemToSelection(item);
        }
    }

    public void toggleItemSelectionApi(Listitem itemApi) {
        org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)itemApi;
        this.toggleItemSelection(item);
    }

    public void clearSelection() {
        if (!this._selItems.isEmpty()) {
            Iterator it = this._selItems.iterator();
            while (it.hasNext()) {
                org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)it.next();
                item.setSelectedDirectly(false);
            }
            this._selItems.clear();
            this._jsel = -1;
            if (this.inSelectMold()) {
                this.smartUpdate("selectedIndex", -1);
            } else {
                this.smartUpdate("selectedItem", null);
            }
        }
    }

    public void selectAll() {
        if (!this._multiple) {
            throw new UiException("Appliable only to the multiple seltype: " + this);
        }
        if (this._items.size() != this._selItems.size()) {
            Iterator it = this._items.iterator();
            while (it.hasNext()) {
                org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)it.next();
                this._selItems.add(item);
                item.setSelectedDirectly(true);
            }
            this._jsel = this._items.isEmpty() ? -1 : 0;
            this.smartUpdate("selectAll", true);
        }
    }

    public org.zkoss.zul.Listitem getSelectedItem() {
        return this._jsel >= 0 ? (this._jsel > 0 && this._selItems.size() == 1 ? (org.zkoss.zul.Listitem)this._selItems.iterator().next() : this.getItemAtIndex(this._jsel)) : null;
    }

    public Listitem getSelectedItemApi() {
        return this.getSelectedItem();
    }

    public void setSelectedItem(org.zkoss.zul.Listitem item) {
        this.selectItem(item);
    }

    public void setSelectedItemApi(Listitem itemApi) {
        org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)itemApi;
        this.selectItem(item);
    }

    public void setSelectedItems(Set listItems) {
        if (!this.isMultiple()) {
            throw new WrongValueException("Listbox must allow multiple selections.");
        }
        Iterator it = listItems.iterator();
        while (it.hasNext()) {
            this.addItemToSelection((org.zkoss.zul.Listitem)it.next());
        }
    }

    public Set getSelectedItems() {
        return this._roSelItems;
    }

    public int getSelectedCount() {
        return this._selItems.size();
    }

    public org.zkoss.zul.Listitem appendItem(String label, String value) {
        org.zkoss.zul.Listitem item = new org.zkoss.zul.Listitem(label, value);
        item.applyProperties();
        item.setParent((Component)this);
        return item;
    }

    public Listitem appendItemApi(String label, String value) {
        return this.appendItem(label, value);
    }

    public org.zkoss.zul.Listitem removeItemAt(int index) {
        org.zkoss.zul.Listitem item = this.getItemAtIndex(index);
        this.removeChild((Component)item);
        return item;
    }

    public Listitem removeItemAtApi(int index) {
        return this.removeItemAt(index);
    }

    public void setPagingPosition(String pagingPosition) {
        if (pagingPosition == null || !pagingPosition.equals("top") && !pagingPosition.equals("bottom") && !pagingPosition.equals("both")) {
            throw new WrongValueException("Unsupported position : " + pagingPosition);
        }
        if (!Objects.equals((Object)this._pagingPosition, (Object)pagingPosition)) {
            this._pagingPosition = pagingPosition;
            this.smartUpdate("pagingPosition", pagingPosition);
        }
    }

    public String getPagingPosition() {
        return this._pagingPosition;
    }

    public Paginal getPaginal() {
        return this._pgi;
    }

    public void setPaginal(Paginal pgi) {
        if (!Objects.equals((Object)pgi, (Object)this._pgi)) {
            Paginal old = this._pgi;
            this._pgi = pgi;
            if (this.inPagingMold()) {
                if (old != null) {
                    this.removePagingListener(old);
                }
                if (this._pgi == null) {
                    if (this._paging != null) {
                        this._pgi = this._paging;
                    } else {
                        this.newInternalPaging();
                    }
                } else if (this._pgi != this._paging) {
                    if (this._paging != null) {
                        this._paging.detach();
                    }
                    this._pgi.setTotalSize(this.getVisibleItemCount());
                    this.addPagingListener(this._pgi);
                }
            }
        }
    }

    private void newInternalPaging() {
        if (!$assertionsDisabled && !this.inPagingMold()) {
            throw new AssertionError((Object)"paging mold only");
        }
        if (!($assertionsDisabled || this._paging == null && this._pgi == null)) {
            throw new AssertionError();
        }
        org.zkoss.zul.Paging paging = new org.zkoss.zul.Paging();
        paging.setAutohide(true);
        paging.setDetailed(true);
        paging.setTotalSize(this.getVisibleItemCount());
        paging.setParent((Component)this);
        this.addPagingListener(this._pgi);
    }

    private void addPagingListener(Paginal pgi) {
        if (this._pgListener == null) {
            this._pgListener = new EventListener(){

                public void onEvent(Event event) {
                    PagingEvent evt = (PagingEvent)event;
                    Events.postEvent((Event)new PagingEvent(evt.getName(), (Component)Listbox.this, evt.getPageable(), evt.getActivePage()));
                }
            };
        }
        pgi.addEventListener("onPaging", this._pgListener);
        if (this._pgImpListener == null) {
            this._pgImpListener = new EventListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onEvent(Event event) {
                    if (Listbox.this._model != null && Listbox.this.inPagingMold()) {
                        Renderer renderer = new Renderer();
                        try {
                            Paginal pgi = Listbox.this.getPaginal();
                            int pgsz = pgi.getPageSize();
                            int ofs = pgi.getActivePage() * pgsz;
                            ListIterator it = Listbox.this.getItems().listIterator(ofs);
                            while (--pgsz >= 0 && it.hasNext()) {
                                renderer.render((org.zkoss.zul.Listitem)it.next());
                            }
                        }
                        catch (Throwable ex) {
                            renderer.doCatch(ex);
                        }
                        finally {
                            renderer.doFinally();
                        }
                    }
                    Listbox.this.invalidate();
                }
            };
        }
        pgi.addEventListener("onPagingImpl", this._pgImpListener);
    }

    private void removePagingListener(Paginal pgi) {
        pgi.removeEventListener("onPaging", this._pgListener);
        pgi.removeEventListener("onPagingImpl", this._pgImpListener);
    }

    public org.zkoss.zul.Paging getPagingChild() {
        return this._paging;
    }

    public Paging getPagingChildApi() {
        return this.getPagingChild();
    }

    public int getPageSize() {
        return this.pgi().getPageSize();
    }

    public void setPageSize(int pgsz) throws WrongValueException {
        this.pgi().setPageSize(pgsz);
    }

    public int getPageCount() {
        return this.pgi().getPageCount();
    }

    public int getActivePage() {
        return this.pgi().getActivePage();
    }

    public void setActivePage(int pg) throws WrongValueException {
        this.pgi().setActivePage(pg);
    }

    private Paginal pgi() {
        if (this._pgi == null) {
            throw new IllegalStateException("Available only the paging mold");
        }
        return this._pgi;
    }

    public void setActivePage(org.zkoss.zul.Listitem item) {
        int pg;
        if (item != null && item.getParent() == this && (pg = item.getIndex() / this.getPageSize()) != this.getActivePage()) {
            this.setActivePage(pg);
        }
    }

    public void setActivePage(Listitem itemApi) {
        org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)itemApi;
        this.setActivePage(item);
    }

    boolean inPagingMold() {
        return "paging".equals(this.getMold());
    }

    public int getVisibleItemCount() {
        return this._visibleItemCount;
    }

    void addVisibleItemCount(int count) {
        if (count != 0) {
            this._visibleItemCount += count;
            if (this.inPagingMold()) {
                Paginal pgi = this.getPaginal();
                pgi.setTotalSize(this._visibleItemCount);
                this.invalidate();
            }
        }
    }

    public String getOddRowSclass() {
        return this._scOddRow == null ? this.getZclass() + "-odd" : this._scOddRow;
    }

    public void setOddRowSclass(String scls) {
        if (scls != null && scls.length() == 0) {
            scls = null;
        }
        if (!Objects.equals((Object)this._scOddRow, (Object)scls)) {
            this._scOddRow = scls;
            this.smartUpdate("oddRowSclass", scls);
        }
    }

    public int getGroupCount() {
        return this._groupsInfo.size();
    }

    public List getGroups() {
        return this._groups;
    }

    public boolean hasGroup() {
        return !this._groupsInfo.isEmpty();
    }

    protected void smartUpdate(String attr, Object value) {
        if (!this._noSmartUpdate) {
            super.smartUpdate(attr, value);
        }
    }

    void fixGroupIndex(int j, int to, boolean infront) {
        int beginning = j;
        ListIterator it = this._items.listIterator(j);
        while (it.hasNext() && (to < 0 || j <= to)) {
            int[] g;
            Object o = it.next();
            ((org.zkoss.zul.Listitem)o).setIndexDirectly(j);
            if ((!infront || beginning != j) && o instanceof Listgroup && (g = this.getLastGroupsInfoAt(j + (infront ? -1 : 1))) != null) {
                g[0] = j;
                if (g[2] != -1) {
                    g[2] = g[2] + (infront ? 1 : -1);
                }
            }
            ++j;
        }
    }

    Listgroup getListgroupAt(int index) {
        if (this._groupsInfo.isEmpty()) {
            return null;
        }
        int[] g = this.getGroupsInfoAt(index);
        if (g != null) {
            return (Listgroup)this.getItemAtIndex(g[0]);
        }
        return null;
    }

    int[] getGroupsInfoAt(int index) {
        return this.getGroupsInfoAt(index, false);
    }

    int[] getLastGroupsInfoAt(int index) {
        int[] rg = null;
        Iterator it = this._groupsInfo.iterator();
        while (it.hasNext()) {
            int[] g = (int[])it.next();
            if (index == g[0]) {
                rg = g;
                continue;
            }
            if (index >= g[0]) continue;
            break;
        }
        return rg;
    }

    int[] getGroupsInfoAt(int index, boolean isListgroup) {
        Iterator it = this._groupsInfo.iterator();
        while (it.hasNext()) {
            int[] g = (int[])it.next();
            if (!(isListgroup ? index == g[0] : index > g[0] && index <= g[0] + g[1])) continue;
            return g;
        }
        return null;
    }

    public void beforeChildAdded(Component newChild, Component refChild) {
        if (newChild instanceof org.zkoss.zul.Listitem) {
            if (newChild instanceof Listgroup && this.inSelectMold()) {
                throw new UnsupportedOperationException("Unsupported Listgroup in Select mold!");
            }
            if (newChild instanceof Listgroupfoot) {
                if (!this.hasGroup()) {
                    throw new UiException("Listgroupfoot cannot exist alone, you have to add a Listgroup first");
                }
                if (refChild == null && this.getLastChild() instanceof Listgroupfoot) {
                    throw new UiException("Only one Listgroupfoot is allowed per Listgroup");
                }
            }
        } else if (newChild instanceof Listhead) {
            if (this._listhead != null && this._listhead != newChild) {
                throw new UiException("Only one listhead is allowed: " + this);
            }
        } else if (newChild instanceof Frozen) {
            if (this._frozen != null && this._frozen != newChild) {
                throw new UiException("Only one frozen child is allowed: " + this);
            }
            if (this.inSelectMold()) {
                log.warning("Mold select ignores frozen");
            }
        } else if (newChild instanceof org.zkoss.zul.Listfoot) {
            if (this._listfoot != null && this._listfoot != newChild) {
                throw new UiException("Only one listfoot is allowed: " + this);
            }
            if (this.inSelectMold()) {
                log.warning("Mold select ignores listfoot");
            }
        } else if (newChild instanceof org.zkoss.zul.Paging) {
            if (this._paging != null && this._paging != newChild) {
                throw new UiException("Only one paging is allowed: " + this);
            }
            if (this._pgi != null) {
                throw new UiException("External paging cannot coexist with child paging");
            }
            if (!this.inPagingMold()) {
                throw new UiException("The child paging is allowed only in the paging mold");
            }
        } else if (!(newChild instanceof Auxhead)) {
            throw new UiException("Unsupported child for Listbox: " + newChild);
        }
        super.beforeChildAdded(newChild, refChild);
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        if (newChild instanceof org.zkoss.zul.Listitem) {
            int jfrom;
            boolean isReorder;
            boolean bl = isReorder = newChild.getParent() == this;
            if (newChild instanceof Listgroupfoot) {
                int nindex;
                int[] ginfo;
                int[] g;
                if (refChild == null) {
                    int idx;
                    int[] ginfo2;
                    if (isReorder && (ginfo2 = this.getGroupsInfoAt(idx = ((Listgroupfoot)newChild).getIndex())) != null) {
                        ginfo2[1] = ginfo2[1] - 1;
                        ginfo2[2] = -1;
                    }
                    int[] g2 = (int[])this._groupsInfo.get(this.getGroupCount() - 1);
                    g2[2] = ((org.zkoss.zul.Listitem)this.getItems().get(this.getItems().size() - (isReorder ? 2 : 1))).getIndex();
                } else if (refChild instanceof org.zkoss.zul.Listitem) {
                    int idx = ((org.zkoss.zul.Listitem)refChild).getIndex();
                    g = this.getGroupsInfoAt(idx);
                    if (g == null) {
                        throw new UiException("Listgroupfoot cannot exist alone, you have to add a Listgroup first");
                    }
                    if (g[2] != -1) {
                        throw new UiException("Only one Listgroupfoot is allowed per Listgroup");
                    }
                    if (idx != g[0] + g[1]) {
                        throw new UiException("Listgroupfoot must be placed after the last Row of the Listgroup");
                    }
                    g[2] = idx - 1;
                    if (isReorder && (ginfo = this.getGroupsInfoAt(nindex = ((Listgroupfoot)newChild).getIndex())) != null) {
                        ginfo[1] = ginfo[1] - 1;
                        ginfo[2] = -1;
                    }
                } else if (refChild.getPreviousSibling() instanceof org.zkoss.zul.Listitem) {
                    int idx = ((org.zkoss.zul.Listitem)refChild.getPreviousSibling()).getIndex();
                    g = this.getGroupsInfoAt(idx);
                    if (g == null) {
                        throw new UiException("Listgroupfoot cannot exist alone, you have to add a Listgroup first");
                    }
                    if (g[2] != -1) {
                        throw new UiException("Only one Listgroupfoot is allowed per Listgroup");
                    }
                    if (idx + 1 != g[0] + g[1]) {
                        throw new UiException("Listgroupfoot must be placed after the last Row of the Listgroup");
                    }
                    g[2] = idx;
                    if (isReorder && (ginfo = this.getGroupsInfoAt(nindex = ((Listgroupfoot)newChild).getIndex())) != null) {
                        ginfo[1] = ginfo[1] - 1;
                        ginfo[2] = -1;
                    }
                }
            }
            if (refChild != null && refChild.getParent() != this) {
                refChild = null;
            }
            if (refChild != null && (refChild == this._listhead || refChild instanceof Auxhead)) {
                refChild = this.getChildren().size() > this._hdcnt ? (Component)this.getChildren().get(this._hdcnt) : null;
            }
            refChild = this.fixRefChildBeforeFoot((Component)refChild);
            org.zkoss.zul.Listitem newItem = (org.zkoss.zul.Listitem)newChild;
            int n = jfrom = newItem.getParent() == this ? newItem.getIndex() : -1;
            if (super.insertBefore(newChild, refChild)) {
                int index;
                int[] g;
                int fixFrom;
                int jto = refChild instanceof org.zkoss.zul.Listitem ? ((org.zkoss.zul.Listitem)refChild).getIndex() : -1;
                int n2 = fixFrom = jfrom < 0 || jto >= 0 && jfrom > jto ? jto : jfrom;
                if (fixFrom < 0) {
                    newItem.setIndexDirectly(this._items.size() - 1);
                } else {
                    this.fixGroupIndex(fixFrom, jfrom >= 0 && jto >= 0 ? (jfrom > jto ? jfrom : jto) : -1, !isReorder);
                }
                int newIndex = newItem.getIndex();
                if (newItem.isSelected()) {
                    if (this._jsel < 0) {
                        this._jsel = newIndex;
                        if (!this.inSelectMold()) {
                            this.smartUpdate("selectedItem", this.getSelUuid());
                        }
                        this._selItems.add(newItem);
                    } else if (this._multiple) {
                        if (this._jsel > newIndex) {
                            this._jsel = newIndex;
                            if (!this.inSelectMold()) {
                                this.smartUpdate("selectedItem", this.getSelUuid());
                            }
                        }
                        this._selItems.add(newItem);
                    } else {
                        newItem.setSelectedDirectly(false);
                    }
                } else {
                    int oldjsel = this._jsel;
                    if (jfrom < 0) {
                        if (this._jsel >= newIndex) {
                            ++this._jsel;
                        }
                    } else if (this._jsel >= 0) {
                        if (jfrom > this._jsel) {
                            if (jto >= 0 && jto <= this._jsel) {
                                ++this._jsel;
                            }
                        } else if (jto < 0 || jto > this._jsel) {
                            --this._jsel;
                        }
                    }
                    if (oldjsel != this._jsel && !this.inSelectMold()) {
                        this.smartUpdate("selectedItem", this.getSelUuid());
                    }
                }
                if (newChild instanceof Listgroup) {
                    Listgroup lg = (Listgroup)newChild;
                    if (this._groupsInfo.isEmpty()) {
                        this._groupsInfo.add(new int[]{lg.getIndex(), this.getItemCount() - lg.getIndex(), -1});
                    } else {
                        int idx = 0;
                        int[] prev = null;
                        int[] next = null;
                        Iterator it = this._groupsInfo.iterator();
                        while (it.hasNext()) {
                            int[] g3 = (int[])it.next();
                            if (g3[0] <= lg.getIndex()) {
                                prev = g3;
                                ++idx;
                                continue;
                            }
                            next = g3;
                            break;
                        }
                        if (prev != null) {
                            int index2 = lg.getIndex();
                            int leng = index2 - prev[0];
                            int size = prev[1] - leng + 1;
                            prev[1] = leng;
                            this._groupsInfo.add(idx, new int[]{index2, size, size > 1 && prev[2] > index2 ? prev[2] : -1});
                            if (size > 1 && prev[2] > index2) {
                                prev[2] = -1;
                            }
                        } else if (next != null) {
                            this._groupsInfo.add(idx, new int[]{lg.getIndex(), next[0] - lg.getIndex(), -1});
                        }
                    }
                } else if (!this._groupsInfo.isEmpty() && (g = this.getGroupsInfoAt(index = newItem.getIndex())) != null) {
                    g[1] = g[1] + 1;
                    if (g[2] != -1 && (g[2] >= index || newItem instanceof Listgroupfoot)) {
                        g[2] = g[2] + 1;
                    }
                }
                this.afterInsert(newChild);
                return true;
            }
        } else if (newChild instanceof Listhead) {
            boolean added = this._listhead == null;
            if (super.insertBefore(newChild, refChild = this.fixRefChildForHeader((Component)refChild))) {
                this._listhead = (Listhead)newChild;
                if (added) {
                    ++this._hdcnt;
                }
                return true;
            }
        } else if (newChild instanceof Auxhead) {
            boolean added = newChild.getParent() != this;
            if (super.insertBefore(newChild, refChild = this.fixRefChildForHeader((Component)refChild))) {
                if (added) {
                    ++this._hdcnt;
                }
                return true;
            }
        } else if (newChild instanceof Frozen) {
            refChild = this._paging;
            if (super.insertBefore(newChild, refChild)) {
                this.invalidate();
                this._frozen = (Frozen)newChild;
                return true;
            }
        } else if (newChild instanceof org.zkoss.zul.Listfoot) {
            refChild = this._frozen != null ? this._frozen : this._paging;
            if (super.insertBefore(newChild, refChild)) {
                this.invalidate();
                this._listfoot = (org.zkoss.zul.Listfoot)newChild;
                return true;
            }
        } else if (newChild instanceof org.zkoss.zul.Paging) {
            refChild = null;
            if (super.insertBefore(newChild, refChild)) {
                this.invalidate();
                this._paging = (org.zkoss.zul.Paging)newChild;
                this._pgi = this._paging;
                return true;
            }
        } else {
            return super.insertBefore(newChild, refChild);
        }
        return false;
    }

    private Component fixRefChildForHeader(Component refChild) {
        if (refChild != null && refChild.getParent() != this) {
            refChild = null;
        }
        if (refChild == null || refChild != this._listhead && !(refChild instanceof Auxhead)) {
            refChild = this.getChildren().size() > this._hdcnt ? (Component)this.getChildren().get(this._hdcnt) : null;
        }
        refChild = this.fixRefChildBeforeFoot(refChild);
        return refChild;
    }

    private Component fixRefChildBeforeFoot(Component refChild) {
        if (refChild == null) {
            refChild = this._listfoot != null ? this._listfoot : (this._frozen != null ? this._frozen : this._paging);
        } else if (refChild == this._paging) {
            if (this._listfoot != null) {
                refChild = this._listfoot;
            } else if (this._frozen != null) {
                refChild = this._frozen;
            }
        }
        return refChild;
    }

    public boolean removeChild(Component child) {
        if (this._paging == child && this._pgi == child && this.inPagingMold()) {
            throw new IllegalStateException("The paging component cannot be removed manually. It is removed automatically when changing the mold");
        }
        if (child instanceof org.zkoss.zul.Listitem && child.getParent() == this) {
            this.beforeRemove(child);
        }
        if (!super.removeChild(child)) {
            return false;
        }
        if (this._listhead == child) {
            this._listhead = null;
            --this._hdcnt;
        } else if (this._listfoot == child) {
            this._listfoot = null;
        } else if (this._frozen == child) {
            this._frozen = null;
        } else {
            if (child instanceof org.zkoss.zul.Listitem) {
                org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)child;
                int index = item.getIndex();
                item.setIndexDirectly(-1);
                if (item.isSelected()) {
                    this._selItems.remove(item);
                    if (this._jsel == index) {
                        this.fixSelectedIndex(index);
                        if (!this.inSelectMold()) {
                            this.smartUpdate("selectedItem", this.getSelUuid());
                        }
                    }
                } else if (this._jsel >= index) {
                    --this._jsel;
                    if (!this.inSelectMold()) {
                        this.smartUpdate("selectedItem", this.getSelUuid());
                    }
                }
                if (child instanceof Listgroup) {
                    int[] prev = null;
                    int[] remove = null;
                    Iterator it = this._groupsInfo.iterator();
                    while (it.hasNext()) {
                        int[] g = (int[])it.next();
                        if (g[0] == index) {
                            remove = g;
                            break;
                        }
                        prev = g;
                    }
                    if (prev != null && remove != null) {
                        prev[1] = prev[1] + (remove[1] - true);
                    }
                    this.fixGroupIndex(index, -1, false);
                    if (remove != null) {
                        this._groupsInfo.remove(remove);
                        int idx = remove[2];
                        if (idx != -1) {
                            this.removeChild((Component)this.getChildren().get(idx - 1));
                        }
                    }
                } else if (!this._groupsInfo.isEmpty()) {
                    int[] g = this.getGroupsInfoAt(index);
                    if (g != null) {
                        g[1] = g[1] - 1;
                        if (g[2] != -1) {
                            g[2] = g[2] - 1;
                        }
                        this.fixGroupIndex(index, -1, false);
                    } else {
                        this.fixGroupIndex(index, -1, false);
                    }
                    if (child instanceof Listgroupfoot) {
                        int[] g1 = this.getGroupsInfoAt(index);
                        g1[2] = -1;
                    }
                } else {
                    this.fixItemIndices(index, -1);
                }
                return true;
            }
            if (this._paging == child) {
                this._paging = null;
                if (this._pgi == child) {
                    this._pgi = null;
                }
            } else if (child instanceof Auxhead) {
                --this._hdcnt;
            }
        }
        return true;
    }

    protected void afterInsert(Component comp) {
        this.updateVisibleCount((org.zkoss.zul.Listitem)comp, false);
        this.checkInvalidateForMoved((org.zkoss.zul.Listitem)comp, false);
    }

    protected void beforeRemove(Component comp) {
        this.updateVisibleCount((org.zkoss.zul.Listitem)comp, true);
        this.checkInvalidateForMoved((org.zkoss.zul.Listitem)comp, true);
    }

    private void updateVisibleCount(org.zkoss.zul.Listitem item, boolean isRemove) {
        if (item instanceof Listgroup || item.isVisible()) {
            Listgroup g = this.getListgroupAt(item.getIndex());
            if (item instanceof Listgroupfoot || item instanceof Listgroup || g == null || g.isOpen()) {
                this.addVisibleItemCount(isRemove ? -1 : 1);
            }
            if (item instanceof Listgroup) {
                Listgroup group = (Listgroup)item;
                if (item.getPreviousSibling() instanceof org.zkoss.zul.Listitem) {
                    org.zkoss.zul.Listitem preRow = (org.zkoss.zul.Listitem)item.getPreviousSibling();
                    if (preRow == null) {
                        if (!group.isOpen()) {
                            this.addVisibleItemCount(isRemove ? group.getVisibleItemCount() : -group.getVisibleItemCount());
                        }
                    } else {
                        Listgroup preGroup;
                        Listgroup listgroup = preGroup = preRow instanceof Listgroup ? (Listgroup)preRow : this.getListgroupAt(preRow.getIndex());
                        if (preGroup != null) {
                            if (!preGroup.isOpen() && group.isOpen()) {
                                this.addVisibleItemCount(isRemove ? -group.getVisibleItemCount() : group.getVisibleItemCount());
                            } else if (preGroup.isOpen() && !group.isOpen()) {
                                this.addVisibleItemCount(isRemove ? group.getVisibleItemCount() : -group.getVisibleItemCount());
                            }
                        } else if (!group.isOpen()) {
                            this.addVisibleItemCount(isRemove ? group.getVisibleItemCount() : -group.getVisibleItemCount());
                        }
                    }
                } else if (!group.isOpen()) {
                    this.addVisibleItemCount(isRemove ? group.getVisibleItemCount() : -group.getVisibleItemCount());
                }
            }
        }
        if (this.inPagingMold()) {
            this.getPaginal().setTotalSize(this.getVisibleItemCount());
        }
    }

    private void checkInvalidateForMoved(org.zkoss.zul.Listitem child, boolean bRemove) {
        if (this.inPagingMold() && !this.isInvalidated()) {
            int j = child.getIndex();
            int pgsz = this.getPageSize();
            int n = (this.getActivePage() + 1) * pgsz;
            if (j >= n) {
                return;
            }
            int cnt = this.getItems().size();
            int n2 = n - pgsz;
            if (!(j < n2 || cnt > n || bRemove && cnt <= n2 + 1)) {
                return;
            }
            this.invalidate();
        }
    }

    public Iterator getVisibleChildrenIterator() {
        return new VisibleChildrenIterator();
    }

    private void fixSelectedIndex(int j) {
        if (!this._selItems.isEmpty()) {
            ListIterator it = this._items.listIterator(j);
            while (it.hasNext()) {
                org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)it.next();
                if (item.isSelected()) {
                    this._jsel = j;
                    return;
                }
                ++j;
            }
        }
        this._jsel = -1;
    }

    private void fixItemIndices(int j, int to) {
        ListIterator it = this._items.listIterator(j);
        while (it.hasNext() && (to < 0 || j <= to)) {
            ((org.zkoss.zul.Listitem)it.next()).setIndexDirectly(j);
            ++j;
        }
    }

    public ListModel getModel() {
        return this._model;
    }

    public ListModel getListModel() {
        return this._model instanceof GroupsListModel ? null : this._model;
    }

    public GroupsModel getGroupsModel() {
        return this._model instanceof GroupsListModel ? ((GroupsListModel)this._model).getGroupsModel() : null;
    }

    public void setModel(ListModel model) {
        if (model != null) {
            if (this._model != model) {
                if (this._model != null) {
                    this._model.removeListDataListener(this._dataListener);
                    if (this._model instanceof GroupsListModel) {
                        this.getItems().clear();
                    }
                } else {
                    this.getItems().clear();
                    if (!this.inSelectMold()) {
                        this.smartUpdate("model", true);
                    }
                }
                this._model = model;
                this.initDataListener();
            }
            this.syncModel(-1, -1);
            this.postOnInitRender();
        } else if (this._model != null) {
            this._model.removeListDataListener(this._dataListener);
            this._model = null;
            this.getItems().clear();
            if (!this.inSelectMold()) {
                this.smartUpdate("model", false);
            }
        }
    }

    public void setModel(GroupsModel model) {
        this.setModel(model != null ? new GroupsListModel(model) : null);
    }

    public ListitemRenderer getItemRenderer() {
        return this._renderer;
    }

    public void setItemRenderer(ListitemRenderer renderer) {
        if (this._renderer != renderer) {
            this._renderer = renderer;
            if (this._model != null) {
                if (renderer instanceof ListitemRendererExt || this._renderer instanceof ListitemRendererExt) {
                    this.getItems().clear();
                    this.syncModel(-1, -1);
                } else if (this.getAttribute(ATTR_ON_INIT_RENDER_POSTED) == null) {
                    this.unloadAll();
                }
            }
        }
    }

    public void setItemRenderer(String clsnm) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (clsnm != null) {
            this.setItemRenderer((ListitemRenderer)Classes.newInstanceByThread((String)clsnm));
        }
    }

    public int getPreloadSize() {
        String size = (String)this.getAttribute("pre-load-size");
        return size != null ? Integer.parseInt(size) : this._preloadsz;
    }

    public void setPreloadSize(int sz) {
        if (sz < 0) {
            throw new UiException("nonnegative is required: " + sz);
        }
        this._preloadsz = sz;
    }

    private void syncModel(int min, int max) {
        int newsz = this._model.getSize();
        int oldsz = this.getItemCount();
        int newcnt = newsz - oldsz;
        int atg = this._pgi != null ? this.getActivePage() : 0;
        ListitemRenderer renderer = null;
        Component next = null;
        if (oldsz > 0) {
            if (min < 0) {
                min = 0;
            } else if (min > oldsz - 1) {
                min = oldsz - 1;
            }
            if (max < 0) {
                max = oldsz - 1;
            } else if (max > oldsz - 1) {
                max = oldsz - 1;
            }
            if (min > max) {
                int t = min;
                min = max;
                max = t;
            }
            int cnt = max - min + 1;
            if (this._model instanceof GroupsListModel) {
                if ((newcnt += cnt) > 50 && !this.inPagingMold()) {
                    this.invalidate();
                }
                org.zkoss.zul.Listitem comp = this.getItemAtIndex(max);
                next = comp.getNextSibling();
                while (--cnt >= 0) {
                    Component p = comp.getPreviousSibling();
                    comp.detach();
                    comp = p;
                }
            } else {
                int addcnt = 0;
                org.zkoss.zul.Listitem item = this.getItemAtIndex(min);
                while (--cnt >= 0) {
                    next = item.getNextSibling();
                    if (cnt < -newcnt) {
                        item.detach();
                    } else if (item.isLoaded()) {
                        if (renderer == null) {
                            renderer = this.getRealRenderer();
                        }
                        item.detach();
                        this.insertBefore((Component)this.newUnloadedItem(renderer, min++), next);
                        ++addcnt;
                    }
                    item = next;
                }
                if (!(addcnt <= 50 && addcnt + newcnt <= 50 || this.inPagingMold())) {
                    this.invalidate();
                }
            }
        } else {
            min = 0;
        }
        while (--newcnt >= 0) {
            if (renderer == null) {
                renderer = this.getRealRenderer();
            }
            this.insertBefore((Component)this.newUnloadedItem(renderer, min), next);
            ++min;
        }
        if (this._pgi != null) {
            if (atg >= this._pgi.getPageCount()) {
                atg = this._pgi.getPageCount() - 1;
            }
            this._pgi.setActivePage(atg);
        }
    }

    private void unloadAll() {
        int cnt = this.getItemCount();
        if (cnt <= 0) {
            return;
        }
        ListitemRenderer renderer = null;
        org.zkoss.zul.Listitem comp = this.getItemAtIndex(cnt - 1);
        while (--cnt >= 0) {
            Component prev = comp.getPreviousSibling();
            if (comp.isLoaded()) {
                if (renderer == null) {
                    renderer = this.getRealRenderer();
                }
                Component next = comp.getNextSibling();
                comp.detach();
                this.insertBefore((Component)this.newUnloadedItem(renderer, cnt), next);
            }
            comp = prev;
        }
    }

    private final org.zkoss.zul.Listitem newUnloadedItem(ListitemRenderer renderer, int index) {
        org.zkoss.zul.Listitem item = null;
        if (this._model instanceof GroupsListModel) {
            GroupsListModel model = (GroupsListModel)this._model;
            GroupDataInfo info = model.getDataInfo(index);
            switch (info.type) {
                case 0: {
                    item = this.newListgroup(renderer);
                    break;
                }
                case 1: {
                    item = this.newListgroupfoot(renderer);
                    break;
                }
                default: {
                    item = this.newListitem(renderer);
                    break;
                }
            }
        } else {
            item = this.newListitem(renderer);
        }
        item.setLoaded(false);
        this.newUnloadedCell(renderer, item);
        return item;
    }

    private org.zkoss.zul.Listitem newListitem(ListitemRenderer renderer) {
        org.zkoss.zul.Listitem item = null;
        if (renderer instanceof ListitemRendererExt) {
            item = ((ListitemRendererExt)((Object)renderer)).newListitem(this);
        }
        if (item == null) {
            item = new org.zkoss.zul.Listitem();
            item.applyProperties();
        }
        return item;
    }

    private Listgroup newListgroup(ListitemRenderer renderer) {
        Listgroup group = null;
        if (renderer instanceof ListgroupRendererExt) {
            group = ((ListgroupRendererExt)((Object)renderer)).newListgroup(this);
        }
        if (group == null) {
            group = new Listgroup();
            group.applyProperties();
        }
        return group;
    }

    private Listgroupfoot newListgroupfoot(ListitemRenderer renderer) {
        Listgroupfoot groupfoot = null;
        if (renderer instanceof ListgroupRendererExt) {
            groupfoot = ((ListgroupRendererExt)((Object)renderer)).newListgroupfoot(this);
        }
        if (groupfoot == null) {
            groupfoot = new Listgroupfoot();
            groupfoot.applyProperties();
        }
        return groupfoot;
    }

    private Listcell newUnloadedCell(ListitemRenderer renderer, org.zkoss.zul.Listitem item) {
        Listcell cell = null;
        if (renderer instanceof ListitemRendererExt) {
            cell = ((ListitemRendererExt)((Object)renderer)).newListcell(item);
        }
        if (cell == null) {
            cell = new Listcell();
            cell.applyProperties();
        }
        cell.setParent((Component)item);
        return cell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInitRender() {
        this.removeAttribute(ATTR_ON_INIT_RENDER_POSTED);
        Renderer renderer = new Renderer();
        try {
            int ofs;
            int pgsz;
            if (this.inPagingMold()) {
                int cnt;
                pgsz = this._pgi.getPageSize();
                ofs = this._pgi.getActivePage() * pgsz;
                if (ofs >= (cnt = this.getItemCount()) && (ofs = cnt - pgsz) < 0) {
                    ofs = 0;
                }
            } else {
                pgsz = this.inSelectMold() ? this.getItemCount() : (this._rows > 0 ? this._rows + 5 : 20);
                ofs = 0;
            }
            ListIterator it = this.getItems().listIterator(ofs);
            for (int j = 0; j < pgsz && it.hasNext(); ++j) {
                renderer.render((org.zkoss.zul.Listitem)it.next());
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    private void postOnInitRender() {
        if (this.getAttribute(ATTR_ON_INIT_RENDER_POSTED) == null) {
            this.setAttribute(ATTR_ON_INIT_RENDER_POSTED, Boolean.TRUE);
            Events.postEvent((String)"onInitRender", (Component)this, null);
        }
    }

    private void onListDataChange(ListDataEvent event) {
        int newsz = this._model.getSize();
        int oldsz = this.getItemCount();
        int min = event.getIndex0();
        int max = event.getIndex1();
        switch (event.getType()) {
            case 1: {
                org.zkoss.zul.Listitem next;
                int cnt = newsz - oldsz;
                if (cnt <= 0) {
                    throw new UiException("Adding causes a smaller list?");
                }
                if (cnt > 50 && !this.inPagingMold()) {
                    this.invalidate();
                }
                if (min < 0) {
                    min = max < 0 ? 0 : max - cnt + 1;
                }
                if (min > oldsz) {
                    min = oldsz;
                }
                ListitemRenderer renderer = null;
                org.zkoss.zul.Listitem listitem = next = min < oldsz ? this.getItemAtIndex(min) : null;
                while (--cnt >= 0) {
                    if (renderer == null) {
                        renderer = this.getRealRenderer();
                    }
                    this.insertBefore((Component)this.newUnloadedItem(renderer, min++), (Component)next);
                }
                break;
            }
            case 2: {
                int cnt = oldsz - newsz;
                if (cnt <= 0) {
                    throw new UiException("Removal causes a larger list?");
                }
                if (min >= 0) {
                    max = min + cnt - 1;
                } else if (max < 0) {
                    max = cnt - 1;
                }
                if (max > oldsz - 1) {
                    max = oldsz - 1;
                }
                org.zkoss.zul.Listitem comp = this.getItemAtIndex(max);
                while (--cnt >= 0) {
                    Component p = comp.getPreviousSibling();
                    comp.detach();
                    comp = p;
                }
                break;
            }
            default: {
                this.syncModel(min, max);
            }
        }
        this.postOnInitRender();
    }

    private static final ListitemRenderer getDefaultItemRenderer() {
        return _defRend;
    }

    private ListitemRenderer getRealRenderer() {
        return this._renderer != null ? this._renderer : Listbox.getDefaultItemRenderer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.zkoss.zul.Listitem renderItem(org.zkoss.zul.Listitem li) {
        if (this._model != null && !li.isLoaded()) {
            Renderer renderer = new Renderer();
            try {
                renderer.render(li);
            }
            catch (Throwable ex) {
                renderer.doCatch(ex);
            }
            finally {
                renderer.doFinally();
            }
        }
        return li;
    }

    public Listitem renderItemApi(Listitem itemApi) {
        org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)itemApi;
        return this.renderItem(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderAll() {
        if (this._model == null) {
            return;
        }
        Renderer renderer = new Renderer();
        try {
            Iterator it = this.getItems().iterator();
            while (it.hasNext()) {
                renderer.render((org.zkoss.zul.Listitem)it.next());
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderItems(Set items) {
        if (this._model == null) {
            return;
        }
        if (items.isEmpty()) {
            return;
        }
        Renderer renderer = new Renderer();
        try {
            Iterator it = items.iterator();
            while (it.hasNext()) {
                renderer.render((org.zkoss.zul.Listitem)it.next());
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
    }

    public void setMold(String mold) {
        String old = this.getMold();
        if (!Objects.equals((Object)old, (Object)mold)) {
            super.setMold(mold);
            if ("paging".equals(old)) {
                if (this._paging != null) {
                    this.removePagingListener(this._paging);
                    this._paging.detach();
                } else if (this._pgi != null) {
                    this.removePagingListener(this._pgi);
                }
                this.invalidate();
            } else if (this.inPagingMold()) {
                if (this._pgi != null) {
                    this.addPagingListener(this._pgi);
                } else {
                    this.newInternalPaging();
                }
                this.invalidate();
            }
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-listbox" : this._zclass;
    }

    public Object clone() {
        Listbox clone = (Listbox)super.clone();
        clone.init();
        clone.afterUnmarshal();
        if (clone._model != null) {
            clone._dataListener = null;
            clone.initDataListener();
        }
        return clone;
    }

    private void afterUnmarshal() {
        int index = 0;
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (child instanceof org.zkoss.zul.Listitem) {
                org.zkoss.zul.Listitem li = (org.zkoss.zul.Listitem)child;
                li.setIndexDirectly(index++);
                if (!li.isSelected()) continue;
                this._selItems.add(li);
                continue;
            }
            if (child instanceof Listhead) {
                this._listhead = (Listhead)child;
                continue;
            }
            if (child instanceof org.zkoss.zul.Listfoot) {
                this._listfoot = (org.zkoss.zul.Listfoot)child;
                continue;
            }
            if (child instanceof Frozen) {
                this._frozen = (Frozen)child;
                continue;
            }
            if (!(child instanceof org.zkoss.zul.Paging)) continue;
            this._paging = (org.zkoss.zul.Paging)child;
            this._pgi = this._paging;
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.init();
        this.afterUnmarshal();
        if (this._model != null) {
            this.initDataListener();
        }
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        if (this._rows > 0) {
            renderer.render("rows", this.getRows());
        }
        if (this.inSelectMold()) {
            this.render(renderer, "name", this._name);
            this.render(renderer, "multiple", this.isMultiple());
            this.render(renderer, "disabled", this.isDisabled());
            if (this._tabindex >= 0) {
                renderer.render("tabindex", this.getTabindex());
            }
            if (this._maxlength > 0) {
                renderer.render("maxlength", this.getMaxlength());
            }
        } else {
            this.render(renderer, "oddRowSclass", this._scOddRow);
            if (this.isSizedByContent()) {
                renderer.render("sizedByContent", true);
            }
            this.render(renderer, "vflex", this._vflex);
            this.render(renderer, "checkmark", this.isCheckmark());
            this.render(renderer, "multiple", this.isMultiple());
            if (this._model != null) {
                this.render(renderer, "model", true);
            }
            if (!"bottom".equals(this._pagingPosition)) {
                this.render(renderer, "pagingPosition", this._pagingPosition);
            }
            if (!"100%".equals(this._innerWidth)) {
                this.render(renderer, "innerWidth", this._innerWidth);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onSelect")) {
            SelectEvent evt = SelectEvent.getSelectEvent((AuRequest)request);
            Set selItems = evt.getSelectedItems();
            this._noSmartUpdate = true;
            try {
                if (AuRequests.getBoolean((Map)request.getData(), (String)"clearFirst")) {
                    this.clearSelection();
                }
                boolean paging = this.inPagingMold();
                if (!this._multiple || !paging && (selItems == null || selItems.size() <= 1)) {
                    org.zkoss.zul.Listitem item = selItems != null && selItems.size() > 0 ? (org.zkoss.zul.Listitem)selItems.iterator().next() : null;
                    this.selectItem(item);
                } else {
                    int to;
                    int from;
                    if (paging) {
                        Paginal pgi = this.getPaginal();
                        int pgsz = pgi.getPageSize();
                        from = pgi.getActivePage() * pgsz;
                        to = from + pgsz;
                    } else {
                        to = 0;
                        from = 0;
                    }
                    int j = 0;
                    Iterator it = this._items.iterator();
                    while (it.hasNext()) {
                        org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)it.next();
                        if (selItems.contains(item)) {
                            this.addItemToSelection(item);
                        } else if (!paging) {
                            this.removeItemFromSelection(item);
                        } else {
                            int index = item.getIndex();
                            if (index >= from && index < to) {
                                this.removeItemFromSelection(item);
                            }
                        }
                        ++j;
                    }
                }
            }
            finally {
                this._noSmartUpdate = false;
            }
            Events.postEvent((Event)evt);
        } else if (cmd.equals("onInnerWidth")) {
            String width = AuRequests.getInnerWidth((AuRequest)request);
            this._innerWidth = width == null ? "100%" : width;
        } else if (cmd.equals("onRender")) {
            Set items = AuRequests.convertToItems((Desktop)request.getDesktop(), (List)((List)request.getData().get("items")));
            int cnt = items.size();
            if (cnt == 0) {
                return;
            }
            if ((cnt = 20 - cnt) > 0 && this._preloadsz > 0) {
                org.zkoss.zul.Listitem li;
                if (cnt > this._preloadsz) {
                    cnt = this._preloadsz;
                }
                LinkedList<org.zkoss.zul.Listitem> toload = new LinkedList<org.zkoss.zul.Listitem>();
                Iterator it = this._items.iterator();
                while (it.hasNext() && !items.contains(li = (org.zkoss.zul.Listitem)it.next())) {
                    if (li.isLoaded()) continue;
                    toload.add(0, li);
                }
                if (!toload.isEmpty()) {
                    int bfcnt = cnt / 3;
                    Iterator e = toload.iterator();
                    while (bfcnt > 0 && e.hasNext()) {
                        items.add(e.next());
                        --bfcnt;
                        --cnt;
                    }
                }
                while (cnt > 0 && it.hasNext()) {
                    li = (org.zkoss.zul.Listitem)it.next();
                    if (li.isLoaded() || !items.add(li)) continue;
                    --cnt;
                }
            }
            this.renderItems(items);
        } else {
            super.service(request, everError);
        }
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    static {
        $assertionsDisabled = !Listbox.class.desiredAssertionStatus();
        log = Log.lookup((Class)Listbox.class);
        Listbox.addClientEvent((Class)Listbox.class, (String)"onRender", (int)8195);
        Listbox.addClientEvent((Class)Listbox.class, (String)"onInnerWidth", (int)8193);
        Listbox.addClientEvent((Class)Listbox.class, (String)"onSelect", (int)1);
        _defRend = new ListitemRenderer(){

            public void render(org.zkoss.zul.Listitem item, Object data) {
                item.setLabel(Objects.toString((Object)data));
                item.setValue(data);
            }
        };
    }

    private class IterGroups
    implements Iterator {
        private final Iterator _it;
        private int _j;

        private IterGroups() {
            this._it = Listbox.this._groupsInfo.iterator();
        }

        public boolean hasNext() {
            return this._j < Listbox.this.getGroupCount();
        }

        public Object next() {
            org.zkoss.zul.Listitem o = Listbox.this.getItemAtIndex(((int[])this._it.next())[0]);
            ++this._j;
            return o;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class Iter
    implements Iterator {
        private final Iterator _it;
        private int _j;

        private Iter() {
            this._it = Listbox.this.getChildren().iterator();
        }

        public boolean hasNext() {
            return this._j < Listbox.this._hdcnt;
        }

        public Object next() {
            Object o = this._it.next();
            ++this._j;
            return o;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements Cropper {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Listbox.this);
        }

        public boolean isCropper() {
            return Listbox.this.inPagingMold() && Listbox.this.getPageSize() <= Listbox.this.getItemCount();
        }

        public Component getCropOwner() {
            return Listbox.this;
        }

        public Set getAvailableAtClient() {
            if (!this.isCropper()) {
                return null;
            }
            LinkedHashSet<XulElement> avail = new LinkedHashSet<XulElement>(32);
            avail.addAll(Listbox.this._heads);
            if (Listbox.this._listfoot != null) {
                avail.add(Listbox.this._listfoot);
            }
            if (Listbox.this._paging != null) {
                avail.add(Listbox.this._paging);
            }
            if (Listbox.this._frozen != null) {
                avail.add(Listbox.this._frozen);
            }
            Paginal pgi = Listbox.this.getPaginal();
            int pgsz = pgi.getPageSize();
            int ofs = pgi.getActivePage() * pgsz;
            org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)Listbox.this.getItems().get(0);
            while (item != null && pgsz != 0) {
                Listgroup g;
                if (item.isVisible() && --ofs < 0) {
                    --pgsz;
                    avail.add(item);
                }
                if (item instanceof Listgroup && !(g = (Listgroup)item).isOpen()) {
                    int len = g.getItemCount();
                    for (int j = 0; j < len; ++j) {
                        item = (org.zkoss.zul.Listitem)item.getNextSibling();
                    }
                }
                if (item == null || !(item.getNextSibling() instanceof org.zkoss.zul.Listitem)) continue;
                item = (org.zkoss.zul.Listitem)item.getNextSibling();
            }
            return avail;
        }
    }

    private class ItemIter
    implements ListIterator,
    Serializable {
        private ListIterator _it;
        private int _j;
        private boolean _bNxt;

        private ItemIter(int index) {
            this._j = index;
        }

        public void add(Object o) {
            this.prepare();
            this._it.add(o);
            ++this._j;
        }

        public boolean hasNext() {
            return this._j < Listbox.this._items.size();
        }

        public boolean hasPrevious() {
            return this._j > 0;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.prepare();
            Object o = this._it.next();
            ++this._j;
            this._bNxt = true;
            return o;
        }

        public Object previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.prepare();
            Object o = this._it.previous();
            --this._j;
            this._bNxt = false;
            return o;
        }

        public int nextIndex() {
            return this._j;
        }

        public int previousIndex() {
            return this._j - 1;
        }

        public void remove() {
            if (this._it == null) {
                throw new IllegalStateException();
            }
            this._it.remove();
            if (this._bNxt) {
                --this._j;
            }
        }

        public void set(Object o) {
            if (this._it == null) {
                throw new IllegalStateException();
            }
            this._it.set(o);
        }

        private void prepare() {
            if (this._it == null) {
                this._it = Listbox.this.getChildren().listIterator(this._j + Listbox.this._hdcnt);
            }
        }
    }

    class Renderer {
        private final ListitemRenderer _renderer;
        private boolean _rendered;
        private boolean _ctrled;

        Renderer() {
            this._renderer = Listbox.this.getRealRenderer();
        }

        void render(org.zkoss.zul.Listitem item) throws Throwable {
            if (item.isLoaded()) {
                return;
            }
            if (!this._rendered && this._renderer instanceof RendererCtrl) {
                ((RendererCtrl)((Object)this._renderer)).doTry();
                this._ctrled = true;
            }
            Listcell cell = (Listcell)item.getFirstChild();
            if (!(this._renderer instanceof ListitemRendererExt) || (((ListitemRendererExt)((Object)this._renderer)).getControls() & 1) != 0) {
                cell.detach();
            }
            try {
                this._renderer.render(item, Listbox.this._model.getElementAt(item.getIndex()));
            }
            catch (Throwable ex) {
                try {
                    item.setLabel(Exceptions.getMessage((Throwable)ex));
                }
                catch (Throwable t) {
                    log.error(t);
                }
                item.setLoaded(true);
                throw ex;
            }
            finally {
                if (item.getChildren().isEmpty()) {
                    cell.setParent((Component)item);
                }
            }
            item.setLoaded(true);
            this._rendered = true;
        }

        void doCatch(Throwable ex) {
            if (this._ctrled) {
                try {
                    ((RendererCtrl)((Object)this._renderer)).doCatch(ex);
                }
                catch (Throwable t) {
                    throw UiException.Aide.wrap((Throwable)t);
                }
            } else {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }

        void doFinally() {
            if (this._ctrled) {
                ((RendererCtrl)((Object)this._renderer)).doFinally();
            }
        }
    }

    private class VisibleChildrenIterator
    implements Iterator {
        private final ListIterator _it;
        private int _count;
        private boolean _isBeginning;

        private VisibleChildrenIterator() {
            this._it = Listbox.this.getItems().listIterator();
            this._count = 0;
            this._isBeginning = false;
        }

        private VisibleChildrenIterator(boolean isBeginning) {
            this._it = Listbox.this.getItems().listIterator();
            this._count = 0;
            this._isBeginning = false;
            this._isBeginning = isBeginning;
        }

        public boolean hasNext() {
            if (!Listbox.this.inPagingMold()) {
                return this._it.hasNext();
            }
            if (!this._isBeginning && this._count >= Listbox.this.getPaginal().getPageSize()) {
                return false;
            }
            if (this._count == 0 && !this._isBeginning) {
                Paginal pgi = Listbox.this.getPaginal();
                int begin = pgi.getActivePage() * pgi.getPageSize();
                for (int i = 0; i < begin && this._it.hasNext(); ++i) {
                    this.getVisibleRow((org.zkoss.zul.Listitem)this._it.next());
                }
            }
            return this._it.hasNext();
        }

        private org.zkoss.zul.Listitem getVisibleRow(org.zkoss.zul.Listitem item) {
            Listgroup g;
            if (item instanceof Listgroup && !(g = (Listgroup)item).isOpen()) {
                int len = g.getItemCount();
                for (int j = 0; j < len && this._it.hasNext(); ++j) {
                    this._it.next();
                }
            }
            while (!item.isVisible() && this._it.hasNext()) {
                item = (org.zkoss.zul.Listitem)this._it.next();
            }
            return item;
        }

        public Object next() {
            if (!Listbox.this.inPagingMold()) {
                return this._it.next();
            }
            ++this._count;
            org.zkoss.zul.Listitem item = (org.zkoss.zul.Listitem)this._it.next();
            return this._it.hasNext() ? this.getVisibleRow(item) : item;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    protected class Children
    extends AbstractComponent.Children {
        protected Children() {
            super((AbstractComponent)Listbox.this);
        }

        protected void removeRange(int fromIndex, int toIndex) {
            ListIterator it = this.listIterator(toIndex);
            int n = toIndex - fromIndex;
            while (--n >= 0) {
                it.previous();
                it.remove();
            }
        }
    }
}

