/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import org.zkoss.lang.Objects;
import org.zkoss.util.media.Media;
import org.zkoss.util.media.RepeatableMedia;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.URIEvent;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.util.DeferredValue;
import org.zkoss.zul.impl.Utils;

public class Iframe
extends HtmlBasedComponent
implements org.zkoss.zul.api.Iframe {
    private String _align;
    private String _name;
    private String _src;
    private String _scrolling = "auto";
    private Media _media;
    private byte _medver;
    private boolean _autohide;

    public Iframe() {
    }

    public Iframe(String src) {
        this.setSrc(src);
    }

    public void setScrolling(String scrolling) {
        if (scrolling == null) {
            scrolling = "auto";
        }
        if (!scrolling.equals(this._scrolling)) {
            this._scrolling = scrolling;
            this.smartUpdate("scrolling", this._scrolling);
        }
    }

    public String getScrolling() {
        return this._scrolling;
    }

    public String getAlign() {
        return this._align;
    }

    public void setAlign(String align) {
        if (!Objects.equals((Object)this._align, (Object)align)) {
            this._align = align;
            this.smartUpdate("align", this._align);
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (!Objects.equals((Object)this._name, (Object)name)) {
            this._name = name;
            this.smartUpdate("name", this._name);
        }
    }

    public boolean isAutohide() {
        return this._autohide;
    }

    public void setAutohide(boolean autohide) {
        if (this._autohide != autohide) {
            this._autohide = autohide;
            this.smartUpdate("autohide", this._autohide);
        }
    }

    public String getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (this._media != null || !Objects.equals((Object)this._src, (Object)src)) {
            this._src = src;
            this._media = null;
            this.smartUpdate("src", new EncodedSrc());
        }
    }

    protected String getEncodedSrc() {
        Desktop dt = this.getDesktop();
        return this._media != null ? this.getMediaSrc() : (dt != null && this._src != null ? dt.getExecution().encodeURL(this._src) : "");
    }

    public void setContent(Media media) {
        if (this._src != null || media != this._media) {
            this._media = RepeatableMedia.getInstance((Media)media);
            this._src = null;
            if (this._media != null) {
                this._medver = (byte)(this._medver + 1);
            }
            this.smartUpdate("src", new EncodedSrc());
        }
    }

    public Media getContent() {
        return this._media;
    }

    private String getMediaSrc() {
        return Utils.getDynamicMediaURI((AbstractComponent)this, this._medver, this._media.getName(), this._media.getFormat());
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "src", this.getEncodedSrc());
        if (!"auto".equals(this._scrolling)) {
            this.render(renderer, "scrolling", this._scrolling);
        }
        this.render(renderer, "align", this._align);
        this.render(renderer, "name", this._name);
        if (this._autohide) {
            renderer.render("autohide", this._autohide);
        }
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if ("onURIChange".equals(cmd)) {
            Events.postEvent((Event)URIEvent.getURIEvent((AuRequest)request));
        } else {
            super.service(request, everError);
        }
    }

    protected boolean isChildable() {
        return false;
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    static {
        Iframe.addClientEvent((Class)Iframe.class, (String)"onURIChange", (int)8192);
    }

    private class EncodedSrc
    implements DeferredValue {
        private EncodedSrc() {
        }

        public Object getValue() {
            return Iframe.this.getEncodedSrc();
        }
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements DynamicMedia {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Iframe.this);
        }

        public Media getMedia(String pathInfo) {
            return Iframe.this._media;
        }
    }
}

