/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Objects;
import org.zkoss.util.logging.Log;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.event.OpenEvent;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zul.ComboitemRenderer;
import org.zkoss.zul.ComboitemRendererExt;
import org.zkoss.zul.Constraint;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListSubModel;
import org.zkoss.zul.RendererCtrl;
import org.zkoss.zul.SimpleConstraint;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.api.Comboitem;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;

public class Combobox
extends Textbox
implements org.zkoss.zul.api.Combobox {
    private static final Log log = Log.lookup((Class)Combobox.class);
    private boolean _autodrop;
    private boolean _autocomplete = true;
    private boolean _btnVisible = true;
    private transient org.zkoss.zul.Comboitem _selItem;
    private ListModel _model;
    private ComboitemRenderer _renderer;
    private transient ListDataListener _dataListener;
    private transient EventListener _eventListener;
    private static final ComboitemRenderer _defRend;

    public Combobox() {
    }

    public Combobox(String value) throws WrongValueException {
        this();
        this.setValue(value);
    }

    protected String coerceToString(Object value) {
        Constraint constr = this.getConstraint();
        String val = super.coerceToString(value);
        if (val.length() > 0 && constr != null && constr instanceof SimpleConstraint && (((SimpleConstraint)constr).getFlags() & 0x200) != 0) {
            Iterator it = this.getItems().iterator();
            while (it.hasNext()) {
                String label = ((org.zkoss.zul.Comboitem)it.next()).getLabel();
                if (!val.equalsIgnoreCase(label)) continue;
                return label;
            }
        }
        return val;
    }

    public ListModel getModel() {
        return this._model;
    }

    public void setModel(ListModel model) {
        if (model != null) {
            if (this._model != model) {
                if (this._model != null) {
                    this._model.removeListDataListener(this._dataListener);
                } else if (!this.getItems().isEmpty()) {
                    this.getItems().clear();
                }
                this._model = model;
                this.initDataListener();
            }
            this.postOnInitRender(null);
        } else if (this._model != null) {
            this._model.removeListDataListener(this._dataListener);
            if (this._model instanceof ListSubModel) {
                this.removeEventListener("onChanging", this._eventListener);
            }
            this._model = null;
            if (!this.getItems().isEmpty()) {
                this.getItems().clear();
            }
        }
    }

    private void initDataListener() {
        if (this._dataListener == null) {
            this._dataListener = new ListDataListener(){

                public void onChange(ListDataEvent event) {
                    Combobox.this.postOnInitRender(null);
                }
            };
        }
        if (this._eventListener == null) {
            this._eventListener = new EventListener(){

                public void onEvent(Event event) throws Exception {
                    InputEvent ie;
                    if (Combobox.this.getModel() instanceof ListSubModel && !(ie = (InputEvent)event).isChangingBySelectBack()) {
                        Combobox.this.postOnInitRender(ie.getValue());
                    }
                }
            };
        }
        this._model.addListDataListener(this._dataListener);
        if (this._model instanceof ListSubModel) {
            this.addEventListener("onChanging", this._eventListener);
        }
    }

    public ComboitemRenderer getItemRenderer() {
        return this._renderer;
    }

    public void setItemRenderer(ComboitemRenderer renderer) {
        this._renderer = renderer;
    }

    public void setItemRenderer(String clsnm) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        if (clsnm != null) {
            this.setItemRenderer((ComboitemRenderer)Classes.newInstanceByThread((String)clsnm));
        }
    }

    private ListModel syncModel(String index) {
        ComboitemRenderer renderer = null;
        ListModel subset = this._model instanceof ListSubModel ? ((ListSubModel)((Object)this._model)).getSubModel(index, -1) : this._model;
        int newsz = subset.getSize();
        if (!this.getItems().isEmpty()) {
            this.getItems().clear();
        }
        for (int j = 0; j < newsz; ++j) {
            if (renderer == null) {
                renderer = this.getRealRenderer();
            }
            this.newUnloadedItem(renderer).setParent((Component)this);
        }
        return subset;
    }

    private final org.zkoss.zul.Comboitem newUnloadedItem(ComboitemRenderer renderer) {
        org.zkoss.zul.Comboitem item = null;
        if (renderer instanceof ComboitemRendererExt) {
            item = ((ComboitemRendererExt)((Object)renderer)).newComboitem(this);
        }
        if (item == null) {
            item = new org.zkoss.zul.Comboitem();
            item.applyProperties();
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInitRender(Event data) {
        this.removeAttribute("zul.Combobox.ON_INITRENDER");
        Renderer renderer = new Renderer();
        ListModel subset = this.syncModel(data.getData() != null ? (String)data.getData() : this.getRawText());
        try {
            int pgsz = subset.getSize();
            int ofs = 0;
            ListIterator it = this.getItems().listIterator(ofs);
            for (int j = 0; j < pgsz && it.hasNext(); ++j) {
                renderer.render(subset, (org.zkoss.zul.Comboitem)it.next());
            }
        }
        catch (Throwable ex) {
            renderer.doCatch(ex);
        }
        finally {
            renderer.doFinally();
        }
        Events.postEvent((String)"onInitRenderLater", (Component)this, null);
    }

    private void postOnInitRender(String idx) {
        if (this.getAttribute("zul.Combobox.ON_INITRENDER") == null) {
            this.setAttribute("zul.Combobox.ON_INITRENDER", Boolean.TRUE);
            Events.postEvent((String)"onInitRender", (Component)this, (Object)idx);
        }
    }

    private static final ComboitemRenderer getDefaultItemRenderer() {
        return _defRend;
    }

    private ComboitemRenderer getRealRenderer() {
        return this._renderer != null ? this._renderer : Combobox.getDefaultItemRenderer();
    }

    public boolean isAutodrop() {
        return this._autodrop;
    }

    public void setAutodrop(boolean autodrop) {
        if (this._autodrop != autodrop) {
            this._autodrop = autodrop;
            this.smartUpdate("autodrop", autodrop);
        }
    }

    public boolean isAutocomplete() {
        return this._autocomplete;
    }

    public void setAutocomplete(boolean autocomplete) {
        if (this._autocomplete != autocomplete) {
            this._autocomplete = autocomplete;
            this.smartUpdate("autocomplete", autocomplete);
        }
    }

    public void setOpen(boolean open) {
        if (open) {
            this.open();
        } else {
            this.close();
        }
    }

    public void open() {
        this.response("open", (AuResponse)new AuInvoke((Component)this, "setOpen", true));
    }

    public void close() {
        this.response("open", (AuResponse)new AuInvoke((Component)this, "setOpen", false));
    }

    public boolean isButtonVisible() {
        return this._btnVisible;
    }

    public void setButtonVisible(boolean visible) {
        if (this._btnVisible != visible) {
            this._btnVisible = visible;
            this.smartUpdate("buttonVisible", visible);
        }
    }

    public List getItems() {
        return this.getChildren();
    }

    public int getItemCount() {
        return this.getItems().size();
    }

    public org.zkoss.zul.Comboitem getItemAtIndex(int index) {
        return (org.zkoss.zul.Comboitem)this.getItems().get(index);
    }

    public Comboitem getItemAtIndexApi(int index) {
        return this.getItemAtIndex(index);
    }

    public org.zkoss.zul.Comboitem appendItem(String label) {
        org.zkoss.zul.Comboitem item = new org.zkoss.zul.Comboitem(label);
        item.setParent((Component)this);
        return item;
    }

    public Comboitem appendItemApi(String label) {
        return this.appendItem(label);
    }

    public org.zkoss.zul.Comboitem removeItemAt(int index) {
        org.zkoss.zul.Comboitem item = this.getItemAtIndex(index);
        this.removeChild((Component)item);
        return item;
    }

    public Comboitem removeItemAtApi(int index) {
        return this.removeItemAt(index);
    }

    public org.zkoss.zul.Comboitem getSelectedItem() {
        return this._selItem;
    }

    public Comboitem getSelectedItemApi() {
        return this.getSelectedItem();
    }

    public void setSelectedItem(org.zkoss.zul.Comboitem item) {
        this.setSelectedIndex(this.getItems().indexOf(item));
    }

    public void setSelectedItemApi(Comboitem itemApi) {
        org.zkoss.zul.Comboitem item = (org.zkoss.zul.Comboitem)itemApi;
        this.setSelectedItem(item);
    }

    public void setSelectedIndex(int jsel) {
        if (jsel >= this.getItemCount()) {
            throw new UiException("Out of bound: " + jsel + " while size=" + this.getItemCount());
        }
        if (jsel < -1) {
            jsel = -1;
        }
        if (jsel < 0) {
            this._selItem = null;
            this.setValue("");
        } else {
            this._selItem = this.getItemAtIndex(jsel);
            this.setValue(this._selItem.getLabel());
        }
    }

    public int getSelectedIndex() {
        return this._selItem != null ? this.getItems().indexOf(this._selItem) : -1;
    }

    public void setText(String value) throws WrongValueException {
        super.setText(value);
        this.reIndex();
    }

    public void setMultiline(boolean multiline) {
        if (multiline) {
            throw new UnsupportedOperationException("Combobox doesn't support multiline");
        }
    }

    public void setRows(int rows) {
        if (rows != 1) {
            throw new UnsupportedOperationException("Combobox doesn't support multiple rows, " + rows);
        }
    }

    public String getZclass() {
        return this._zclass == null ? "z-combobox" : this._zclass;
    }

    protected void renderProperties(ContentRenderer renderer) throws IOException {
        super.renderProperties(renderer);
        this.render(renderer, "autodrop", this._autodrop);
        if (!this._autocomplete) {
            this.render(renderer, "autocomplete", false);
        }
        if (!this._btnVisible) {
            renderer.render("buttonVisible", false);
        }
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if (cmd.equals("onOpen")) {
            Events.postEvent((Event)OpenEvent.getOpenEvent((AuRequest)request));
        } else if (cmd.equals("onSelect")) {
            SelectEvent evt = SelectEvent.getSelectEvent((AuRequest)request);
            Set selItems = evt.getSelectedItems();
            this._selItem = selItems != null && !selItems.isEmpty() ? (org.zkoss.zul.Comboitem)selItems.iterator().next() : null;
            Events.postEvent((Event)evt);
        } else {
            super.service(request, everError);
        }
    }

    public void beforeChildAdded(Component newChild, Component refChild) {
        if (!(newChild instanceof org.zkoss.zul.Comboitem)) {
            throw new UiException("Unsupported child for Combobox: " + newChild);
        }
        super.beforeChildAdded(newChild, refChild);
    }

    protected boolean isChildable() {
        return true;
    }

    public void onChildAdded(Component child) {
        super.onChildAdded(child);
        this.smartUpdate("repos", true);
    }

    public void onChildRemoved(Component child) {
        super.onChildRemoved(child);
        this.smartUpdate("repos", true);
    }

    final void reIndex() {
        String value = this.getValue();
        if (this._selItem == null || !Objects.equals((Object)value, (Object)this._selItem.getLabel())) {
            this._selItem = null;
            Iterator it = this.getItems().iterator();
            while (it.hasNext()) {
                org.zkoss.zul.Comboitem item = (org.zkoss.zul.Comboitem)it.next();
                if (!Objects.equals((Object)value, (Object)item.getLabel())) continue;
                this._selItem = item;
                break;
            }
        }
    }

    public Object clone() {
        int idx = this.getSelectedIndex();
        Combobox clone = (Combobox)super.clone();
        org.zkoss.zul.Comboitem comboitem = clone._selItem = idx > -1 && clone.getItemCount() > idx ? clone.getItemAtIndex(idx) : null;
        if (clone._model != null) {
            clone._dataListener = null;
            clone._eventListener = null;
            clone.initDataListener();
        }
        return clone;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.getSelectedIndex());
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int idx = s.readInt();
        if (idx > -1 && this.getItemCount() > idx) {
            this._selItem = this.getItemAtIndex(idx);
        }
        if (this._model != null) {
            this.initDataListener();
        }
    }

    static {
        Combobox.addClientEvent((Class)Combobox.class, (String)"onOpen", (int)8192);
        Combobox.addClientEvent((Class)Combobox.class, (String)"onSelect", (int)1);
        _defRend = new ComboitemRenderer(){

            public void render(org.zkoss.zul.Comboitem item, Object data) {
                item.setLabel(Objects.toString((Object)data));
                item.setValue(data);
            }
        };
    }

    private class Renderer
    implements Serializable {
        private final ComboitemRenderer _renderer;
        private boolean _rendered;
        private boolean _ctrled;

        private Renderer() {
            this._renderer = Combobox.this.getRealRenderer();
        }

        private void render(ListModel subset, org.zkoss.zul.Comboitem item) throws Throwable {
            if (!this._rendered && this._renderer instanceof RendererCtrl) {
                ((RendererCtrl)((Object)this._renderer)).doTry();
                this._ctrled = true;
            }
            try {
                this._renderer.render(item, subset.getElementAt(Combobox.this.getItems().indexOf(item)));
            }
            catch (Throwable ex) {
                try {
                    item.setLabel(Exceptions.getMessage((Throwable)ex));
                }
                catch (Throwable t) {
                    log.error(t);
                }
                throw ex;
            }
            this._rendered = true;
        }

        private void doCatch(Throwable ex) {
            if (this._ctrled) {
                try {
                    ((RendererCtrl)((Object)this._renderer)).doCatch(ex);
                }
                catch (Throwable t) {
                    throw UiException.Aide.wrap((Throwable)t);
                }
            } else {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }

        private void doFinally() {
            if (this._ctrled) {
                ((RendererCtrl)((Object)this._renderer)).doFinally();
            }
        }
    }
}

