/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.zkoss.util.ArraysX;
import org.zkoss.zul.AbstractGroupsModel;
import org.zkoss.zul.GroupComparator;
import org.zkoss.zul.GroupsModelExt;

public class ArrayGroupsModel
extends AbstractGroupsModel
implements GroupsModelExt {
    protected Object[] _nativedata;
    protected Comparator _comparator;
    protected Object[][] _data;
    protected Object[] _heads;
    protected Object[] _foots;

    public ArrayGroupsModel(Object[] data, Comparator cmpr) {
        this(data, cmpr, 0);
    }

    public ArrayGroupsModel(Object[] data, Comparator cmpr, int col) {
        if (data == null || cmpr == null) {
            throw new IllegalArgumentException("null parameter");
        }
        this._nativedata = (Object[])ArraysX.duplicate((Object)data);
        this._comparator = cmpr;
        this.group(this._comparator, true, col);
    }

    public Object getChild(int groupIndex, int index) {
        return this._data[groupIndex][index];
    }

    public int getChildCount(int groupIndex) {
        return this._data[groupIndex].length;
    }

    public Object getGroup(int groupIndex) {
        return this._heads == null ? this._data[groupIndex] : this._heads[groupIndex];
    }

    public int getGroupCount() {
        return this._data.length;
    }

    public Object getGroupfoot(int groupIndex) {
        return this._foots == null ? null : this._foots[groupIndex];
    }

    public boolean hasGroupfoot(int groupIndex) {
        return this._foots == null ? false : this._foots[groupIndex] != null;
    }

    public void sort(Comparator cmpr, boolean ascending, int col) {
        this.sortAllGroupData(cmpr, ascending, col);
        this.fireEvent(4, -1, -1, -1);
    }

    public void group(final Comparator cmpr, boolean ascending, int col) {
        Comparator cmprx = cmpr instanceof GroupComparator ? new Comparator(){

            public int compare(Object o1, Object o2) {
                return ((GroupComparator)cmpr).compareGroup(o1, o2);
            }
        } : cmpr;
        this.sortDataInGroupOrder(cmprx, ascending, col);
        this.organizeGroup(cmprx, col);
        if (cmprx != cmpr) {
            this.sortAllGroupData(cmpr, ascending, col);
        }
        this.fireEvent(4, -1, -1, -1);
    }

    private void sortAllGroupData(Comparator cmpr, boolean ascending, int col) {
        for (int i = 0; i < this._data.length; ++i) {
            this.sortGroupData(this._heads[i], this._data[i], cmpr, ascending, col);
        }
    }

    protected void sortGroupData(Object group, Object[] groupdata, Comparator cmpr, boolean ascending, int col) {
        Arrays.sort(groupdata, cmpr);
    }

    protected void organizeGroup(Comparator cmpr, int col) {
        ArrayList group = new ArrayList();
        List gdata = null;
        Object last = null;
        Object curr = null;
        for (int i = 0; i < this._nativedata.length; ++i) {
            curr = this._nativedata[i];
            boolean hitn = false;
            boolean hita = false;
            if (last == null || cmpr.compare(last, curr) != 0) {
                hitn = true;
                gdata = new ArrayList<Object>();
                group.add(gdata);
            }
            gdata.add(curr);
            last = this._nativedata[i];
        }
        List[] gd = new List[group.size()];
        group.toArray(gd);
        this._data = new Object[gd.length][];
        this._foots = new Object[this._data.length];
        this._heads = new Object[this._data.length];
        for (int i = 0; i < gd.length; ++i) {
            gdata = gd[i];
            this._data[i] = new Object[gdata.size()];
            gdata.toArray(this._data[i]);
            this._heads[i] = this.createGroupHead(this._data[i], i, col);
            this._foots[i] = this.createGroupFoot(this._data[i], i, col);
        }
    }

    protected Object createGroupHead(Object[] groupdata, int index, int col) {
        return groupdata[0];
    }

    protected Object createGroupFoot(Object[] groupdata, int index, int col) {
        return null;
    }

    protected void sortDataInGroupOrder(Comparator cmpr, boolean ascending, int colIndex) {
        Arrays.sort(this._nativedata, cmpr);
    }
}

