/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.awt.image.RenderedImage;
import java.io.IOException;
import org.zkoss.image.Images;
import org.zkoss.lang.Objects;
import org.zkoss.util.media.Media;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zk.ui.util.DeferredValue;
import org.zkoss.zul.impl.Utils;
import org.zkoss.zul.impl.XulElement;

public class Image
extends XulElement
implements org.zkoss.zul.api.Image {
    private String _align;
    private String _border;
    private String _hspace;
    private String _vspace;
    private String _src;
    private org.zkoss.image.Image _image;
    private String _hoversrc;
    private org.zkoss.image.Image _hoverimg;
    private byte _imgver;
    private byte _hoverimgver;

    public Image() {
    }

    public Image(String src) {
        this.setSrc(src);
    }

    public String getAlign() {
        return this._align;
    }

    public void setAlign(String align) {
        if (align != null && align.length() == 0) {
            align = null;
        }
        if (!Objects.equals((Object)this._align, (Object)align)) {
            this._align = align;
            this.smartUpdate("align", this._align);
        }
    }

    public String getBorder() {
        return this._border;
    }

    public void setBorder(String border) {
        if (border != null && border.length() == 0) {
            border = null;
        }
        if (!Objects.equals((Object)this._border, (Object)border)) {
            this._border = border;
            this.smartUpdate("border", this._border);
        }
    }

    public String getHspace() {
        return this._hspace;
    }

    public void setHspace(String hspace) {
        if (hspace != null && hspace.length() == 0) {
            hspace = null;
        }
        if (!Objects.equals((Object)this._hspace, (Object)hspace)) {
            this._hspace = hspace;
            this.smartUpdate("hspace", this._hspace);
        }
    }

    public String getVspace() {
        return this._vspace;
    }

    public void setVspace(String vspace) {
        if (vspace != null && vspace.length() == 0) {
            vspace = null;
        }
        if (!Objects.equals((Object)this._vspace, (Object)vspace)) {
            this._vspace = vspace;
            this.smartUpdate("vspace", this._vspace);
        }
    }

    public String getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (this._image != null || !Objects.equals((Object)this._src, (Object)src)) {
            this._src = src;
            this._image = null;
            this.smartUpdateDeferred("src", new EncodedURL());
        }
    }

    public void setContent(org.zkoss.image.Image image) {
        if (this._src != null || image != this._image) {
            this._image = image;
            this._src = null;
            if (this._image != null) {
                this._imgver = (byte)(this._imgver + 1);
            }
            this.smartUpdateDeferred("src", new EncodedURL());
        }
    }

    public void setContent(RenderedImage image) {
        try {
            this.setContent(Images.encode((String)"a.png", (RenderedImage)image));
        }
        catch (IOException ex) {
            throw new UiException((Throwable)ex);
        }
    }

    public org.zkoss.image.Image getContent() {
        return this._image;
    }

    private String getEncodedURL() {
        if (this._image != null) {
            return Utils.getDynamicMediaURI((AbstractComponent)this, this._imgver, "c/" + this._image.getName(), this._image.getFormat());
        }
        Desktop dt = this.getDesktop();
        return dt != null ? dt.getExecution().encodeURL(this._src != null ? this._src : "~./img/spacer.gif") : "";
    }

    private String getEncodedHoverURL() {
        if (this._hoverimg != null) {
            return Utils.getDynamicMediaURI((AbstractComponent)this, this._hoverimgver, "h/" + this._hoverimg.getName(), this._hoverimg.getFormat());
        }
        Desktop dt = this.getDesktop();
        return dt != null && this._hoversrc != null ? dt.getExecution().encodeURL(this._hoversrc) : null;
    }

    public String getHover() {
        return this._hoversrc;
    }

    public void setHover(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (this._hoverimg != null || !Objects.equals((Object)this._hoversrc, (Object)src)) {
            this._hoversrc = src;
            this._hoverimg = null;
            this.smartUpdateDeferred("z.hvig", new EncodedHoverURL());
        }
    }

    public void setHoverContent(org.zkoss.image.Image image) {
        if (this._hoversrc != null || image != this._hoverimg) {
            this._hoverimg = image;
            this._hoversrc = null;
            if (this._hoverimg != null) {
                this._hoverimgver = (byte)(this._hoverimgver + 1);
            }
            this.smartUpdateDeferred("z.hvig", new EncodedHoverURL());
        }
    }

    public void setHoverContent(RenderedImage image) {
        try {
            this.setHoverContent(Images.encode((String)"hover.png", (RenderedImage)image));
        }
        catch (IOException ex) {
            throw new UiException((Throwable)ex);
        }
    }

    public String getOuterAttrs() {
        String attrs = super.getOuterAttrs();
        String clkattrs = this.getAllOnClickAttrs();
        boolean bHover = this._hoversrc != null || this._hoverimg != null;
        boolean bAlphafix = this.alphafix();
        if (!bAlphafix && !bHover) {
            return clkattrs == null ? attrs : attrs + clkattrs;
        }
        StringBuffer sb = new StringBuffer(64).append(attrs);
        if (clkattrs != null) {
            sb.append(clkattrs);
        }
        if (bAlphafix) {
            sb.append(" z.alpha=\"true\"");
        }
        if (bHover) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z.hvig", (String)this.getEncodedHoverURL());
        }
        return sb.toString();
    }

    private boolean alphafix() {
        Desktop dt;
        if ("alphafix".equals(this.getMold()) && (dt = this.getDesktop()) != null) {
            Execution exec = dt.getExecution();
            return exec != null && exec.isExplorer() && !exec.isExplorer7();
        }
        return false;
    }

    public String getInnerAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getInnerAttrs());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"align", (String)this._align);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"border", (String)this._border);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"hspace", (String)this._hspace);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"vspace", (String)this._vspace);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"src", (String)this.getEncodedURL());
        return sb.toString();
    }

    public boolean isChildable() {
        return false;
    }

    public void smartUpdate(String attr, String value) {
        if (this.alphafix()) {
            this.invalidate();
        } else {
            super.smartUpdate(attr, value);
        }
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    private class EncodedHoverURL
    implements DeferredValue {
        private EncodedHoverURL() {
        }

        public String getValue() {
            return Image.this.getEncodedHoverURL();
        }
    }

    private class EncodedURL
    implements DeferredValue {
        private EncodedURL() {
        }

        public String getValue() {
            return Image.this.getEncodedURL();
        }
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements DynamicMedia {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Image.this);
        }

        public Media getMedia(String pathInfo) {
            int k;
            int j;
            if (pathInfo != null && (j = pathInfo.indexOf(47, 1)) >= 0 && (k = pathInfo.indexOf(47, ++j)) == j + 1 && pathInfo.charAt(j) == 'h') {
                return Image.this._hoverimg;
            }
            return Image.this._image;
        }
    }
}

