/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.Set;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.ext.client.Selectable;
import org.zkoss.zul.Tab;
import org.zkoss.zul.Tabpanel;
import org.zkoss.zul.Tabpanels;
import org.zkoss.zul.Tabs;
import org.zkoss.zul.impl.XulElement;

public class Tabbox
extends XulElement {
    private transient Tabs _tabs;
    private transient Tabpanels _tabpanels;
    private transient Tab _seltab;
    private String _panelSpacing;
    private String _orient = "horizontal";

    public Tabs getTabs() {
        return this._tabs;
    }

    public Tabpanels getTabpanels() {
        return this._tabpanels;
    }

    public String getPanelSpacing() {
        return this._panelSpacing;
    }

    public void setPanelSpacing(String panelSpacing) {
        if (panelSpacing != null && panelSpacing.length() == 0) {
            panelSpacing = null;
        }
        if (!Objects.equals((Object)this._panelSpacing, (Object)panelSpacing)) {
            this._panelSpacing = panelSpacing;
            this.invalidate();
        }
    }

    public int getSelectedIndex() {
        return this._seltab != null ? this._seltab.getIndex() : -1;
    }

    public void setSelectedIndex(int j) {
        Tabs tabs = this.getTabs();
        if (tabs == null) {
            throw new IllegalStateException("No tab at all");
        }
        this.setSelectedTab((Tab)((Object)tabs.getChildren().get(j)));
    }

    public Tabpanel getSelectedPanel() {
        return this._seltab != null ? this._seltab.getLinkedPanel() : null;
    }

    public void setSelectedPanel(Tabpanel panel) {
        if (panel != null && panel.getTabbox() != this) {
            throw new UiException("Not a child: " + (Object)((Object)panel));
        }
        Tab tab = panel.getLinkedTab();
        if (tab != null) {
            this.setSelectedTab(tab);
        }
    }

    public Tab getSelectedTab() {
        return this._seltab;
    }

    public void setSelectedTab(Tab tab) {
        this.setSelectedTab0(tab, true);
    }

    private void setSelectedTab0(Tab tab, boolean update) {
        if (tab == null) {
            throw new IllegalArgumentException("null tab");
        }
        if (tab.getTabbox() != this) {
            throw new UiException("Not my child: " + (Object)((Object)tab));
        }
        if (tab != this._seltab) {
            if (this._seltab != null) {
                this._seltab.setSelectedDirectly(false);
            }
            this._seltab = tab;
            this._seltab.setSelectedDirectly(true);
            if (update) {
                this.response("sel", (AuResponse)new AuScript((Component)this, "zkTab.selTab('" + this._seltab.getUuid() + "')"));
            }
        }
    }

    public String getOrient() {
        return this._orient;
    }

    public void setOrient(String orient) throws WrongValueException {
        if (!"horizontal".equals(orient) && !"vertical".equals(orient)) {
            throw new WrongValueException(orient);
        }
        Tabbox.checkOrient(this.getMold(), orient);
        if (!Objects.equals((Object)this._orient, (Object)orient)) {
            this._orient = orient;
            this.invalidate();
        }
    }

    private static void checkOrient(String mold, String orient) throws WrongValueException {
        if ("vertical".equals(orient) && !"default".equals(mold)) {
            throw new WrongValueException("vertical can be used with the default mold");
        }
    }

    public void setMold(String mold) {
        Tabbox.checkOrient(mold, this.getOrient());
        super.setMold(mold);
    }

    public void onCreate() {
        if (this._tabs != null) {
            int sz = this._tabs.getChildren().size();
            if (this._tabpanels == null) {
                this.insertBefore((Component)new Tabpanels(), null);
            }
            for (int n = this._tabpanels.getChildren().size(); n < sz; ++n) {
                this._tabpanels.insertBefore((Component)new Tabpanel(), null);
            }
            if (sz > 0 && this._seltab == null) {
                this.setSelectedTab((Tab)((Object)this._tabs.getChildren().get(0)));
            }
        }
    }

    public boolean insertBefore(Component child, Component insertBefore) {
        if (child instanceof Tabs) {
            if (this._tabs != null && this._tabs != child) {
                throw new UiException("Only one tabs is allowed: " + (Object)((Object)this));
            }
            this._tabs = (Tabs)child;
        } else if (child instanceof Tabpanels) {
            if (this._tabpanels != null && this._tabpanels != child) {
                throw new UiException("Only one tabpanels is allowed: " + (Object)((Object)this));
            }
            this._tabpanels = (Tabpanels)child;
        } else {
            throw new UiException("Unsupported child for tabbox: " + child);
        }
        if (super.insertBefore(child, insertBefore)) {
            this.invalidate();
            return true;
        }
        return false;
    }

    public void onChildRemoved(Component child) {
        if (child instanceof Tabs) {
            this._tabs = null;
            this._seltab = null;
        } else if (child instanceof Tabpanels) {
            this._tabpanels = null;
        }
        super.onChildRemoved(child);
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
        this.appendAsapAttr(sb, "onSelect");
        this.appendAsapAttr(sb, "onRightClick");
        return sb.toString();
    }

    public Object clone() {
        Tabbox clone = (Tabbox)((Object)super.clone());
        int cnt = 0;
        if (clone._tabs != null) {
            ++cnt;
        }
        if (clone._tabpanels != null) {
            ++cnt;
        }
        if (cnt > 0) {
            clone.afterUnmarshal(cnt);
        }
        return clone;
    }

    private void afterUnmarshal(int cnt) {
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (child instanceof Tabs) {
                this._tabs = (Tabs)((Object)child);
                Iterator e = this._tabs.getChildren().iterator();
                while (e.hasNext()) {
                    Tab tab = (Tab)((Object)e.next());
                    if (!tab.isSelected()) continue;
                    this._seltab = tab;
                    break;
                }
                if (--cnt != 0) continue;
                break;
            }
            if (!(child instanceof Tabpanels)) continue;
            this._tabpanels = (Tabpanels)((Object)child);
            if (--cnt != 0) continue;
            break;
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.afterUnmarshal(-1);
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements Selectable {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Tabbox.this);
        }

        public void selectItemsByClient(Set selItems) {
            if (selItems == null || selItems.size() != 1) {
                throw new UiException("Exactly one selected tab is required: " + selItems);
            }
            Tabbox.this.setSelectedTab0((Tab)((Object)selItems.iterator().next()), false);
        }
    }
}

