/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import java.util.Date;
import java.util.regex.Pattern;
import org.zkoss.lang.Classes;
import org.zkoss.util.Dates;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.Constraint;
import org.zkoss.zul.mesg.MZul;

public class SimpleConstraint
implements Constraint,
Serializable {
    private static final long serialVersionUID = 20060622L;
    public static final int NO_POSITIVE = 1;
    public static final int NO_NEGATIVE = 2;
    public static final int NO_ZERO = 4;
    public static final int NO_EMPTY = 256;
    public static final int NO_FUTURE = 1;
    public static final int NO_PAST = 2;
    public static final int NO_TODAY = 4;
    private final int _flags;
    private final Pattern _regex;
    private final String _errmsg;

    public SimpleConstraint(int flags) {
        this(flags, null, null);
    }

    public SimpleConstraint(int flags, String errmsg) {
        this(flags, null, errmsg);
    }

    public SimpleConstraint(String regex, String errmsg) {
        this(0, regex, errmsg);
    }

    public SimpleConstraint(int flags, String regex, String errmsg) {
        this._flags = flags;
        this._regex = regex == null || regex.length() == 0 ? null : Pattern.compile(regex);
        this._errmsg = errmsg == null || errmsg.length() == 0 ? null : errmsg;
    }

    public static final SimpleConstraint getInstance(String flags) {
        int iflags = 0;
        String regex = null;
        String errmsg = null;
        int j = 0;
        int k = 0;
        int len = flags.length();
        block4: while (k >= 0) {
            block5: while (j < len) {
                char cc = flags.charAt(j);
                switch (cc) {
                    case '/': {
                        k = ++j;
                        while (true) {
                            if (k >= len) {
                                k = -1;
                                break;
                            }
                            cc = flags.charAt(k);
                            if (cc == '/') break;
                            if (cc == '\\') {
                                ++k;
                            }
                            ++k;
                        }
                        regex = k >= 0 ? flags.substring(j, k) : flags.substring(j);
                        break;
                    }
                    case ':': {
                        errmsg = flags.substring(j + 1).trim();
                        break block4;
                    }
                    default: {
                        String s;
                        if (Character.isWhitespace(cc)) {
                            ++j;
                            continue block5;
                        }
                        k = j;
                        while (true) {
                            if (k >= len) {
                                s = flags.substring(j);
                                k = -1;
                                break;
                            }
                            char cc2 = flags.charAt(k);
                            if (cc2 == ',' || cc2 == ':' || cc2 == ';' || cc2 == '/') {
                                s = flags.substring(j, k);
                                if (cc2 != ':' && cc2 != '/') break;
                                --k;
                                break;
                            }
                            ++k;
                        }
                        s = s.trim().toLowerCase();
                        if (s.equals("no positive")) {
                            iflags |= 1;
                            break;
                        }
                        if (s.equals("no negative")) {
                            iflags |= 2;
                            break;
                        }
                        if (s.equals("no zero")) {
                            iflags |= 4;
                            break;
                        }
                        if (s.equals("no empty")) {
                            iflags |= 0x100;
                            break;
                        }
                        if (s.equals("no future")) {
                            iflags |= 1;
                            break;
                        }
                        if (s.equals("no past")) {
                            iflags |= 2;
                            break;
                        }
                        if (s.equals("no today")) {
                            iflags |= 4;
                            break;
                        }
                        if (s.length() <= 0) break;
                        throw new UiException("Unknown constraint: " + s);
                    }
                }
                j = k + 1;
                continue block4;
            }
            break block4;
        }
        return new SimpleConstraint(iflags, regex, errmsg);
    }

    public void validate(Component comp, Object value) throws WrongValueException {
        if (value == null) {
            if ((this._flags & 0x100) != 0) {
                throw this.wrongValue(comp, MZul.EMPTY_NOT_ALLOWED);
            }
        } else if (value instanceof Number) {
            if ((this._flags & 7) == 0) {
                return;
            }
            int cmp = ((Comparable)value).compareTo(Classes.coerce(value.getClass(), null, (boolean)false));
            if (cmp > 0 ? (this._flags & 1) != 0 : (cmp == 0 ? (this._flags & 4) != 0 : (this._flags & 2) != 0)) {
                throw this.wrongValue(comp, this.getMessageForNumberDenied());
            }
        } else if (value instanceof String) {
            String s = (String)value;
            if ((this._flags & 0x100) != 0 && s.length() == 0) {
                throw this.wrongValue(comp, MZul.EMPTY_NOT_ALLOWED);
            }
            if (this._regex != null && !this._regex.matcher(s != null ? s : "").matches()) {
                throw this.wrongValue(comp, MZul.ILLEGAL_VALUE);
            }
        } else if (value instanceof Date) {
            if ((this._flags & 7) == 0) {
                return;
            }
            Date date = Dates.beginOfDate((Date)((Date)value), null);
            int cmp = date.compareTo(Dates.today());
            if (cmp > 0 ? (this._flags & 1) != 0 : (cmp == 0 ? (this._flags & 4) != 0 : (this._flags & 2) != 0)) {
                throw this.wrongValue(comp, this.getMessageForDateDenied());
            }
        }
    }

    private WrongValueException wrongValue(Component comp, int errcode) {
        return this._errmsg != null ? new WrongValueException(comp, this._errmsg) : new WrongValueException(comp, errcode);
    }

    private int getMessageForNumberDenied() {
        switch (this._flags & 7) {
            case 5: {
                return MZul.NO_POSITIVE_ZERO;
            }
            case 1: {
                return MZul.NO_POSITIVE;
            }
            case 6: {
                return MZul.NO_NEGATIVE_ZERO;
            }
            case 2: {
                return MZul.NO_NEGATIVE;
            }
            case 4: {
                return MZul.NO_ZERO;
            }
            case 7: {
                return MZul.NO_POSITIVE_NEGATIVE_ZERO;
            }
            case 3: {
                return MZul.NO_POSITIVE_NEGATIVE;
            }
        }
        throw new InternalError();
    }

    private int getMessageForDateDenied() {
        switch (this._flags & 7) {
            case 5: {
                return MZul.NO_FUTURE_TODAY;
            }
            case 1: {
                return MZul.NO_FUTURE;
            }
            case 6: {
                return MZul.NO_PAST_TODAY;
            }
            case 2: {
                return MZul.NO_PAST;
            }
            case 4: {
                return MZul.NO_TODAY;
            }
            case 7: {
                return MZul.NO_FUTURE_PAST_TODAY;
            }
            case 3: {
                return MZul.NO_FUTURE_PAST;
            }
        }
        throw new InternalError();
    }

    public String getValidationScript() {
        return (this._flags & 0x100) != 0 ? "zkVld.noEmpty" : null;
    }

    public String getErrorMessage() {
        return this._errmsg;
    }

    public boolean isClientComplete() {
        return (this._flags == 0 || this._flags == 256) && this._regex == null;
    }
}

