/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.util.List;
import org.zkoss.lang.Objects;
import org.zkoss.util.logging.Log;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.impl.XulElement;

public class Listitem
extends XulElement {
    private static final Log log = Log.lookup((Class)Listitem.class);
    private Object _value;
    private int _index = -1;
    private boolean _selected;
    private boolean _disabled;
    private boolean _loaded;

    public Listitem() {
    }

    public Listitem(String label) {
        this.setLabel(label);
    }

    public Listitem(String label, Object value) {
        this.setLabel(label);
        this.setValue(value);
    }

    public Listbox getListbox() {
        return (Listbox)this.getParent();
    }

    private final boolean inSelectMold() {
        Listbox listbox = this.getListbox();
        return listbox != null && listbox.inSelectMold();
    }

    public int getMaxlength() {
        Listbox listbox = this.getListbox();
        return listbox != null ? listbox.getMaxlength() : 0;
    }

    public Object getValue() {
        return this._value;
    }

    public void setValue(Object value) {
        if (!Objects.equals((Object)this._value, (Object)value)) {
            this._value = value;
            Listbox listbox = this.getListbox();
            if (listbox != null) {
                if (listbox.inSelectMold()) {
                    this.smartUpdate("value", Objects.toString((Object)this._value));
                } else if (listbox.getName() != null) {
                    this.smartUpdate("z:value", Objects.toString((Object)this._value));
                }
            }
        }
    }

    public final boolean isDisabled() {
        return this._disabled;
    }

    public void setDisabled(boolean disabled) {
        if (this._disabled != disabled) {
            if (disabled && !this.inSelectMold()) {
                throw new UnsupportedOperationException();
            }
            this._disabled = disabled;
            this.smartUpdate("disabled", this._disabled);
        }
    }

    public boolean isSelected() {
        return this._selected;
    }

    public void setSelected(boolean selected) {
        if (this._selected != selected) {
            Listbox listbox = (Listbox)this.getParent();
            if (listbox != null) {
                listbox.toggleItemSelection(this);
            } else {
                this._selected = selected;
            }
        }
    }

    public String getLabel() {
        List cells = this.getChildren();
        return cells.isEmpty() ? null : ((Listcell)((Object)cells.get(0))).getLabel();
    }

    public void setLabel(String label) {
        List cells = this.getChildren();
        if (cells.isEmpty()) {
            Listcell cell = new Listcell();
            cell.applyProperties();
            cell.setParent((Component)this);
            cell.setLabel(label);
        } else {
            ((Listcell)((Object)cells.get(0))).setLabel(label);
        }
    }

    public String getSrc() {
        List cells = this.getChildren();
        return cells.isEmpty() ? null : ((Listcell)((Object)cells.get(0))).getSrc();
    }

    public void setSrc(String src) {
        List cells = this.getChildren();
        if (cells.isEmpty()) {
            Listcell cell = new Listcell();
            cell.applyProperties();
            cell.setParent((Component)this);
            cell.setSrc(src);
        } else {
            ((Listcell)((Object)cells.get(0))).setSrc(src);
        }
    }

    public String getImage() {
        return this.getSrc();
    }

    public void setImage(String image) {
        this.setSrc(image);
    }

    public final int getIndex() {
        return this._index;
    }

    final void setLoaded(boolean loaded) {
        if (loaded != this._loaded) {
            this._loaded = loaded;
            Listbox listbox = this.getListbox();
            if (listbox != null && listbox.getModel() != null) {
                this.smartUpdate("z:loaded", this._loaded);
            }
        }
    }

    final boolean isLoaded() {
        return this._loaded;
    }

    final void setIndex(int index) {
        this._index = index;
    }

    final void setSelectedDirectly(boolean selected) {
        this._selected = selected;
    }

    public String getSclass() {
        String scls = super.getSclass();
        if (scls == null) {
            scls = "item";
        }
        return this.isSelected() ? scls + "sel" : scls;
    }

    public void setParent(Component parent) {
        if (parent != null && !(parent instanceof Listbox)) {
            throw new UiException("Listitem's parent must be Listbox, not " + parent);
        }
        super.setParent(parent);
    }

    public boolean insertBefore(Component child, Component insertBefore) {
        if (!(child instanceof Listcell)) {
            throw new UiException("Unsupported child for listitem: " + child);
        }
        return super.insertBefore(child, insertBefore);
    }

    public void invalidate() {
        if (this.inSelectMold()) {
            this.getParent().invalidate();
            return;
        }
        super.invalidate();
    }

    public void onChildAdded(Component child) {
        if (this.inSelectMold()) {
            this.invalidate();
        }
        super.onChildAdded(child);
    }

    public void onChildRemoved(Component child) {
        if (this.inSelectMold()) {
            this.invalidate();
        }
        super.onChildRemoved(child);
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
        if (this.inSelectMold()) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"value", (String)Objects.toString((Object)this._value));
            if (this.isDisabled()) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"disabled", (String)"disabled");
            }
            if (this.isSelected()) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"selected", (String)"selected");
            }
        } else {
            String clkattrs;
            Listbox listbox = this.getListbox();
            if (listbox != null) {
                Listitem sel;
                if (listbox.getName() != null) {
                    HTMLs.appendAttribute((StringBuffer)sb, (String)"z:value", (String)Objects.toString((Object)this._value));
                }
                if ((sel = listbox.getSelectedItem()) == this || sel == null && this.getIndex() == 0) {
                    sb.append(" z:focus=\"true\"");
                }
                if (listbox.getModel() != null) {
                    HTMLs.appendAttribute((StringBuffer)sb, (String)"z:loaded", (boolean)this._loaded);
                }
            }
            if (this.isSelected()) {
                HTMLs.appendAttribute((StringBuffer)sb, (String)"z:sel", (String)"true");
            }
            if ((clkattrs = this.getAllOnClickAttrs(false)) != null) {
                sb.append(clkattrs);
            }
        }
        return sb.toString();
    }
}

