/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.util.media.Media;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zul.impl.XulElement;

public class Iframe
extends XulElement {
    private String _align;
    private String _name;
    private String _src;
    private Media _media;
    private int _medver;

    public Iframe() {
    }

    public Iframe(String src) {
        this.setSrc(src);
    }

    public String getAlign() {
        return this._align;
    }

    public void setAlign(String align) {
        if (align != null && align.length() == 0) {
            align = null;
        }
        if (!Objects.equals((Object)this._align, (Object)align)) {
            this._align = align;
            this.smartUpdate("align", this._align);
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!Objects.equals((Object)this._name, (Object)name)) {
            this._name = name;
            this.smartUpdate("name", this._name);
        }
    }

    public String getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (!Objects.equals((Object)this._src, (Object)src)) {
            this._src = src;
            if (this._media == null) {
                this.smartUpdate("src", this.getEncodedSrc());
            }
        }
    }

    private String getEncodedSrc() {
        Desktop dt = this.getDesktop();
        return this._media != null ? this.getMediaSrc() : (dt != null ? dt.getExecution().encodeURL(this._src != null ? this._src : "~./img/spacer.gif") : "");
    }

    public void setContent(Media media) {
        if (media != this._media) {
            this._media = media;
            if (this._media != null) {
                ++this._medver;
            }
            this.smartUpdate("src", this.getEncodedSrc());
        }
    }

    public Media getContent() {
        return this._media;
    }

    private String getMediaSrc() {
        Desktop desktop = this.getDesktop();
        if (desktop == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(64).append('/');
        Strings.encode((StringBuffer)sb, (int)this._medver);
        String name = this._media.getName();
        String format = this._media.getFormat();
        if (name != null || format != null) {
            sb.append('/');
            boolean bExtRequired = true;
            if (name != null && name.length() != 0) {
                sb.append(name);
                bExtRequired = name.lastIndexOf(46) < 0;
            } else {
                sb.append(this.getId());
            }
            if (bExtRequired && format != null) {
                sb.append('.').append(format);
            }
        }
        return desktop.getDynamicMediaURI((Component)this, sb.toString());
    }

    public String getOuterAttrs() {
        StringBuffer sb = new StringBuffer(64).append(super.getOuterAttrs());
        HTMLs.appendAttribute((StringBuffer)sb, (String)"align", (String)this._align);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"name", (String)this._name);
        HTMLs.appendAttribute((StringBuffer)sb, (String)"src", (String)this.getEncodedSrc());
        return sb.toString();
    }

    public boolean isChildable() {
        return false;
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements DynamicMedia {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Iframe.this);
        }

        public Media getMedia(String pathInfo) {
            return Iframe.this._media;
        }
    }
}

