/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.List;
import org.zkoss.lang.Objects;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.ext.render.ChildChangedAware;
import org.zkoss.zul.Columns;
import org.zkoss.zul.Paging;
import org.zkoss.zul.Row;
import org.zkoss.zul.Rows;
import org.zkoss.zul.event.PagingEvent;
import org.zkoss.zul.ext.Paginal;
import org.zkoss.zul.impl.XulElement;

public class Grid
extends XulElement {
    private transient Rows _rows;
    private transient Columns _cols;
    private String _align;
    private transient Paginal _pgi;
    private transient Paging _paging;
    private transient EventListener _pgListener;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Grid() {
        this.setSclass("grid");
    }

    public Rows getRows() {
        return this._rows;
    }

    public Columns getColumns() {
        return this._cols;
    }

    public Component getCell(int row, int col) {
        Rows rows = this.getRows();
        if (rows == null) {
            return null;
        }
        List children = rows.getChildren();
        if (children.size() <= row) {
            return null;
        }
        return (children = ((Row)((Object)children.get(row))).getChildren()).size() <= col ? null : (Component)children.get(col);
    }

    public String getAlign() {
        return this._align;
    }

    public void setAlign(String align) {
        if (!Objects.equals((Object)this._align, (Object)align)) {
            this._align = align;
            this.smartUpdate("align", this._align);
        }
    }

    void initAtClient() {
        this.smartUpdate("z:init", true);
    }

    public Paginal getPaginal() {
        return this._pgi;
    }

    public void setPaginal(Paginal pgi) {
        if (!Objects.equals((Object)pgi, (Object)this._pgi)) {
            Paginal old = this._pgi;
            this._pgi = pgi;
            if (this.inPagingMold()) {
                if (old != null) {
                    this.removePagingListener(old);
                }
                if (this._pgi == null) {
                    if (this._paging != null) {
                        this._pgi = this._paging;
                    } else {
                        this.newInternalPaging();
                    }
                } else if (this._pgi != this._paging) {
                    if (this._paging != null) {
                        this._paging.detach();
                    }
                    this.addPagingListener(this._pgi);
                }
            }
        }
    }

    private void newInternalPaging() {
        if (!$assertionsDisabled && !this.inPagingMold()) {
            throw new AssertionError((Object)"paging mold only");
        }
        if (!($assertionsDisabled || this._paging == null && this._pgi == null)) {
            throw new AssertionError();
        }
        Paging paging = new Paging();
        paging.setAutohide(true);
        paging.setDetailed(true);
        int sz = this._rows != null ? this._rows.getChildren().size() : 0;
        paging.setTotalSize(sz);
        paging.setParent((Component)this);
        this.addPagingListener(this._pgi);
    }

    private void addPagingListener(Paginal pgi) {
        if (this._pgListener == null) {
            this._pgListener = new EventListener(){

                public boolean isAsap() {
                    return true;
                }

                public void onEvent(Event event) {
                    PagingEvent evt = (PagingEvent)event;
                    Events.postEvent((Event)new PagingEvent(evt.getName(), (Component)Grid.this, evt.getPaginal(), evt.getActivePage()));
                }
            };
        }
        pgi.addEventListener("onPaging", this._pgListener);
    }

    private void removePagingListener(Paginal pgi) {
        pgi.removeEventListener("onPaging", this._pgListener);
    }

    public void onPaging() {
        if (this._rows != null) {
            this._rows.invalidate();
        }
    }

    public Paging getPaging() {
        return this._paging;
    }

    public int getPageSize() {
        if (this._pgi == null) {
            throw new IllegalStateException("Available only the paging mold");
        }
        return this._pgi.getPageSize();
    }

    public void setPageSize(int pgsz) {
        if (this._pgi == null) {
            throw new IllegalStateException("Available only the paging mold");
        }
        this._pgi.setPageSize(pgsz);
    }

    boolean inPagingMold() {
        return "paging".equals(this.getMold());
    }

    public void setMold(String mold) {
        String old = this.getMold();
        if (!Objects.equals((Object)old, (Object)mold)) {
            super.setMold(mold);
            if ("paging".equals(old)) {
                if (this._paging != null) {
                    this.removePagingListener(this._paging);
                    this._paging.detach();
                } else if (this._pgi != null) {
                    this.removePagingListener(this._pgi);
                }
            } else if (this.inPagingMold()) {
                if (this._pgi != null) {
                    this.addPagingListener(this._pgi);
                } else {
                    this.newInternalPaging();
                }
            }
        }
    }

    public String getOuterAttrs() {
        String attrs = super.getOuterAttrs();
        return this._align != null ? attrs + " align=\"" + this._align + '\"' : attrs;
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        if (newChild instanceof Rows) {
            if (this._rows != null && this._rows != newChild) {
                throw new UiException("Only one rows child is allowed: " + (Object)((Object)this));
            }
            this._rows = (Rows)newChild;
            if (this._paging != null && refChild == null) {
                refChild = this._paging;
            }
        } else if (newChild instanceof Columns) {
            if (this._cols != null && this._cols != newChild) {
                throw new UiException("Only one columns child is allowed: " + (Object)((Object)this));
            }
            this._cols = (Columns)newChild;
            if (this._paging != null && refChild == null) {
                refChild = this._paging;
            }
        } else if (newChild instanceof Paging) {
            if (this._pgi != null) {
                throw new UiException("External paging cannot coexist with child paging");
            }
            if (this._paging != null && this._paging != newChild) {
                throw new UiException("Only one paging is allowed: " + (Object)((Object)this));
            }
            if (!this.inPagingMold()) {
                throw new UiException("The child paging is allowed only in the paging mold");
            }
            this._paging = (Paging)newChild;
            this._pgi = this._paging;
            refChild = null;
        } else {
            throw new UiException("Unsupported child for grid: " + newChild);
        }
        if (super.insertBefore(newChild, refChild)) {
            this.invalidate();
            return true;
        }
        return false;
    }

    public boolean removeChild(Component child) {
        if (!super.removeChild(child)) {
            return false;
        }
        if (this._rows == child) {
            this._rows = null;
        } else if (this._cols == child) {
            this._cols = null;
        } else if (this._paging == child) {
            this._paging = null;
            if (this._pgi == child) {
                this._pgi = null;
            }
        }
        this.invalidate();
        return true;
    }

    public Object clone() {
        Grid clone = (Grid)((Object)super.clone());
        int cnt = 0;
        if (clone._rows != null) {
            ++cnt;
        }
        if (clone._cols != null) {
            ++cnt;
        }
        if (clone._paging != null) {
            ++cnt;
        }
        if (cnt > 0) {
            clone.afterUnmarshal(cnt);
        }
        return clone;
    }

    private void afterUnmarshal(int cnt) {
        Iterator it = this.getChildren().iterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (child instanceof Rows) {
                this._rows = (Rows)((Object)child);
                if (--cnt != 0) continue;
                break;
            }
            if (child instanceof Columns) {
                this._cols = (Columns)((Object)child);
                if (--cnt != 0) continue;
                break;
            }
            if (!(child instanceof Paging)) continue;
            this._paging = (Paging)child;
            this._pgi = this._paging;
            if (--cnt != 0) continue;
            break;
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.afterUnmarshal(-1);
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    static {
        $assertionsDisabled = !Grid.class.desiredAssertionStatus();
    }

    protected class ExtraCtrl
    extends HtmlBasedComponent.ExtraCtrl
    implements ChildChangedAware {
        protected ExtraCtrl() {
            super((HtmlBasedComponent)Grid.this);
        }

        public boolean isChildChangedAware() {
            return true;
        }
    }
}

