/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.IOException;
import java.io.ObjectInputStream;
import org.zkoss.lang.Objects;
import org.zkoss.xml.HTMLs;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zul.Bandpopup;
import org.zkoss.zul.Textbox;

public class Bandbox
extends Textbox {
    private transient Bandpopup _drop;
    private String _img = "~./zul/img/bandbtn.gif";
    private boolean _autodrop;

    public Bandbox() {
        this.setSclass("bandbox");
    }

    public Bandbox(String value) throws WrongValueException {
        this();
        this.setValue(value);
    }

    public Bandpopup getDropdown() {
        return this._drop;
    }

    public void closeDropdown() {
        this.response("close", (AuResponse)new AuScript((Component)this, "zkCmbox.close('" + this.getUuid() + "!pp',true)"));
    }

    public boolean isAutodrop() {
        return this._autodrop;
    }

    public void setAutodrop(boolean autodrop) {
        if (this._autodrop != autodrop) {
            this._autodrop = autodrop;
            this.smartUpdate("z:adr", autodrop);
        }
    }

    public String getImage() {
        return this._img;
    }

    public void setImage(String img) {
        if (img != null && img.length() == 0) {
            img = "~./zul/img/bandbtn.gif";
        }
        if (!Objects.equals((Object)this._img, (Object)img)) {
            this._img = img;
            this.invalidate();
        }
    }

    public void setMultiline(boolean multiline) {
        if (multiline) {
            throw new UnsupportedOperationException("Bandbox doesn't support multiline");
        }
    }

    public void setRows(int rows) {
        if (rows != 1) {
            throw new UnsupportedOperationException("Bandbox doesn't support multiple rows, " + rows);
        }
    }

    public String getOuterAttrs() {
        String attrs = super.getOuterAttrs();
        boolean adr = this.isAutodrop();
        if (!this.isAsapRequired("onOpen") && !adr) {
            return attrs;
        }
        StringBuffer sb = new StringBuffer(64).append(attrs);
        this.appendAsapAttr(sb, "onOpen");
        if (adr) {
            HTMLs.appendAttribute((StringBuffer)sb, (String)"z:adr", (String)"true");
        }
        return sb.toString();
    }

    public String getInnerAttrs() {
        String attrs = super.getInnerAttrs();
        String style = this.getInnerStyle();
        return style.length() > 0 ? attrs + " style=\"" + style + '\"' : attrs;
    }

    private String getInnerStyle() {
        StringBuffer sb = new StringBuffer(32).append(HTMLs.getTextRelevantStyle((String)this.getRealStyle()));
        HTMLs.appendStyle((StringBuffer)sb, (String)"width", (String)this.getWidth());
        HTMLs.appendStyle((StringBuffer)sb, (String)"height", (String)this.getHeight());
        return sb.toString();
    }

    protected int getRealStyleFlags() {
        return super.getRealStyleFlags() | 1 | 2;
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        if (!(newChild instanceof Bandpopup)) {
            throw new UiException("Unsupported child for Bandbox: " + newChild);
        }
        if (this._drop != null) {
            throw new UiException("At most one bandpopup is allowed, " + this);
        }
        if (super.insertBefore(newChild, refChild)) {
            this.invalidate();
            this._drop = (Bandpopup)newChild;
            return true;
        }
        return false;
    }

    public boolean isChildable() {
        return true;
    }

    public void onChildRemoved(Component child) {
        super.onChildRemoved(child);
        if (child == this._drop) {
            this._drop = null;
        }
    }

    public Object clone() {
        Bandbox clone = (Bandbox)super.clone();
        if (clone._drop != null) {
            clone.afterUnmarshal();
        }
        return clone;
    }

    private void afterUnmarshal() {
        this._drop = (Bandpopup)((Object)this.getChildren().get(0));
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (!this.getChildren().isEmpty()) {
            this.afterUnmarshal();
        }
    }
}

