/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zkex.zul;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.JExcelApiExporter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.JRXlsExporterParameter;
import net.sf.jasperreports.engine.export.JRXmlExporter;
import net.sf.jasperreports.engine.export.oasis.JROdtExporter;
import org.zkoss.lang.Objects;
import org.zkoss.util.Locales;
import org.zkoss.util.logging.Log;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zul.Iframe;
import org.zkoss.zul.impl.Utils;

public class Jasperreport
extends Iframe
implements org.zkoss.zkex.zul.api.Jasperreport {
    private static final Log log = Log.lookup((Class)Jasperreport.class);
    private static final long serialVersionUID = 20080117L;
    private static final String TASK_PDF = "pdf";
    private static final String TASK_XML = "xml";
    private static final String TASK_HTML = "html";
    private static final String TASK_RTF = "rtf";
    private static final String TASK_XLS = "xls";
    private static final String TASK_JXL = "jxl";
    private static final String TASK_CSV = "csv";
    private static final String TASK_ODT = "odt";
    private static final String IMAGE_DIR = "img/";
    private String _src;
    private Map _parameters;
    private JRDataSource _datasource;
    private int _medver;
    private String _type = "pdf";
    private Locale _locale;
    private transient Map _imageMap;
    private transient Media _media;

    public Jasperreport() {
        this.setHeight("100%");
        this.setWidth("100%");
    }

    public Jasperreport(String src) {
        this.setSrc(src);
    }

    public String getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        if (src != null && src.length() == 0) {
            src = null;
        }
        if (!Objects.equals((Object)this._src, (Object)src)) {
            this._src = src;
            this.invalidate();
        }
    }

    public void setContent(Media media) {
        throw new UnsupportedOperationException("readonly");
    }

    protected String getEncodedSrc() {
        if (this._src == null) {
            Desktop dt = this.getDesktop();
            return dt != null ? dt.getExecution().encodeURL("~./img/spacer.gif") : "";
        }
        StringTokenizer st = new StringTokenizer(this._src, ".");
        return Utils.getDynamicMediaURI((AbstractComponent)this, (int)this._medver++, (String)st.nextToken(), (String)(this._type.equals(TASK_JXL) ? TASK_XLS : this._type));
    }

    public Map getParameters() {
        return this._parameters;
    }

    public void setParameters(Map parameters) {
        if (!Objects.equals((Object)this._parameters, (Object)parameters)) {
            this._parameters = parameters;
            this.invalidate();
        }
    }

    public JRDataSource getDatasource() {
        return this._datasource;
    }

    public void setDatasource(JRDataSource dataSource) {
        if (!Objects.equals((Object)this._datasource, (Object)dataSource)) {
            this._datasource = dataSource;
            this.invalidate();
        }
    }

    public String getType() {
        return this._type;
    }

    public void setType(String type) {
        if (type == null) {
            type = TASK_PDF;
        }
        if (!Objects.equals((Object)this._type, (Object)type)) {
            this._type = type;
            this.invalidate();
        }
    }

    public Locale getLocale() {
        return this._locale;
    }

    public void setLocale(Locale locale) {
        if (!Objects.equals((Object)this._locale, (Object)locale)) {
            this._locale = locale;
            this.invalidate();
        }
    }

    public void invalidate() {
        this._media = null;
        super.invalidate();
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    private Media doReport() {
        if (this._media != null) {
            return this._media;
        }
        InputStream is = null;
        try {
            HashMap<String, Locale> params;
            Execution exec = Executions.getCurrent();
            is = exec.getDesktop().getWebApp().getResourceAsStream(exec.toAbsoluteURI(this._src, false));
            if (is == null && (is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this._src)) == null) {
                File fl = new File(this._src);
                if (!fl.exists()) {
                    throw new RuntimeException("resource for " + this._src + " not found.");
                }
                is = new FileInputStream(fl);
            }
            Map exportPara = null;
            if (this._parameters == null) {
                params = new HashMap<String, Locale>();
            } else {
                params = this._parameters;
                exportPara = (Map)params.remove("exportParameter");
            }
            if (this._locale != null) {
                params.put("REPORT_LOCALE", this._locale);
            } else if (!params.containsKey("REPORT_LOCALE")) {
                params.put("REPORT_LOCALE", Locales.getCurrent());
            }
            JasperPrint jasperPrint = JasperFillManager.fillReport((InputStream)is, params, (JRDataSource)(this._datasource != null ? this._datasource : new JREmptyDataSource()));
            if (TASK_PDF.equals(this._type)) {
                ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
                JRPdfExporter exporter = new JRPdfExporter();
                if (exportPara != null) {
                    exporter.setParameters(exportPara);
                }
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)arrayOutputStream);
                exporter.exportReport();
                arrayOutputStream.close();
                this._imageMap = (Map)exporter.getParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP);
                this._media = new AMedia("report.pdf", TASK_PDF, "application/pdf", arrayOutputStream.toByteArray());
                AMedia aMedia = this._media;
                return aMedia;
            }
            if (TASK_XML.equals(this._type)) {
                ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
                JRXmlExporter exporter = new JRXmlExporter();
                if (exportPara != null) {
                    exporter.setParameters(exportPara);
                }
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)arrayOutputStream);
                exporter.exportReport();
                arrayOutputStream.close();
                this._imageMap = (Map)exporter.getParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP);
                this._media = new AMedia("report.xml", TASK_XML, "text/xml", arrayOutputStream.toByteArray());
                AMedia aMedia = this._media;
                return aMedia;
            }
            if (TASK_HTML.equals(this._type)) {
                ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
                JRHtmlExporter exporter = new JRHtmlExporter();
                if (exportPara != null) {
                    exporter.setParameters(exportPara);
                }
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)arrayOutputStream);
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP, new HashMap());
                exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)IMAGE_DIR);
                exporter.exportReport();
                arrayOutputStream.close();
                this._imageMap = (Map)exporter.getParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP);
                this._media = new AMedia("report.html", TASK_HTML, "text/html", arrayOutputStream.toByteArray());
                AMedia aMedia = this._media;
                return aMedia;
            }
            if (TASK_RTF.equals(this._type)) {
                ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
                JRRtfExporter exporter = new JRRtfExporter();
                if (exportPara != null) {
                    exporter.setParameters(exportPara);
                }
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)arrayOutputStream);
                exporter.exportReport();
                arrayOutputStream.close();
                this._imageMap = (Map)exporter.getParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP);
                this._media = new AMedia("report.rtf", TASK_RTF, "application/rtf", arrayOutputStream.toByteArray());
                AMedia aMedia = this._media;
                return aMedia;
            }
            if (TASK_XLS.equals(this._type)) {
                ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
                JRXlsExporter exporter = new JRXlsExporter();
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.TRUE);
                if (exportPara != null) {
                    exporter.setParameters(exportPara);
                }
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)arrayOutputStream);
                exporter.exportReport();
                arrayOutputStream.close();
                this._imageMap = (Map)exporter.getParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP);
                this._media = new AMedia("report.xls", TASK_XLS, "application/vnd.ms-excel", arrayOutputStream.toByteArray());
                AMedia aMedia = this._media;
                return aMedia;
            }
            if (TASK_JXL.equals(this._type)) {
                ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
                JExcelApiExporter exporter = new JExcelApiExporter();
                exporter.setParameter((JRExporterParameter)JRXlsExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)Boolean.TRUE);
                if (exportPara != null) {
                    exporter.setParameters(exportPara);
                }
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)arrayOutputStream);
                exporter.exportReport();
                arrayOutputStream.close();
                this._imageMap = (Map)exporter.getParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP);
                this._media = new AMedia("report.xls", TASK_XLS, "application/vnd.ms-excel", arrayOutputStream.toByteArray());
                AMedia aMedia = this._media;
                return aMedia;
            }
            if (TASK_CSV.equals(this._type)) {
                ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
                JRCsvExporter exporter = new JRCsvExporter();
                if (exportPara != null) {
                    exporter.setParameters(exportPara);
                }
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)arrayOutputStream);
                exporter.exportReport();
                arrayOutputStream.close();
                this._imageMap = (Map)exporter.getParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP);
                this._media = new AMedia("report.csv", TASK_CSV, "text/csv", arrayOutputStream.toByteArray());
                AMedia aMedia = this._media;
                return aMedia;
            }
            if (TASK_ODT.equals(this._type)) {
                ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
                JROdtExporter exporter = new JROdtExporter();
                if (exportPara != null) {
                    exporter.setParameters(exportPara);
                }
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)jasperPrint);
                exporter.setParameter(JRExporterParameter.OUTPUT_STREAM, (Object)arrayOutputStream);
                exporter.exportReport();
                arrayOutputStream.close();
                this._imageMap = (Map)exporter.getParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_MAP);
                this._media = new AMedia("report.odt", TASK_ODT, "application/vnd.oasis.opendocument.text", arrayOutputStream.toByteArray());
                AMedia aMedia = this._media;
                return aMedia;
            }
            try {
                throw new UiException("Type: " + this._type + " is not supported in JasperReports.");
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    log.warningBriefly("Ignored: unable to close", (Throwable)e);
                }
            }
        }
    }

    private AMedia getImage(String imageName) {
        if (this._imageMap == null) {
            log.warning("The image map not ready, " + imageName);
            return null;
        }
        byte[] imageBytes = (byte[])this._imageMap.get(imageName);
        return new AMedia(imageName, "", "image/gif", imageBytes);
    }

    protected class ExtraCtrl
    extends Iframe.ExtraCtrl {
        protected ExtraCtrl() {
            super((Iframe)Jasperreport.this);
        }

        public Media getMedia(String pathInfo) {
            String imageName;
            int indexOfImg = pathInfo.lastIndexOf(Jasperreport.IMAGE_DIR);
            if (indexOfImg >= 0 && (imageName = pathInfo.substring(indexOfImg + Jasperreport.IMAGE_DIR.length())).indexOf(".") < 0) {
                return Jasperreport.this.getImage(imageName);
            }
            return Jasperreport.this.doReport();
        }
    }
}

