/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util.resource;

import org.zkoss.lang.Library;
import org.zkoss.lang.PotentialDeadLockException;
import org.zkoss.lang.SystemException;
import org.zkoss.util.CacheMap;
import org.zkoss.util.WaitLock;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.Loader;

public class ResourceCache
extends CacheMap {
    private static final Log log = Log.lookup(ResourceCache.class);
    protected final Loader _loader;
    private int _checkPeriod;

    public ResourceCache(Loader loader) {
        if (loader == null) {
            throw new NullPointerException();
        }
        this._loader = loader;
        this._checkPeriod = ResourceCache.getInitCheckPeriod();
    }

    public ResourceCache(Loader loader, int initsz) {
        super(initsz);
        if (loader == null) {
            throw new NullPointerException();
        }
        this._loader = loader;
        this._checkPeriod = ResourceCache.getInitCheckPeriod();
    }

    private static int getInitCheckPeriod() {
        int v = Library.getIntProperty("org.zkoss.util.resource.checkPeriod", 5);
        return v > 0 ? v * 1000 : v;
    }

    public Loader getLoader() {
        return this._loader;
    }

    public int getCheckPeriod() {
        return this._checkPeriod;
    }

    public ResourceCache setCheckPeriod(int checkPeriod) {
        this._checkPeriod = checkPeriod;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object src) {
        Object object;
        Info ri;
        WaitLock lock;
        block29: {
            lock = null;
            while (true) {
                ri = null;
                object = this;
                synchronized (object) {
                    Object o = super.get(src);
                    if (o instanceof Info) {
                        ri = (Info)o;
                    } else {
                        if (!(o instanceof WaitLock)) {
                            lock = new WaitLock();
                            super.put(src, lock);
                            break block29;
                        }
                        lock = (WaitLock)o;
                    }
                }
                if (ri != null) {
                    object = ri;
                    synchronized (object) {
                        if (ri.isValid()) {
                            return ri.getResource();
                        }
                    }
                    object = this;
                    synchronized (object) {
                        if (super.get(src) == ri) {
                            super.remove(src);
                        }
                    }
                }
                if (!lock.waitUntilUnlock(300000)) break;
            }
            PotentialDeadLockException ex = new PotentialDeadLockException("Unable to load from " + src + "\nCause: conflict too long.");
            log.warningBriefly(ex);
            throw ex;
        }
        try {
            ri = new Info(src);
            Object resource = ri.getResource();
            Object object2 = this;
            synchronized (object2) {
                if (resource != null) {
                    super.put(src, ri);
                } else {
                    super.remove(src);
                }
            }
            object2 = resource;
            return object2;
        }
        catch (Throwable ex) {
            object = this;
            synchronized (object) {
                super.remove(src);
            }
            throw SystemException.Aide.wrap(ex);
        }
        finally {
            lock.unlock();
        }
    }

    public Object put(Object src, Object val) {
        throw new UnsupportedOperationException("Used only internally");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object src) {
        ResourceCache resourceCache = this;
        synchronized (resourceCache) {
            return super.remove(src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ResourceCache resourceCache = this;
        synchronized (resourceCache) {
            super.clear();
        }
    }

    private class Info {
        private final Object _src;
        private Object _resource;
        private long _lastModified;
        private long _nextCheck;

        public Info(Object src) throws Exception {
            this._src = src;
            this.load();
        }

        public final Object getResource() {
            return this._resource;
        }

        public boolean isValid() {
            boolean valid;
            long now = System.currentTimeMillis();
            if (!ResourceCache.this._loader.shallCheck(this._src, now - this._nextCheck)) {
                return true;
            }
            long lastmod = ResourceCache.this._loader.getLastModified(this._src);
            if (lastmod == -1L) {
                return false;
            }
            boolean bl = valid = lastmod == this._lastModified;
            if (!valid) {
                log.info("Source is changed: " + this._src);
            }
            return valid;
        }

        protected void load() throws Exception {
            this._resource = ResourceCache.this._loader.load(this._src);
            if (this._resource != null) {
                this._lastModified = ResourceCache.this._loader.getLastModified(this._src);
                this._nextCheck = System.currentTimeMillis() + (long)ResourceCache.this._checkPeriod;
            }
        }
    }
}

