/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.io;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.zkoss.io.Repeatable;

class RepeatableFileInputStream
extends InputStream
implements Repeatable {
    private final File _file;
    private InputStream _in;

    RepeatableFileInputStream(File file) {
        this._file = file;
    }

    public int read() throws IOException {
        if (this._in == null) {
            this._in = new BufferedInputStream(new FileInputStream(this._file));
        }
        return this._in.read();
    }

    public void close() throws IOException {
        if (this._in != null) {
            this._in.close();
            this._in = null;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

