/*
 * Decompiled with CFR 0.152.
 */
package org.xidea.el.json;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Date;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xidea.el.impl.ReflectUtil;
import org.xidea.el.json.JSONDecoder;
import org.xidea.el.json.JSONTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JSONTransformer {
    private static Log log = LogFactory.getLog(JSONTransformer.class);
    private static final Pattern W3CDATE = Pattern.compile("^(\\d{4})(?:\\-(\\d{1,2})(?:\\-(\\d{1,2})(?:T(\\d{2})\\:(\\d{2})(?:\\:(\\d{2}(?:\\.\\d+)?))?(Z|[+\\-]\\d{2}\\:?\\d{2})?)?)?)?$");
    private static final Object SIMPLE_NOT_FOUND = new Object();
    static Map<Class<?>, Class<?>> interfaceMap = new HashMap();
    Map<Type, JSONDecoder.TypeTransformer<? extends Object>> objectFactory = new HashMap<Type, JSONDecoder.TypeTransformer<? extends Object>>();
    private ClassLoader loader = JSONTransformer.class.getClassLoader();

    JSONTransformer() {
    }

    public java.util.Date parseW3Date(String source) {
        Matcher m = W3CDATE.matcher(source);
        if (m.find()) {
            Calendar ca = Calendar.getInstance();
            ca.clear();
            String timeZone = m.group(7);
            if (timeZone != null) {
                ca.setTimeZone(TimeZone.getTimeZone("GMT" + timeZone));
            }
            ca.set(1, Integer.parseInt(m.group(1)));
            String month = m.group(2);
            if (month != null) {
                ca.set(2, Integer.parseInt(month) - 1);
                String date = m.group(3);
                if (date != null) {
                    ca.set(5, Integer.parseInt(date));
                    String hour = m.group(4);
                    if (hour != null) {
                        String minutes = m.group(5);
                        ca.set(10, Integer.parseInt(hour));
                        ca.set(12, Integer.parseInt(minutes));
                        String seconds = m.group(6);
                        if (seconds != null) {
                            if (seconds.length() > 2) {
                                float f = Float.parseFloat(seconds);
                                ca.set(13, (int)f);
                                ca.set(14, (int)(f * 1000.0f) % 1000);
                            } else {
                                ca.set(13, Integer.parseInt(seconds));
                            }
                        }
                    }
                }
            }
            return ca.getTime();
        }
        return null;
    }

    public java.util.Date requireW3Date(String source) {
        java.util.Date date = this.parseW3Date(source);
        if (date != null) {
            return date;
        }
        throw new TransformException("\u65e5\u671f\u89e3\u6790\u5931\u8d25", (Type)((Object)java.util.Date.class), source);
    }

    private Object createObject(Map map, Class defaultClass) throws InstantiationException, IllegalAccessException {
        Object result;
        JSONDecoder.TypeTransformer<? extends Object> of;
        String className = (String)map.get("class");
        if (className != null) {
            try {
                defaultClass = this.forName(className);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if ((of = this.objectFactory.get(defaultClass)) != null && of.externalSetup()) {
            return of.create(map);
        }
        if (defaultClass.isInterface()) {
            Class<?> impl = interfaceMap.get(defaultClass);
            if (impl == null) {
                throw new TransformException("\u63a5\u53e3\u627e\u4e0d\u5230\u9ed8\u8ba4\u5b9e\u73b0\u7c7b" + interfaceMap, defaultClass, map);
            }
            defaultClass = impl;
        }
        if ((result = ReflectUtil.newInstance(defaultClass)) != null) {
            return result;
        }
        if (defaultClass != null && defaultClass.isMemberClass() && 0 == (defaultClass.getModifiers() & 8)) {
            throw new TransformException("\u8bf7\u5c3d\u91cf\u907f\u514d\u7528\u975e\u9759\u6001\u7684\u5185\u90e8\u7c7b\u5b58\u50a8\u6570\u636e", defaultClass, map);
        }
        throw new TransformException("JavaBean \u521b\u5efa\u5f02\u5e38", defaultClass, map);
    }

    public JSONDecoder.TypeTransformer<? extends Object> addFactory(JSONDecoder.TypeTransformer<? extends Object> factory) {
        Type type = ReflectUtil.getParameterizedType(factory.getClass(), JSONDecoder.TypeTransformer.class, 0);
        return this.objectFactory.put(type, factory);
    }

    protected Object require(Object value, Type type) throws Exception {
        Class<? extends Object> clazz;
        if (type instanceof Class && ((Class)type).isInstance(value)) {
            return value;
        }
        if (type instanceof Class) {
            clazz = (Class<? extends Object>)type;
            Object result = this.toSimpleValue(value, clazz);
            if (result != SIMPLE_NOT_FOUND) {
                return result;
            }
        } else {
            clazz = ReflectUtil.baseClass(type);
        }
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            return this.createFromList(value, type, clazz);
        }
        this.forName(clazz);
        JSONDecoder.TypeTransformer<? extends Object> of = this.objectFactory.get(type);
        if (of != null && !of.externalSetup()) {
            return of.create(value);
        }
        if (value instanceof Map) {
            return this.createFromMap(value, type, clazz);
        }
        return this.createFallback(value, type, clazz);
    }

    private final Class<?> forName(String name) throws ClassNotFoundException {
        return Class.forName(name, true, this.loader);
    }

    private final void forName(Class<?> type) throws ClassNotFoundException {
        if (!type.isPrimitive()) {
            Class.forName(type.getName(), true, type.getClassLoader());
        }
    }

    public Object transform(Object value, Type type) {
        try {
            return this.require(value, type);
        }
        catch (TransformException e) {
            log.warn((Object)(e.title + ":" + e.type + "=>" + e.value), (Throwable)e);
        }
        catch (Exception e) {
            log.warn((Object)("\u672a\u77e5JSON \u7c7b\u578b\u5f02\u5e38:" + type + "=>" + value), (Throwable)e);
        }
        return null;
    }

    private Object createFromMap(Object value, Type type, Class<?> clazz) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        this.forName(clazz);
        Map map = (Map)value;
        Object result = this.createObject(map, clazz);
        for (Object key : map.keySet()) {
            Type atype = ReflectUtil.getPropertyType(type, key);
            Object item = map.get(key);
            try {
                if (atype != null) {
                    item = this.require(item, atype);
                }
                ReflectUtil.setValue(result, key, item);
            }
            catch (TransformException e) {
                log.warn((Object)(e.title + ":" + e.type + "=>" + e.value), (Throwable)e);
            }
            catch (Exception e) {
                log.warn((Object)("\u672a\u77e5JSON \u7c7b\u578b\u5f02\u5e38:" + type + "#" + key + "=>" + item), (Throwable)e);
            }
        }
        return result;
    }

    private Object createFromList(Object value, Type type, Class<?> clazz) throws ClassNotFoundException {
        if (clazz.isArray()) {
            List list = (List)value;
            Object result = Array.newInstance(clazz.getComponentType(), list.size());
            int len = list.size();
            for (int i = 0; i < len; ++i) {
                Object item = this.transform(list.get(i), clazz.getComponentType());
                Array.set(result, i, item);
            }
            return result;
        }
        if (List.class.isAssignableFrom(clazz) && type instanceof ParameterizedType) {
            this.setupList((List)value, (ParameterizedType)type);
        } else {
            this.forName(clazz);
            JSONDecoder.TypeTransformer<? extends Object> of = this.objectFactory.get(type);
            if (of != null && !of.externalSetup()) {
                return of.create(value);
            }
            if (!clazz.isInstance(value)) {
                throw new TransformException("List\u7c7b\u578b\u8f6c\u6362\u5931\u8d25", clazz, value);
            }
        }
        return value;
    }

    private void setupList(List<Object> list, ParameterizedType ptype) {
        Type listItemClazz = ptype.getActualTypeArguments()[0];
        int c = list.size();
        for (int j = 0; j < c; ++j) {
            Object item = this.transform(list.get(j), ReflectUtil.baseClass(listItemClazz));
            list.set(j, item);
        }
    }

    private Object createFallback(Object value, Type type, Class<?> clazz) throws ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (Enum.class.isAssignableFrom(clazz)) {
            return ReflectUtil.getEnum(value, clazz);
        }
        if (Character.class == clazz) {
            if (value instanceof CharSequence) {
                return Character.valueOf(((CharSequence)value).charAt(0));
            }
            if (value instanceof Number) {
                return Character.valueOf((char)((Number)value).intValue());
            }
            throw new TransformException("Char\u7c7b\u578b\u8f6c\u6362\u5931\u8d25(\u53ea\u652f\u6301CharSequence\u548cNumber \u5230Char\u7684\u8f6c\u6362)", clazz, value);
        }
        Constructor<?> c = null;
        try {
            c = clazz.getConstructor(value.getClass());
        }
        catch (Exception e) {
            throw new TransformException("\u4e0d\u652f\u6301\u6570\u636e\u7c7b\u578b", clazz, value);
        }
        return c.newInstance(value);
    }

    protected Object toSimpleValue(Object value, Class clazz) throws ParseException, ClassNotFoundException {
        boolean isPrimitive = clazz.isPrimitive();
        clazz = ReflectUtil.toWrapper(clazz);
        if (value == null) {
            if (isPrimitive) {
                return this.defaultPrimitive(clazz);
            }
            return null;
        }
        if (String.class == clazz) {
            return value.toString();
        }
        if (value instanceof String) {
            String text = (String)value;
            if (java.util.Date.class == clazz) {
                return this.requireW3Date(text);
            }
            if (Date.class == clazz) {
                return new Date(this.requireW3Date(text).getTime());
            }
            if (clazz == Class.class) {
                return this.forName(text);
            }
            if (Boolean.class == clazz) {
                return Boolean.valueOf(text);
            }
            if (Number.class.isAssignableFrom(clazz)) {
                if (Long.class == clazz) {
                    return Long.parseLong(text);
                }
                return ReflectUtil.toValue(Double.parseDouble(String.valueOf(value)), clazz);
            }
        } else {
            if (Number.class.isAssignableFrom(clazz)) {
                return ReflectUtil.toValue(value instanceof Number ? (Number)((Number)value) : (Number)Double.parseDouble(String.valueOf(value)), clazz);
            }
            if (value instanceof Boolean) {
                if (Boolean.class == clazz) {
                    return value;
                }
            } else if (value instanceof Number) {
                Number n = (Number)value;
                if (java.util.Date.class == clazz) {
                    return new java.util.Date(n.longValue());
                }
                if (Date.class == clazz) {
                    return new Date(n.longValue());
                }
                if (Boolean.class == clazz) {
                    return n.floatValue() != 0.0f;
                }
            }
        }
        return SIMPLE_NOT_FOUND;
    }

    private Object defaultPrimitive(Class<?> clazz) {
        if (clazz == Boolean.class) {
            return false;
        }
        if (clazz == Character.class) {
            return Character.valueOf('\u0000');
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return ReflectUtil.toValue(0, clazz);
        }
        throw new IllegalArgumentException("class is not primitive type:" + clazz);
    }

    public void setClassLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public <T> List<T> decodeList(String value, Type type, boolean strict) {
        try {
            List result = (List)new JSONTokenizer(value, strict).parse();
            if (type != null && type != Object.class) {
                for (int i = result.size() - 1; i >= 0; --i) {
                    result.set(i, this.transform(result.get(i), type));
                }
            }
            return result;
        }
        catch (RuntimeException e) {
            log.warn((Object)("json error:" + value), (Throwable)e);
            throw e;
        }
    }

    public <T> T decode(String value, Type type, boolean strict) {
        try {
            Object result = new JSONTokenizer(value, strict).parse();
            if (type != null && type != Object.class) {
                result = this.transform(result, type);
            }
            return (T)result;
        }
        catch (RuntimeException e) {
            log.warn((Object)("json error:" + value), (Throwable)e);
            throw e;
        }
    }

    static {
        interfaceMap.put(Map.class, HashMap.class);
        interfaceMap.put(List.class, ArrayList.class);
        interfaceMap.put(Collection.class, ArrayList.class);
        interfaceMap.put(Set.class, HashSet.class);
    }

    private static final class TransformException
    extends RuntimeException {
        private static final long serialVersionUID = -7860716983754523610L;
        String title;
        Type type;
        Object value;

        public TransformException(String title, Type type, Object value) {
            this.title = title;
            this.type = type;
            this.value = value;
        }
    }
}

