/*
 * Decompiled with CFR 0.152.
 */
package org.xidea.el.json;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.xidea.el.ExpressionSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONTokenizer {
    protected String value;
    protected int start;
    protected final int end;
    protected boolean strict = false;

    public JSONTokenizer(String source, boolean strict) {
        this.value = source.trim();
        if (this.value.startsWith("\ufeff")) {
            this.value = this.value.substring(1);
        }
        this.end = this.value.length();
        this.strict = strict;
    }

    protected Object parse() {
        this.skipComment();
        char c = this.toLower(this.value.charAt(this.start));
        switch (c) {
            case '\'': {
                if (this.strict) {
                    throw this.buildError("JSON\u6807\u51c6 \u5b57\u7b26\u4e32\u5e94\u8be5\u662f\u53cc\u5f15\u53f7\"...\")");
                }
            }
            case '\"': {
                return this.findString();
            }
            case '[': {
                return this.findList();
            }
            case '{': {
                return this.findMap();
            }
        }
        if (c >= '0' && c <= '9') {
            return this.findNumber();
        }
        if (c == '-') {
            if (this.strict) {
                return this.findNumber();
            }
            int start = this.start;
            this.skipComment();
            c = this.value.charAt(this.start);
            if (c >= '\u0000' || c <= '\t') {
                this.start = start;
                return this.findNumber();
            }
            String key = this.findId();
            if ("Infinity".equals(key)) {
                return Double.NEGATIVE_INFINITY;
            }
            throw this.buildError(key + " is  not a valid number!!");
        }
        String key = this.findId();
        if ("true".equals(key)) {
            return Boolean.TRUE;
        }
        if ("false".equals(key)) {
            return Boolean.FALSE;
        }
        if ("null".equals(key)) {
            return null;
        }
        if (!this.strict) {
            if ("NaN".equals(key)) {
                return Double.NaN;
            }
            if ("Infinit".equals(key)) {
                return Double.POSITIVE_INFINITY;
            }
        }
        throw this.buildError("");
    }

    protected ExpressionSyntaxException buildError(String msg) {
        return new ExpressionSyntaxException("\u8bed\u6cd5\u9519\u8bef:" + msg + "\n" + this.value.substring(Math.max(0, this.start - 2), Math.min(this.start + 10, this.value.length())) + "@" + this.start);
    }

    protected char toLower(char c) {
        if (c >= '\uff01' && c <= '\uff5e') {
            c = (char)(c - 65248);
        }
        return c;
    }

    protected Map<String, Object> findMap() {
        Object valueObject;
        String key;
        char c;
        ++this.start;
        this.skipComment();
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (this.value.charAt(this.start) == '}') {
            ++this.start;
            return result;
        }
        while (true) {
            if ((c = this.value.charAt(this.start)) == '\"') {
                key = this.findString();
            } else {
                if (this.strict) {
                    throw this.buildError("JSON \u6807\u51c6Object Key \u5fc5\u987b\u4e3a\u6807\u51c6JSON \u5b57\u7b26\u4e32,\u5982:{\"key\":\"value\"}");
                }
                if (c == '\'') {
                    key = this.findString();
                } else if (Character.isJavaIdentifierPart(c)) {
                    key = this.findId();
                } else {
                    if (c == '}') {
                        ++this.start;
                        return result;
                    }
                    if (c == ',') {
                        ++this.start;
                        this.skipComment();
                        continue;
                    }
                    throw this.buildError("\u65e0\u6548\u5bf9\u8c61\u8bed\u6cd5");
                }
            }
            this.skipComment();
            c = this.value.charAt(this.start++);
            if (c != ':') {
                throw this.buildError("\u65e0\u6548\u5bf9\u8c61\u8bed\u6cd5");
            }
            valueObject = this.parse();
            this.skipComment();
            c = this.value.charAt(this.start++);
            if (c != ',') break;
            result.put(key, valueObject);
            this.skipComment();
        }
        if (c == '}') {
            result.put(key, valueObject);
            return result;
        }
        throw this.buildError("\u65e0\u6548\u5bf9\u8c61\u8bed\u6cd5");
    }

    protected List<Object> findList() {
        ArrayList<Object> result = new ArrayList<Object>();
        ++this.start;
        this.skipComment();
        int c = this.value.charAt(this.start);
        if (c == 93) {
            ++this.start;
            return result;
        }
        c = 44;
        while (c != 93) {
            if (c == 44) {
                if (!this.strict) {
                    this.skipComment();
                    if (this.value.charAt(this.start) == ']') {
                        ++this.start;
                        return result;
                    }
                    if (this.value.charAt(this.start) == ',') {
                        ++this.start;
                        this.skipComment();
                        continue;
                    }
                }
            } else {
                throw this.buildError("\u65e0\u6548\u6570\u7ec4\u8bed\u6cd5:" + this.value.substring(Math.max(0, c - 2), Math.min(c + 10, this.value.length())));
            }
            result.add(this.parse());
            this.skipComment();
            c = this.value.charAt(this.start++);
        }
        return result;
    }

    private long parseHex() {
        long lvalue = 0L;
        while (this.start < this.end) {
            char c;
            if ((c = this.value.charAt(this.start++)) >= '0' && c <= '9') {
                lvalue = (lvalue << 4) + (long)(c - 48);
                continue;
            }
            if (c >= 'A' && c <= 'F') {
                lvalue = (lvalue << 4) + (long)(c - 65 + 10);
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                lvalue = (lvalue << 4) + (long)(c - 97 + 10);
                continue;
            }
            --this.start;
            break;
        }
        return lvalue;
    }

    private int parseOctal() {
        int lvalue = 0;
        while (this.start < this.end) {
            char c;
            if ((c = this.value.charAt(this.start++)) >= '0' && c < '8') {
                lvalue = (lvalue << 3) + (c - 48);
                continue;
            }
            --this.start;
            break;
        }
        return lvalue;
    }

    private void seekDecimal() {
        while (this.start < this.end) {
            char c;
            if ((c = this.value.charAt(this.start++)) >= '0' && c <= '9') continue;
            --this.start;
            break;
        }
    }

    private void seekNegative() {
        char c;
        if ((c = this.value.charAt(this.start++)) != '-' && c != '+') {
            --this.start;
        }
    }

    private Number parseZero(boolean neg) {
        if (this.start < this.end) {
            char c;
            if ((c = this.value.charAt(this.start++)) == 'x' || c == 'X') {
                if (this.strict) {
                    throw this.buildError("JSON\u672a\u5b9a\u4e4916\u8fdb\u5236\u6570\u5b57");
                }
                long value = this.parseHex();
                if (neg) {
                    value = -value;
                }
                return value;
            }
            if (c > '0' && c <= '7') {
                if (this.strict) {
                    throw this.buildError("JSON\u672a\u5b9a\u4e498\u8fdb\u5236\u6570\u5b57");
                }
                --this.start;
                int value = this.parseOctal();
                if (neg) {
                    value = -value;
                }
                return value;
            }
            if (c == '.') {
                --this.start;
                return this.parseFloat(this.start - 1);
            }
            --this.start;
            return 0;
        }
        return 0;
    }

    private Number parseFloat(int begin) {
        boolean isFloatingPoint = false;
        char next = this.value.charAt(this.start);
        if (next == '.') {
            ++this.start;
            int p = this.start;
            this.seekDecimal();
            if (this.start == p) {
                --this.start;
                String ns = this.value.substring(begin, this.start);
                return Long.parseLong(ns);
            }
            isFloatingPoint = true;
            next = this.start < this.end ? this.value.charAt(this.start) : (char)'\u0000';
        }
        if (next == 'E' || next == 'e') {
            ++this.start;
            isFloatingPoint = true;
            this.seekNegative();
            this.seekDecimal();
        }
        String ns = this.value.substring(begin, this.start);
        if (isFloatingPoint) {
            return Double.parseDouble(ns);
        }
        return Long.parseLong(ns);
    }

    protected Number findNumber() {
        char c;
        int begin = this.start;
        boolean nag = false;
        if ((c = this.value.charAt(this.start++)) == '+') {
            c = this.value.charAt(this.start++);
        } else if (c == '-') {
            nag = true;
            c = this.value.charAt(this.start++);
        }
        if (c == '0') {
            return this.parseZero(nag);
        }
        return this.parseNumber(begin, nag, c);
    }

    private Number parseNumber(int begin, boolean nag, char c) {
        long ivalue = c - 48;
        while (this.start < this.end) {
            if ((c = this.value.charAt(this.start++)) >= '0' && c <= '9') {
                ivalue = ivalue * 10L + (long)(c - 48);
                continue;
            }
            if (c == '.' || c == 'E') {
                --this.start;
                return this.parseFloat(begin);
            }
            --this.start;
            break;
        }
        return nag ? -ivalue : ivalue;
    }

    protected String findId() {
        char c;
        int p = this.start;
        if (Character.isJavaIdentifierPart(c = this.value.charAt(p++))) {
            while (p < this.end && Character.isJavaIdentifierPart(c = this.value.charAt(p))) {
                ++p;
            }
            this.start = p;
            return this.value.substring(this.start, this.start);
        }
        throw this.buildError("\u65e0\u6548id:" + c);
    }

    protected String findString() {
        char quoteChar = this.value.charAt(this.start++);
        StringBuilder buf = new StringBuilder();
        block19: while (this.start < this.end) {
            char c = this.value.charAt(this.start++);
            switch (c) {
                case '\\': {
                    char c2 = this.value.charAt(this.start++);
                    switch (c2) {
                        case 'b': {
                            buf.append('\b');
                            continue block19;
                        }
                        case 'f': {
                            buf.append('\f');
                            continue block19;
                        }
                        case 'n': {
                            buf.append('\n');
                            continue block19;
                        }
                        case 'r': {
                            buf.append('\r');
                            continue block19;
                        }
                        case 't': {
                            buf.append('\t');
                            continue block19;
                        }
                        case 'v': {
                            buf.append(11);
                            continue block19;
                        }
                        case ' ': {
                            buf.append(' ');
                            continue block19;
                        }
                        case '/': 
                        case '\\': {
                            buf.append(c2);
                            continue block19;
                        }
                        case '\'': {
                            buf.append('\'');
                            continue block19;
                        }
                        case '\"': {
                            buf.append('\"');
                            continue block19;
                        }
                        case 'u': {
                            buf.append((char)Integer.parseInt(this.value.substring(this.start, this.start + 4), 16));
                            this.start += 4;
                            continue block19;
                        }
                        case 'x': {
                            buf.append((char)Integer.parseInt(this.value.substring(this.start, this.start + 2), 16));
                            this.start += 2;
                            continue block19;
                        }
                    }
                    if (this.strict) {
                        throw this.buildError("\u53d1\u73b0JSON \u6807\u51c6\u672a\u5b9a\u4e49\u8f6c\u4e49\u5b57\u7b26");
                    }
                    buf.append(c);
                    buf.append(c2);
                    continue block19;
                }
                case '\"': 
                case '\'': {
                    if (c == quoteChar) {
                        return buf.toString();
                    }
                    buf.append(c);
                    continue block19;
                }
                case '\n': 
                case '\r': {
                    throw this.buildError("JSON \u6807\u51c6\u5b57\u7b26\u4e32\u4e0d\u80fd\u6362\u884c");
                }
            }
            buf.append(c);
        }
        throw this.buildError("\u672a\u7ed3\u675f\u5b57\u7b26\u4e32");
    }

    protected void skipComment() {
        block8: {
            block0: while (true) {
                char next;
                if (this.start < this.end && Character.isWhitespace(this.value.charAt(this.start))) {
                    ++this.start;
                    continue;
                }
                if (this.start >= this.end || this.value.charAt(this.start) != '/') break block8;
                if (this.strict) {
                    throw this.buildError("JSON \u6807\u51c6\u672a\u5b9a\u4e49\u6ce8\u91ca");
                }
                ++this.start;
                if ((next = this.value.charAt(this.start++)) == '/') {
                    int end2;
                    int end1 = this.value.indexOf(10, this.start);
                    int cend = Math.min(end1, end2 = this.value.indexOf(13, this.start));
                    if (cend < 0) {
                        cend = Math.max(end1, end2);
                    }
                    if (cend > 0) {
                        this.start = cend;
                        continue;
                    }
                    this.start = this.end;
                    continue;
                }
                if (next != '*') continue;
                int cend = this.start + 1;
                while ((cend = this.value.indexOf(47, cend)) > 0) {
                    if (this.value.charAt(cend - 1) == '*') {
                        this.start = cend + 1;
                        continue block0;
                    }
                    ++cend;
                }
                break;
            }
            throw this.buildError("\u672a\u7d50\u675f\u6ce8\u91cb");
        }
    }
}

