/*
 * Decompiled with CFR 0.152.
 */
package org.xidea.el.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.xidea.el.Expression;
import org.xidea.el.ExpressionFactory;
import org.xidea.el.ExpressionToken;
import org.xidea.el.OperationStrategy;
import org.xidea.el.impl.ExpressionImpl;
import org.xidea.el.impl.PropertiesImpl;
import org.xidea.el.impl.PropertyImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptimizeExpressionImpl
extends ExpressionImpl {
    protected String name;

    public OptimizeExpressionImpl(ExpressionToken expression, ExpressionFactory factory, OperationStrategy calculater, String name) {
        super(expression, factory, calculater);
        this.name = name;
    }

    @Override
    public List<String> getVars() {
        return Arrays.asList(this.name);
    }

    @Override
    public Object evaluate(Object context) {
        Map<String, Object> contextMap = this.factory.wrapAsContext(context);
        return this.compute(contextMap);
    }

    protected Object compute(Map<String, Object> valueStack) {
        return this.strategy.getVar(valueStack, this.name);
    }

    public static Expression create(ExpressionToken el, ExpressionFactory factory, OperationStrategy calculater) {
        if (el.getType() == -2) {
            return new OptimizeExpressionImpl(el, factory, calculater, (String)el.getParam());
        }
        if (el.getType() == 32) {
            ArrayList<Object> props = new ArrayList<Object>();
            ExpressionToken current = el;
            String baseName = null;
            while (true) {
                if (current.getType() != 32) {
                    if (current.getType() == -2) break;
                    return null;
                }
                props.add(current.getParam());
                current = current.getLeft();
            }
            baseName = (String)current.getParam();
            Object[] properties = props.toArray();
            switch (properties.length) {
                case 1: {
                    return new PropertyImpl(el, factory, calculater, baseName, properties[0]);
                }
            }
            return new PropertiesImpl(el, factory, calculater, baseName, properties);
        }
        return null;
    }
}

