/*
 * Decompiled with CFR 0.152.
 */
package org.xidea.el.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xidea.el.Expression;
import org.xidea.el.ExpressionFactory;
import org.xidea.el.ExpressionToken;
import org.xidea.el.Invocable;
import org.xidea.el.OperationStrategy;
import org.xidea.el.fn.ECMA262Impl;
import org.xidea.el.impl.ExpressionImpl;
import org.xidea.el.impl.ExpressionParser;
import org.xidea.el.impl.MethodInvocable;
import org.xidea.el.impl.OperationStrategyImpl;
import org.xidea.el.impl.OptimizeExpressionImpl;
import org.xidea.el.impl.TokenImpl;
import org.xidea.el.impl.ValueStackImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionFactoryImpl
implements ExpressionFactory {
    private static ExpressionFactoryImpl expressionFactory;
    private static ValueStackImpl EMPTY_VS;
    protected final OperationStrategy strategy;
    protected Map<String, Integer> aliseMap = new HashMap<String, Integer>();
    private int inc = 1;
    private boolean optimize = true;
    private static Map<String, Invocable> cachedInvocableMap;

    public static ExpressionFactoryImpl getInstance() {
        if (expressionFactory == null) {
            expressionFactory = new ExpressionFactoryImpl();
            ExpressionFactoryImpl.expressionFactory.aliseMap = Collections.emptyMap();
            ExpressionFactoryImpl.expressionFactory.getImpl().customizable = false;
        }
        return expressionFactory;
    }

    public ExpressionFactoryImpl(OperationStrategy strategy) {
        this.strategy = strategy;
    }

    public OperationStrategy getStrategy() {
        return this.getImpl();
    }

    public ExpressionFactoryImpl() {
        OperationStrategyImpl strategy = new OperationStrategyImpl(true);
        this.strategy = strategy;
        ECMA262Impl.setup(this);
    }

    private OperationStrategyImpl getImpl() {
        if (this.strategy instanceof OperationStrategyImpl) {
            return (OperationStrategyImpl)this.strategy;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void addVar(String var, Object value) {
        this.getImpl().addVar(var, value);
    }

    public void addMethod(Class<? extends Object> clazz, String name, Invocable invocable) {
        this.getImpl().addMethod(clazz, name, invocable);
    }

    private Invocable toInvocable(Object impl) {
        Method method;
        if (impl instanceof Method && Modifier.isPublic((method = (Method)impl).getModifiers()) && Modifier.isStatic(method.getModifiers())) {
            impl = ExpressionFactoryImpl.createProxy(method);
        }
        if (impl instanceof Invocable) {
            return (Invocable)impl;
        }
        throw new IllegalArgumentException("\u652f\u6301public static \u683c\u5f0f\u7684\u51fd\u6570\u6216\u8005org.xidea.el.Invocable \u5bf9\u8c61");
    }

    public void addOperator(int sampleToken, String name, Object impl) {
        if (impl == null) {
            this.aliseMap.put(name, sampleToken);
        } else {
            this.aliseMap.put(name, sampleToken += this.inc++ << 12);
            this.getImpl().addVar(sampleToken, this.toInvocable(impl));
        }
    }

    @Override
    public Object parse(String el) {
        ExpressionParser ep = new ExpressionParser(el);
        ep.setAliasMap(this.aliseMap);
        TokenImpl tokens = ep.parseEL();
        if (this.optimize) {
            tokens = tokens.optimize(this.strategy, Collections.EMPTY_MAP);
        }
        return tokens;
    }

    @Override
    public Expression create(Object elo) {
        if (elo instanceof String) {
            return this.create(this.parse((String)elo));
        }
        ExpressionToken el = elo instanceof ExpressionToken ? (ExpressionToken)elo : TokenImpl.toToken((List)elo);
        return this.createExpression(el);
    }

    protected Expression createExpression(ExpressionToken el) {
        Expression ressult;
        if (this.optimize && (ressult = OptimizeExpressionImpl.create(el, this, this.strategy)) != null) {
            return ressult;
        }
        return new ExpressionImpl(el, this, this.strategy);
    }

    public static Invocable createProxy(Method ... methods) {
        for (Method method : methods) {
            try {
                method.setAccessible(true);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        MethodInvocable inv = new MethodInvocable();
        inv.methods = methods;
        return inv;
    }

    static Invocable getInvocable(Class<? extends Object> clazz, String name, int length) {
        String key = clazz.getName() + '.' + length + name;
        Invocable result = cachedInvocableMap.get(key);
        if (result == null && !cachedInvocableMap.containsKey(key)) {
            ArrayList<Method> methods = new ArrayList<Method>();
            for (Method method : clazz.getMethods()) {
                if (!method.getName().equals(name) || length >= 0 && method.getParameterTypes().length != length) continue;
                methods.add(method);
            }
            if (methods.size() > 0) {
                result = ExpressionFactoryImpl.createProxy(methods.toArray(new Method[methods.size()]));
                cachedInvocableMap.put(key, result);
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> wrapAsContext(Object context) {
        Map valueStack = context instanceof Map ? (Map)context : (context == null ? EMPTY_VS : new ValueStackImpl(context));
        return valueStack;
    }

    static {
        EMPTY_VS = new ValueStackImpl(Collections.emptyMap());
        cachedInvocableMap = new HashMap<String, Invocable>();
    }
}

