/*
 * Decompiled with CFR 0.152.
 */
package org.xidea.el.impl;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xidea.el.impl.Convertor;
import org.xidea.el.impl.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultConvertor
implements Convertor<Object> {
    private static Log log = LogFactory.getLog(DefaultConvertor.class);

    DefaultConvertor() {
    }

    static Map<Class<?>, Convertor<?>> toMap() {
        Class[] SUPPORTS = new Class[]{File.class, URL.class, URI.class, Long.TYPE, Long.class, Integer.TYPE, Integer.class, Double.TYPE, Double.class, Short.TYPE, Short.class, Byte.TYPE, Byte.class, Boolean.TYPE, Boolean.class, Character.TYPE, Character.class, String.class, Object.class};
        HashMap<Class, Convertor<Object>> map = new HashMap<Class, Convertor<Object>>();
        for (Class type : SUPPORTS) {
            map.put(type, Convertor.DEFAULT);
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public Object getValue(String value, Class<? extends Object> expectedType, Object context, String key) {
        boolean primitive = expectedType.isPrimitive();
        Class<? extends Object> clazz = primitive ? ReflectUtil.toWrapper(expectedType) : expectedType;
        try {
            if (value == null) {
                if (primitive) {
                    if (Number.class.isAssignableFrom(clazz)) {
                        value = "0";
                    } else {
                        if (clazz == Boolean.class) {
                            return false;
                        }
                        if (clazz == Character.class) {
                            return Character.valueOf('\u0000');
                        }
                    }
                } else {
                    return null;
                }
            }
            if (expectedType.isInstance(value)) {
                return value;
            }
            try {
                if (clazz == Boolean.class) {
                    if (value.length() == 0 || value.equalsIgnoreCase("false") || value.equals("0") || value.equals("0.0")) {
                        return false;
                    }
                    return true;
                }
                Constructor<? extends Object> constructor = clazz.getConstructor(String.class);
                try {
                    return constructor.newInstance(value);
                }
                catch (InvocationTargetException e) {
                    if (primitive && e.getTargetException() instanceof NumberFormatException) {
                        return this.getValue("0", expectedType, context, key);
                    }
                }
            }
            catch (NoSuchMethodException e) {
                Class<?> clazz2;
                if (Character.class == clazz) {
                    if (value.length() == 0) {
                        if (primitive) {
                            return Character.valueOf('\u0000');
                        }
                    } else {
                        return Character.valueOf(value.charAt(0));
                    }
                }
                if (expectedType.isAssignableFrom(clazz2 = Class.forName(value))) {
                    return clazz2.newInstance();
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
        return null;
    }
}

