/*
 * Decompiled with CFR 0.152.
 */
package org.xidea.el.fn;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.xidea.el.Invocable;
import org.xidea.el.fn.ECMA262Impl;
import org.xidea.el.fn.JSObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JSArray
extends JSObject
implements Invocable {
    JSArray() {
    }

    @Override
    public Object invoke(Object thiz, Object ... args) throws Exception {
        return this.method.invoke((Object)this, JSArray.toList(thiz), args);
    }

    private static final Object toList(Object thiz) {
        if (thiz instanceof Object[]) {
            thiz = Arrays.asList((Object[])thiz);
        } else if (thiz.getClass().isArray()) {
            int length = Array.getLength(thiz);
            ArrayList<Object> buf = new ArrayList<Object>(length);
            for (int i = 0; i < length; ++i) {
                buf.add(Array.get(thiz, 1));
            }
            thiz = buf;
        }
        return thiz;
    }

    static int toSliceRange(int pos, int size) {
        pos = pos < 0 ? Math.max(pos + size, 0) : Math.min(pos, size);
        return pos;
    }

    public Object splice(List<Object> thiz, Object ... args) throws Exception {
        return this.slice(thiz, args);
    }

    public Object slice(List<Object> thiz, Object ... args) throws Exception {
        int end;
        int size = thiz.size();
        int begin = JSArray.toSliceRange(JSObject.getIntArg(args, 0, 0), size);
        if (begin < (end = JSArray.toSliceRange(JSObject.getIntArg(args, 1, size), size))) {
            return thiz.subList(begin, end);
        }
        return Collections.EMPTY_LIST;
    }

    public Object join(List<Object> thiz, Object ... args) {
        StringBuilder buf = new StringBuilder();
        String joiner = null;
        boolean isFirst = true;
        for (Object o : thiz) {
            if (isFirst) {
                isFirst = false;
                joiner = args.length > 0 ? JSObject.getStringArg(args, 0, ",") : ",";
            } else {
                buf.append(joiner);
            }
            if (o == null) continue;
            buf.append(ECMA262Impl.ToString(o));
        }
        return buf.toString();
    }

    public Object toString(List<Object> thiz, Object ... args) {
        return this.join(thiz, ",");
    }

    public Object push(List<Object> thiz, Object ... args) {
        for (Object o : args) {
            thiz.add(o);
        }
        return thiz.size();
    }

    public Object pop(List<Object> thiz, Object ... args) {
        int size = thiz.size();
        if (size > 0) {
            return thiz.remove(size - 1);
        }
        return null;
    }

    public Object shift(List<Object> thiz, Object ... args) {
        int size = thiz.size();
        if (size > 0) {
            return thiz.remove(0);
        }
        return null;
    }

    public Object unshift(List<Object> thiz, Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            thiz.add(i, args[i]);
        }
        return thiz.size();
    }

    public Object concat(List<Object> thiz, Object ... args) {
        ArrayList<Object> result = new ArrayList<Object>(thiz);
        for (Object o : args) {
            if ((o = JSArray.toList(o)) instanceof Collection) {
                result.addAll((Collection)o);
                continue;
            }
            result.add(o);
        }
        return result;
    }

    public Object reverse(List<Object> thiz, Object ... args) {
        Collections.reverse(thiz);
        return thiz;
    }

    public Object sort(List<Object> thiz, Object ... args) {
        Object o = JSObject.getArg(args, 0, null);
        Comparator c = null;
        if (o instanceof Comparator) {
            c = (Comparator)o;
        }
        Collections.sort(thiz, c);
        return thiz;
    }
}

