/*
 * Decompiled with CFR 0.152.
 */
package org.xhtmlrenderer.pdf;

import com.itextpdf.text.pdf.PdfAnnotation;
import com.itextpdf.text.pdf.PdfAppearance;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfFormField;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xhtmlrenderer.css.parser.FSColor;
import org.xhtmlrenderer.css.style.CssContext;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.pdf.AbstractFormField;
import org.xhtmlrenderer.pdf.ITextFSFont;
import org.xhtmlrenderer.pdf.ITextOutputDevice;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.render.Box;
import org.xhtmlrenderer.render.RenderingContext;
import org.xhtmlrenderer.util.TextUtil;
import org.xhtmlrenderer.util.Util;

public class SelectFormField
extends AbstractFormField {
    private static final String FIELD_TYPE = "Select";
    private static final int EMPTY_SPACE_COUNT = 10;
    private static final int EXTRA_SPACE_COUNT = 4;
    private final List<Option> _options;
    private final int _baseline;

    public SelectFormField(LayoutContext c, BlockBox box, int cssWidth, int cssHeight) {
        this._options = this.readOptions(box.getElement());
        this.initDimensions(c, box, cssWidth, cssHeight);
        float fontSize = box.getStyle().getFSFont((CssContext)c).getSize2D();
        this._baseline = (int)((float)(this.getHeight() / 2) + fontSize * 0.3f);
    }

    private int getSelectedIndex() {
        int result = 0;
        int offset = 0;
        for (Option option : this._options) {
            if (option.isSelected()) {
                result = offset;
            }
            ++offset;
        }
        return result;
    }

    private String[][] getPDFOptions() {
        List<Option> options = this._options;
        String[][] result = new String[options.size()][];
        int offset = 0;
        for (Option option : options) {
            result[offset] = new String[]{option.getValue(), option.getLabel()};
            ++offset;
        }
        return result;
    }

    private int calcDefaultWidth(LayoutContext c, BlockBox box) {
        List<Option> options = this._options;
        if (options.isEmpty()) {
            return c.getTextRenderer().getWidth(c.getFontContext(), box.getStyle().getFSFont((CssContext)c), this.spaces(10));
        }
        int maxWidth = 0;
        for (Option option : options) {
            String result = option.getLabel() + this.spaces(4);
            int width = c.getTextRenderer().getWidth(c.getFontContext(), box.getStyle().getFSFont((CssContext)c), result);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        return maxWidth;
    }

    private List<Option> readOptions(Element e) {
        ArrayList<Option> result = new ArrayList<Option>();
        for (Node n = e.getFirstChild(); n != null; n = n.getNextSibling()) {
            String value;
            if (n.getNodeType() != 1 || !n.getNodeName().equalsIgnoreCase("option")) continue;
            Element optionElement = (Element)n;
            String label = TextUtil.readTextContentOrNull((Element)optionElement);
            Attr valueAttribute = optionElement.getAttributeNode("value");
            String string = value = valueAttribute == null ? label : valueAttribute.getValue();
            if (label == null) continue;
            Option option = new Option();
            option.setLabel(label);
            option.setValue(value);
            if (this.isSelected(optionElement)) {
                option.setSelected(true);
            }
            result.add(option);
        }
        return result;
    }

    @Override
    protected void initDimensions(LayoutContext c, BlockBox box, int cssWidth, int cssHeight) {
        if (cssWidth != -1) {
            this.setWidth(cssWidth);
        } else {
            this.setWidth(this.calcDefaultWidth(c, box));
        }
        if (cssHeight != -1) {
            this.setHeight(cssHeight);
        } else {
            this.setHeight((int)(box.getStyle().getLineHeight((CssContext)c) * (float)this.getSize(box.getElement())));
        }
    }

    private int getSize(Element elem) {
        try {
            int i;
            String v = elem.getAttribute("size").trim();
            if (!v.isEmpty() && (i = Integer.parseInt(v)) > 1) {
                return i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return 1;
    }

    protected boolean isMultiple(Element e) {
        return !Util.isNullOrEmpty((String)e.getAttribute("multiple"));
    }

    @Override
    protected String getFieldType() {
        return FIELD_TYPE;
    }

    @Override
    public void paint(RenderingContext c, ITextOutputDevice outputDevice, BlockBox box) {
        PdfWriter writer = outputDevice.getWriter();
        String[][] options = this.getPDFOptions();
        int selectedIndex = this.getSelectedIndex();
        PdfFormField field = PdfFormField.createCombo((PdfWriter)writer, (boolean)false, (String[][])options, (int)selectedIndex);
        field.setWidget(outputDevice.createLocalTargetArea(c, (Box)box), PdfAnnotation.HIGHLIGHT_INVERT);
        field.setFieldName(this.getFieldName(outputDevice, box.getElement()));
        if (options.length > 0) {
            field.setValueAsString(options[selectedIndex][0]);
        }
        this.createAppearance(c, outputDevice, box, field);
        if (this.isReadOnly(box.getElement())) {
            field.setFieldFlags(1);
        }
        writer.addAnnotation((PdfAnnotation)field);
    }

    private void createAppearance(RenderingContext c, ITextOutputDevice outputDevice, BlockBox box, PdfFormField field) {
        PdfWriter writer = outputDevice.getWriter();
        ITextFSFont font = (ITextFSFont)box.getStyle().getFSFont((CssContext)c);
        PdfContentByte cb = writer.getDirectContent();
        float width = outputDevice.getDeviceLength(this.getWidth());
        float height = outputDevice.getDeviceLength(this.getHeight());
        float fontSize = outputDevice.getDeviceLength(font.getSize2D());
        PdfAppearance tp = cb.createAppearance(width, height);
        tp.setFontAndSize(font.getFontDescription().getFont(), fontSize);
        FSColor color = box.getStyle().getColor();
        this.setFillColor((PdfTemplate)tp, color);
        field.setDefaultAppearanceString((PdfContentByte)tp);
    }

    public int getBaseline() {
        return this._baseline;
    }

    public boolean hasBaseline() {
        return true;
    }

    private static final class Option {
        private String _value;
        private String _label;
        private boolean _selected;

        private Option() {
        }

        public String getValue() {
            return this._value;
        }

        public void setValue(String value) {
            this._value = value;
        }

        public String getLabel() {
            return this._label;
        }

        public void setLabel(String label) {
            this._label = label;
        }

        public boolean isSelected() {
            return this._selected;
        }

        public void setSelected(boolean selected) {
            this._selected = selected;
        }
    }
}

