/*
 * Decompiled with CFR 0.152.
 */
package org.xBaseJ.fields;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.xBaseJ.fields.Field;
import org.xBaseJ.xBaseJException;

public class NumField
extends Field {
    private static final long serialVersionUID = 1L;
    private byte decPosition = 0;
    static DecimalFormatSymbols dfs = new DecimalFormatSymbols();
    static char decimalSeparator = dfs.getDecimalSeparator();

    public NumField() {
    }

    public Object clone() throws CloneNotSupportedException {
        NumField tField = (NumField)super.clone();
        tField.Name = new String(this.Name);
        tField.Length = this.Length;
        tField.decPosition = this.decPosition;
        return tField;
    }

    public NumField(String iName, int iLength, int idecPosition, ByteBuffer inBuffer) throws xBaseJException {
        super.setField(iName, iLength, inBuffer);
        this.decPosition = (byte)idecPosition;
        this.put("");
    }

    public NumField(String iName, int iLength, int inDecPosition) throws xBaseJException, IOException {
        super.setField(iName, iLength, null);
        this.decPosition = (byte)inDecPosition;
    }

    public char getType() {
        return 'N';
    }

    public int getDecimalPositionCount() {
        return this.decPosition;
    }

    public String get() {
        int i;
        String value = super.get();
        if (value.trim().length() == 0) {
            return "";
        }
        for (i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == ' ') continue;
            return value;
        }
        StringBuffer format = new StringBuffer();
        int decoffset = this.Length - this.decPosition - 1;
        for (i = 0; i < decoffset - 1; ++i) {
            format.append(' ');
        }
        if (decoffset > 0) {
            format.append('0');
        }
        if (this.decPosition > 0) {
            format.append(decimalSeparator);
            for (i = 0; i < this.decPosition; ++i) {
                format.append('0');
            }
        }
        return format.toString();
    }

    public void put(String inValue) throws xBaseJException {
        int i4;
        int i3;
        int i2;
        int i1;
        try {
            Double.valueOf(inValue);
        }
        catch (NumberFormatException nfe) {
            super.put("");
            return;
        }
        int worklen = this.Length > inValue.length() ? this.Length : inValue.length();
        char[] charArray = new char[this.Length];
        for (i1 = 0; i1 < this.Length; ++i1) {
            charArray[i1] = 32;
        }
        for (i1 = 0; i1 < inValue.length() && inValue.charAt(i1) != '-' && inValue.charAt(i1) != decimalSeparator && (inValue.charAt(i1) < '0' || inValue.charAt(i1) > '9'); ++i1) {
        }
        boolean neg = false;
        if (inValue.charAt(i1) == '-') {
            neg = true;
            ++i1;
        }
        char[] intForm = new char[worklen];
        int breaklen = this.decPosition == 0 ? worklen : worklen - 1;
        for (i2 = 0; i2 < breaklen && i1 < inValue.length() && inValue.charAt(i1) >= '0' && inValue.charAt(i1) <= '9'; ++i1, ++i2) {
            intForm[i2] = inValue.charAt(i1);
        }
        if (i1 < inValue.length() && inValue.charAt(i1) == decimalSeparator) {
            ++i1;
        }
        char[] decForm = new char[worklen];
        for (i3 = 0; i3 < breaklen; ++i3) {
            decForm[i3] = 48;
        }
        for (i3 = 0; i3 < breaklen && i1 < inValue.length() && inValue.charAt(i1) >= '0' && inValue.charAt(i1) <= '9'; ++i1, ++i3) {
            decForm[i3] = inValue.charAt(i1);
        }
        int startpos = this.Length - this.decPosition - 1;
        if (this.decPosition > 0) {
            charArray[startpos] = decimalSeparator;
            --startpos;
        }
        for (i4 = startpos; i4 > -1 && --i2 >= 0; --i4) {
            charArray[i4] = intForm[i2];
        }
        if (neg) {
            if (i4 < 0) {
                charArray[0] = 45;
            } else {
                charArray[i4] = 45;
            }
        }
        if (this.decPosition > 0) {
            startpos += 2;
            for (i4 = 1; i4 <= this.decPosition; ++i4) {
                charArray[startpos] = decForm[i4 - 1];
                ++startpos;
            }
        }
        super.put(new String(charArray).replace(decimalSeparator, '.'));
    }

    public void put(long inValue) throws xBaseJException {
        this.put(String.valueOf(inValue));
    }

    public void put(int inValue) throws xBaseJException {
        this.put(String.valueOf(inValue));
    }

    public void put(float inValue) throws xBaseJException {
        StringBuffer sb = new StringBuffer(this.getLength() + 1);
        sb.append("#");
        for (int i = 0; i < this.getLength(); ++i) {
            sb.append("#");
        }
        DecimalFormat df = new DecimalFormat(sb.toString());
        String s = df.format(inValue).trim();
        this.put(s);
    }

    public void put(double inValue) throws xBaseJException {
        StringBuffer sb = new StringBuffer(this.getLength() + 1);
        sb.append("#");
        for (int i = 0; i < this.getLength(); ++i) {
            sb.append("#");
        }
        if (this.decPosition > 0) {
            int pos = this.getLength() - this.getDecimalPositionCount();
            sb.setCharAt(pos, decimalSeparator);
            ++pos;
            while (pos < this.getLength() + 1) {
                sb.setCharAt(pos, '0');
                ++pos;
            }
        }
        DecimalFormat df = new DecimalFormat(sb.toString());
        String s = df.format(inValue).trim();
        this.put(s);
    }
}

