/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssh.util;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.loader.openssh.OpenSSHKeyPairResourceParser;
import org.wildfly.common.Assert;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.pem.Pem;
import org.wildfly.security.pem.PemEntry;
import org.wildfly.security.ssh.util._pivate.ElytronMessages;

public class SshUtil {
    public static final String OPENSSH_PRIVATE_KEY_FORMAT = "OPENSSH PRIVATE KEY";

    public static Iterator<PemEntry<?>> parsePemOpenSSHContent(final CodePointIterator pemContent, final FilePasswordProvider passphraseProvider) throws IllegalArgumentException {
        Assert.checkNotNullParam((String)"pemContent", (Object)pemContent);
        return new Iterator<PemEntry<?>>(){
            private PemEntry<?> next;

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    if (!pemContent.hasNext()) {
                        return false;
                    }
                    this.next = Pem.parsePemContent(pemContent, (type, byteIterator) -> {
                        switch (type) {
                            case "OPENSSH PRIVATE KEY": {
                                KeyPair keyPair = SshUtil.parseOpenSSHKeys(byteIterator, passphraseProvider);
                                return new PemEntry<KeyPair>(keyPair);
                            }
                        }
                        throw ElytronMessages.log.malformedSshPemContent(pemContent.getIndex());
                    });
                    if (this.next == null) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public PemEntry<?> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                try {
                    PemEntry<?> pemEntry = this.next;
                    return pemEntry;
                }
                finally {
                    this.next = null;
                }
            }
        };
    }

    private static KeyPair parseOpenSSHKeys(ByteIterator byteIterator, FilePasswordProvider passphraseProvider) throws IllegalArgumentException {
        OpenSSHKeyPairResourceParser resourceParser = new OpenSSHKeyPairResourceParser();
        byte[] stream = byteIterator.drain();
        try {
            return resourceParser.extractKeyPairs(null, null, "BEGIN OPENSSH PRIVATE KEY", "END OPENSSH PRIVATE KEY", passphraseProvider, stream, null).iterator().next();
        }
        catch (IOException e) {
            throw ElytronMessages.log.openSshParseError(e.getMessage());
        }
        catch (GeneralSecurityException e) {
            throw ElytronMessages.log.openSshGeneratingError(e.getMessage());
        }
    }
}

